/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.math.tdcomplex;

import cern.colt.function.tdcomplex.DComplexDComplexDComplexFunction;
import cern.jet.math.tdcomplex.DComplex;

public class DComplexPlusMultSecond
implements DComplexDComplexDComplexFunction {
    public double[] multiplicator;

    protected DComplexPlusMultSecond(double[] multiplicator) {
        this.multiplicator = multiplicator;
    }

    public final double[] apply(double[] a, double[] b) {
        double[] z = new double[]{b[0] * this.multiplicator[0] - b[1] * this.multiplicator[1], b[1] * this.multiplicator[0] + b[0] * this.multiplicator[1]};
        z[0] = z[0] + a[0];
        z[1] = z[1] + a[1];
        return z;
    }

    public static DComplexPlusMultSecond minusDiv(double[] constant) {
        return new DComplexPlusMultSecond(DComplex.neg(DComplex.inv(constant)));
    }

    public static DComplexPlusMultSecond minusMult(double[] constant) {
        return new DComplexPlusMultSecond(DComplex.neg(constant));
    }

    public static DComplexPlusMultSecond plusDiv(double[] constant) {
        return new DComplexPlusMultSecond(DComplex.inv(constant));
    }

    public static DComplexPlusMultSecond plusMult(double[] constant) {
        return new DComplexPlusMultSecond(constant);
    }
}

