/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.impl;

import cern.colt.map.tobject.AbstractLongObjectMap;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.impl.SelectedSparseObjectMatrix1D;
import cern.colt.matrix.tobject.impl.SparseObjectMatrix1D;
import cern.colt.matrix.tobject.impl.SparseObjectMatrix2D;

class SelectedSparseObjectMatrix2D
extends ObjectMatrix2D {
    private static final long serialVersionUID = 1L;
    protected AbstractLongObjectMap elements;
    protected int[] rowOffsets;
    protected int[] columnOffsets;
    protected int offset;

    protected SelectedSparseObjectMatrix2D(int rows, int columns, AbstractLongObjectMap elements, int rowZero, int columnZero, int rowStride, int columnStride, int[] rowOffsets, int[] columnOffsets, int offset) {
        this.setUp(rows, columns, rowZero, columnZero, rowStride, columnStride);
        this.elements = elements;
        this.rowOffsets = rowOffsets;
        this.columnOffsets = columnOffsets;
        this.offset = offset;
        this.isNoView = false;
    }

    protected SelectedSparseObjectMatrix2D(AbstractLongObjectMap elements, int[] rowOffsets, int[] columnOffsets, int offset) {
        this(rowOffsets.length, columnOffsets.length, elements, 0, 0, 1, 1, rowOffsets, columnOffsets, offset);
    }

    protected int _columnOffset(int absRank) {
        return this.columnOffsets[absRank];
    }

    protected int _rowOffset(int absRank) {
        return this.rowOffsets[absRank];
    }

    public Object elements() {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public Object getQuick(int row, int column) {
        return this.elements.get((long)this.offset + (long)this.rowOffsets[this.rowZero + row * this.rowStride] + (long)this.columnOffsets[this.columnZero + column * this.columnStride]);
    }

    protected boolean haveSharedCellsRaw(ObjectMatrix2D other) {
        if (other instanceof SelectedSparseObjectMatrix2D) {
            SelectedSparseObjectMatrix2D otherMatrix = (SelectedSparseObjectMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof SparseObjectMatrix2D) {
            SparseObjectMatrix2D otherMatrix = (SparseObjectMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    public long index(int row, int column) {
        return (long)this.offset + (long)this.rowOffsets[this.rowZero + row * this.rowStride] + (long)this.columnOffsets[this.columnZero + column * this.columnStride];
    }

    public ObjectMatrix2D like(int rows, int columns) {
        return new SparseObjectMatrix2D(rows, columns);
    }

    public ObjectMatrix1D like1D(int size) {
        return new SparseObjectMatrix1D(size);
    }

    protected ObjectMatrix1D like1D(int size, int zero, int stride) {
        throw new InternalError();
    }

    public void setQuick(int row, int column, Object value) {
        long index = (long)this.offset + (long)this.rowOffsets[this.rowZero + row * this.rowStride] + (long)this.columnOffsets[this.columnZero + column * this.columnStride];
        if (value == null) {
            this.elements.removeKey(index);
        } else {
            this.elements.put(index, value);
        }
    }

    protected void setUp(int rows, int columns) {
        super.setUp(rows, columns);
        this.rowStride = 1;
        this.columnStride = 1;
        this.offset = 0;
    }

    public ObjectMatrix1D vectorize() {
        SparseObjectMatrix1D v = new SparseObjectMatrix1D((int)this.size());
        int idx = 0;
        for (int c = 0; c < this.columns; ++c) {
            for (int r = 0; r < this.rows; ++r) {
                v.setQuick(idx++, this.getQuick(c, r));
            }
        }
        return v;
    }

    protected AbstractMatrix2D vDice() {
        super.vDice();
        int[] tmp = this.rowOffsets;
        this.rowOffsets = this.columnOffsets;
        this.columnOffsets = tmp;
        this.isNoView = false;
        return this;
    }

    public ObjectMatrix1D viewColumn(int column) {
        this.checkColumn(column);
        int viewSize = this.rows;
        int viewZero = this.rowZero;
        int viewStride = this.rowStride;
        int[] viewOffsets = this.rowOffsets;
        int viewOffset = this.offset + this._columnOffset(this._columnRank(column));
        return new SelectedSparseObjectMatrix1D(viewSize, this.elements, viewZero, viewStride, viewOffsets, viewOffset);
    }

    public ObjectMatrix1D viewRow(int row) {
        this.checkRow(row);
        int viewSize = this.columns;
        int viewZero = this.columnZero;
        int viewStride = this.columnStride;
        int[] viewOffsets = this.columnOffsets;
        int viewOffset = this.offset + this._rowOffset(this._rowRank(row));
        return new SelectedSparseObjectMatrix1D(viewSize, this.elements, viewZero, viewStride, viewOffsets, viewOffset);
    }

    protected ObjectMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        return new SelectedSparseObjectMatrix2D(this.elements, rowOffsets, columnOffsets, this.offset);
    }
}

