/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject;

import cern.colt.function.tobject.ObjectFunction;
import cern.colt.function.tobject.ObjectObjectFunction;
import cern.colt.function.tobject.ObjectProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tobject.ObjectArrayList;
import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.ObjectMatrix2DProcedure;
import cern.colt.matrix.tobject.algo.ObjectFormatter;
import cern.colt.matrix.tobject.algo.ObjectSorting;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class ObjectMatrix3D
extends AbstractMatrix3D {
    private static final long serialVersionUID = 1L;

    protected ObjectMatrix3D() {
    }

    public Object aggregate(final ObjectObjectFunction aggr, final ObjectFunction f) {
        if (this.size() == 0L) {
            return null;
        }
        Object a = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object a = f.apply(ObjectMatrix3D.this.getQuick(firstSlice, 0, 0));
                        int d = 1;
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < ObjectMatrix3D.this.rows; ++r) {
                                for (int c = d; c < ObjectMatrix3D.this.columns; ++c) {
                                    a = aggr.apply(a, f.apply(ObjectMatrix3D.this.getQuick(s, r, c)));
                                }
                                d = 0;
                            }
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(0, 0, 0));
            int d = 1;
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = d; c < this.columns; ++c) {
                        a = aggr.apply(a, f.apply(this.getQuick(s, r, c)));
                    }
                    d = 0;
                }
            }
        }
        return a;
    }

    public Object aggregate(final ObjectObjectFunction aggr, final ObjectFunction f, final ObjectProcedure cond) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        Object a = null;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object elem = ObjectMatrix3D.this.getQuick(firstSlice, 0, 0);
                        Object a = 0;
                        if (cond.apply(elem)) {
                            a = aggr.apply(a, f.apply(elem));
                        }
                        int d = 1;
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < ObjectMatrix3D.this.rows; ++r) {
                                for (int c = d; c < ObjectMatrix3D.this.columns; ++c) {
                                    elem = ObjectMatrix3D.this.getQuick(s, r, c);
                                    if (cond.apply(elem)) {
                                        a = aggr.apply(a, f.apply(elem));
                                    }
                                    d = 0;
                                }
                            }
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            Object elem = this.getQuick(0, 0, 0);
            if (cond.apply(elem)) {
                a = aggr.apply(a, f.apply(elem));
            }
            int d = 1;
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = d; c < this.columns; ++c) {
                        elem = this.getQuick(s, r, c);
                        if (cond.apply(elem)) {
                            a = aggr.apply(a, f.apply(elem));
                        }
                        d = 0;
                    }
                }
            }
        }
        return a;
    }

    public Object aggregate(final ObjectObjectFunction aggr, final ObjectFunction f, IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        if (sliceList.size() == 0 || rowList.size() == 0 || columnList.size() == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        int size = sliceList.size();
        final int[] sliceElements = sliceList.elements();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        Object a = null;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object a = f.apply(ObjectMatrix3D.this.getQuick(sliceElements[firstIdx], rowElements[firstIdx], columnElements[firstIdx]));
                        for (int i = firstIdx + 1; i < lastIdx; ++i) {
                            Object elem = ObjectMatrix3D.this.getQuick(sliceElements[i], rowElements[i], columnElements[i]);
                            a = aggr.apply(a, f.apply(elem));
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(sliceElements[0], rowElements[0], columnElements[0]));
            for (int i = 1; i < size; ++i) {
                Object elem = this.getQuick(sliceElements[i], rowElements[i], columnElements[i]);
                a = aggr.apply(a, f.apply(elem));
            }
        }
        return a;
    }

    public Object aggregate(final ObjectMatrix3D other, final ObjectObjectFunction aggr, final ObjectObjectFunction f) {
        this.checkShape(other);
        if (this.size() == 0L) {
            return null;
        }
        Object a = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object a = f.apply(ObjectMatrix3D.this.getQuick(firstSlice, 0, 0), other.getQuick(firstSlice, 0, 0));
                        int d = 1;
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < ObjectMatrix3D.this.rows; ++r) {
                                for (int c = d; c < ObjectMatrix3D.this.columns; ++c) {
                                    a = aggr.apply(a, f.apply(ObjectMatrix3D.this.getQuick(s, r, c), other.getQuick(s, r, c)));
                                }
                                d = 0;
                            }
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(0, 0, 0), other.getQuick(0, 0, 0));
            int d = 1;
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = d; c < this.columns; ++c) {
                        a = aggr.apply(a, f.apply(this.getQuick(s, r, c), other.getQuick(s, r, c)));
                    }
                    d = 0;
                }
            }
        }
        return a;
    }

    public ObjectMatrix3D assign(final ObjectProcedure cond, final ObjectFunction f) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < ObjectMatrix3D.this.rows; ++r) {
                                for (int c = 0; c < ObjectMatrix3D.this.columns; ++c) {
                                    Object elem = ObjectMatrix3D.this.getQuick(s, r, c);
                                    if (!cond.apply(elem)) continue;
                                    ObjectMatrix3D.this.setQuick(s, r, c, f.apply(elem));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = 0; c < this.columns; ++c) {
                        Object elem = this.getQuick(s, r, c);
                        if (!cond.apply(elem)) continue;
                        this.setQuick(s, r, c, f.apply(elem));
                    }
                }
            }
        }
        return this;
    }

    public ObjectMatrix3D assign(final ObjectProcedure cond, final Object value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < ObjectMatrix3D.this.rows; ++r) {
                                for (int c = 0; c < ObjectMatrix3D.this.columns; ++c) {
                                    Object elem = ObjectMatrix3D.this.getQuick(s, r, c);
                                    if (!cond.apply(elem)) continue;
                                    ObjectMatrix3D.this.setQuick(s, r, c, value);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = 0; c < this.columns; ++c) {
                        Object elem = this.getQuick(s, r, c);
                        if (!cond.apply(elem)) continue;
                        this.setQuick(s, r, c, value);
                    }
                }
            }
        }
        return this;
    }

    public ObjectMatrix3D assign(final Object[][][] values) {
        if (values.length != this.slices) {
            throw new IllegalArgumentException("Must have same number of slices: slices=" + values.length + "slices()=" + this.slices());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            Object[][] currentSlice = values[s];
                            if (currentSlice.length != ObjectMatrix3D.this.rows) {
                                throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + ObjectMatrix3D.this.rows());
                            }
                            for (int r = 0; r < ObjectMatrix3D.this.rows; ++r) {
                                Object[] currentRow = currentSlice[r];
                                if (currentRow.length != ObjectMatrix3D.this.columns) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + ObjectMatrix3D.this.columns());
                                }
                                for (int c = 0; c < ObjectMatrix3D.this.columns; ++c) {
                                    ObjectMatrix3D.this.setQuick(s, r, c, currentRow[c]);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                Object[][] currentSlice = values[s];
                if (currentSlice.length != this.rows) {
                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + this.rows());
                }
                for (int r = 0; r < this.rows; ++r) {
                    Object[] currentRow = currentSlice[r];
                    if (currentRow.length != this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + this.columns());
                    }
                    for (int c = 0; c < this.columns; ++c) {
                        this.setQuick(s, r, c, currentRow[c]);
                    }
                }
            }
        }
        return this;
    }

    public ObjectMatrix3D assign(final Object[] values) {
        if (values.length != this.slices * this.rows * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + "slices()*rows()*columns()=" + this.slices() * this.rows() * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = firstSlice * ObjectMatrix3D.this.rows * ObjectMatrix3D.this.columns;
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < ObjectMatrix3D.this.rows; ++r) {
                                for (int c = 0; c < ObjectMatrix3D.this.columns; ++c) {
                                    ObjectMatrix3D.this.setQuick(s, r, c, values[idx++]);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = 0;
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = 0; c < this.columns; ++c) {
                        this.setQuick(s, r, c, values[idx++]);
                    }
                }
            }
        }
        return this;
    }

    public ObjectMatrix3D assign(final ObjectFunction function) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < ObjectMatrix3D.this.rows; ++r) {
                                for (int c = 0; c < ObjectMatrix3D.this.columns; ++c) {
                                    ObjectMatrix3D.this.setQuick(s, r, c, function.apply(ObjectMatrix3D.this.getQuick(s, r, c)));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = 0; c < this.columns; ++c) {
                        this.setQuick(s, r, c, function.apply(this.getQuick(s, r, c)));
                    }
                }
            }
        }
        return this;
    }

    public ObjectMatrix3D assign(ObjectMatrix3D other) {
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        final ObjectMatrix3D otherLoc = this.haveSharedCells(other) ? other.copy() : other;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < ObjectMatrix3D.this.rows; ++r) {
                                for (int c = 0; c < ObjectMatrix3D.this.columns; ++c) {
                                    ObjectMatrix3D.this.setQuick(s, r, c, otherLoc.getQuick(s, r, c));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = 0; c < this.columns; ++c) {
                        this.setQuick(s, r, c, otherLoc.getQuick(s, r, c));
                    }
                }
            }
        }
        return this;
    }

    public ObjectMatrix3D assign(final ObjectMatrix3D y, final ObjectObjectFunction function) {
        this.checkShape(y);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < ObjectMatrix3D.this.rows; ++r) {
                                for (int c = 0; c < ObjectMatrix3D.this.columns; ++c) {
                                    ObjectMatrix3D.this.setQuick(s, r, c, function.apply(ObjectMatrix3D.this.getQuick(s, r, c), y.getQuick(s, r, c)));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = 0; c < this.columns; ++c) {
                        this.setQuick(s, r, c, function.apply(this.getQuick(s, r, c), y.getQuick(s, r, c)));
                    }
                }
            }
        }
        return this;
    }

    public ObjectMatrix3D assign(final ObjectMatrix3D y, final ObjectObjectFunction function, IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList) {
        this.checkShape(y);
        int size = sliceList.size();
        final int[] sliceElements = sliceList.elements();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            ObjectMatrix3D.this.setQuick(sliceElements[i], rowElements[i], columnElements[i], function.apply(ObjectMatrix3D.this.getQuick(sliceElements[i], rowElements[i], columnElements[i]), y.getQuick(sliceElements[i], rowElements[i], columnElements[i])));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < size; ++i) {
                this.setQuick(sliceElements[i], rowElements[i], columnElements[i], function.apply(this.getQuick(sliceElements[i], rowElements[i], columnElements[i]), y.getQuick(sliceElements[i], rowElements[i], columnElements[i])));
            }
        }
        return this;
    }

    public ObjectMatrix3D assign(final Object value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < ObjectMatrix3D.this.rows; ++r) {
                                for (int c = 0; c < ObjectMatrix3D.this.columns; ++c) {
                                    ObjectMatrix3D.this.setQuick(s, r, c, value);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = 0; c < this.columns; ++c) {
                        this.setQuick(s, r, c, value);
                    }
                }
            }
        }
        return this;
    }

    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            int j;
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.slices / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < ObjectMatrix3D.this.rows; ++r) {
                                for (int c = 0; c < ObjectMatrix3D.this.columns; ++c) {
                                    if (ObjectMatrix3D.this.getQuick(s, r, c) == null) continue;
                                    ++cardinality;
                                }
                            }
                        }
                        return cardinality;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Integer)futures[j].get();
                }
                cardinality = results[0];
                for (j = 1; j < nthreads; ++j) {
                    cardinality += results[j].intValue();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = 0; c < this.columns; ++c) {
                        if (this.getQuick(s, r, c) == null) continue;
                        ++cardinality;
                    }
                }
            }
        }
        return cardinality;
    }

    public ObjectMatrix3D copy() {
        return this.like().assign(this);
    }

    public abstract Object elements();

    public boolean equals(Object otherObj) {
        return this.equals(otherObj, true);
    }

    public boolean equals(Object otherObj, boolean testForEquality) {
        if (!(otherObj instanceof ObjectMatrix3D)) {
            return false;
        }
        if (this == otherObj) {
            return true;
        }
        if (otherObj == null) {
            return false;
        }
        ObjectMatrix3D other = (ObjectMatrix3D)otherObj;
        if (this.rows != other.rows()) {
            return false;
        }
        if (this.columns != other.columns()) {
            return false;
        }
        if (!testForEquality) {
            int slice = this.slices;
            while (--slice >= 0) {
                int row = this.rows;
                while (--row >= 0) {
                    int column = this.columns;
                    while (--column >= 0) {
                        if (this.getQuick(slice, row, column) == other.getQuick(slice, row, column)) continue;
                        return false;
                    }
                }
            }
        } else {
            int slice = this.slices;
            while (--slice >= 0) {
                int row = this.rows;
                while (--row >= 0) {
                    int column = this.columns;
                    while (--column >= 0) {
                        if (this.getQuick(slice, row, column) != null ? this.getQuick(slice, row, column).equals(other.getQuick(slice, row, column)) : other.getQuick(slice, row, column) == null) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public Object get(int slice, int row, int column) {
        if (slice < 0 || slice >= this.slices || row < 0 || row >= this.rows || column < 0 || column >= this.columns) {
            throw new IndexOutOfBoundsException("slice:" + slice + ", row:" + row + ", column:" + column);
        }
        return this.getQuick(slice, row, column);
    }

    protected ObjectMatrix3D getContent() {
        return this;
    }

    public void getNonZeros(IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList, ObjectArrayList valueList) {
        sliceList.clear();
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int s = this.slices;
        int r = this.rows;
        int c = this.columns;
        for (int slice = 0; slice < s; ++slice) {
            for (int row = 0; row < r; ++row) {
                for (int column = 0; column < c; ++column) {
                    Object value = this.getQuick(slice, row, column);
                    if (value == null) continue;
                    sliceList.add(slice);
                    rowList.add(row);
                    columnList.add(column);
                    valueList.add(value);
                }
            }
        }
    }

    public abstract Object getQuick(int var1, int var2, int var3);

    protected boolean haveSharedCells(ObjectMatrix3D other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(other.getContent());
    }

    protected boolean haveSharedCellsRaw(ObjectMatrix3D other) {
        return false;
    }

    public ObjectMatrix3D like() {
        return this.like(this.slices, this.rows, this.columns);
    }

    public abstract ObjectMatrix3D like(int var1, int var2, int var3);

    public abstract ObjectMatrix2D like2D(int var1, int var2);

    protected abstract ObjectMatrix2D like2D(int var1, int var2, int var3, int var4, int var5, int var6);

    public void set(int slice, int row, int column, Object value) {
        if (slice < 0 || slice >= this.slices || row < 0 || row >= this.rows || column < 0 || column >= this.columns) {
            throw new IndexOutOfBoundsException("slice:" + slice + ", row:" + row + ", column:" + column);
        }
        this.setQuick(slice, row, column, value);
    }

    public abstract void setQuick(int var1, int var2, int var3, Object var4);

    public Object[][][] toArray() {
        final Object[][][] values = new Object[this.slices][this.rows][this.columns];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            Object[][] currentSlice = values[s];
                            for (int r = 0; r < ObjectMatrix3D.this.rows; ++r) {
                                Object[] currentRow = currentSlice[r];
                                for (int c = 0; c < ObjectMatrix3D.this.columns; ++c) {
                                    currentRow[c] = ObjectMatrix3D.this.getQuick(s, r, c);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                Object[][] currentSlice = values[s];
                for (int r = 0; r < this.rows; ++r) {
                    Object[] currentRow = currentSlice[r];
                    for (int c = 0; c < this.columns; ++c) {
                        currentRow[c] = this.getQuick(s, r, c);
                    }
                }
            }
        }
        return values;
    }

    public String toString() {
        return new ObjectFormatter().toString(this);
    }

    public abstract ObjectMatrix1D vectorize();

    protected ObjectMatrix3D view() {
        return (ObjectMatrix3D)this.clone();
    }

    public ObjectMatrix2D viewColumn(int column) {
        this.checkColumn(column);
        int sliceRows = this.slices;
        int sliceColumns = this.rows;
        int sliceRowZero = this.sliceZero;
        int sliceColumnZero = this.rowZero + this._columnOffset(this._columnRank(column));
        int sliceRowStride = this.sliceStride;
        int sliceColumnStride = this.rowStride;
        return this.like2D(sliceRows, sliceColumns, sliceRowZero, sliceColumnZero, sliceRowStride, sliceColumnStride);
    }

    public ObjectMatrix3D viewColumnFlip() {
        return (ObjectMatrix3D)this.view().vColumnFlip();
    }

    public ObjectMatrix3D viewDice(int axis0, int axis1, int axis2) {
        return (ObjectMatrix3D)this.view().vDice(axis0, axis1, axis2);
    }

    public ObjectMatrix3D viewPart(int slice, int row, int column, int depth, int height, int width) {
        return (ObjectMatrix3D)this.view().vPart(slice, row, column, depth, height, width);
    }

    public ObjectMatrix2D viewRow(int row) {
        this.checkRow(row);
        int sliceRows = this.slices;
        int sliceColumns = this.columns;
        int sliceRowZero = this.sliceZero;
        int sliceColumnZero = this.columnZero + this._rowOffset(this._rowRank(row));
        int sliceRowStride = this.sliceStride;
        int sliceColumnStride = this.columnStride;
        return this.like2D(sliceRows, sliceColumns, sliceRowZero, sliceColumnZero, sliceRowStride, sliceColumnStride);
    }

    public ObjectMatrix3D viewRowFlip() {
        return (ObjectMatrix3D)this.view().vRowFlip();
    }

    public ObjectMatrix3D viewSelection(int[] sliceIndexes, int[] rowIndexes, int[] columnIndexes) {
        int i;
        if (sliceIndexes == null) {
            sliceIndexes = new int[this.slices];
            i = this.slices;
            while (--i >= 0) {
                sliceIndexes[i] = i;
            }
        }
        if (rowIndexes == null) {
            rowIndexes = new int[this.rows];
            i = this.rows;
            while (--i >= 0) {
                rowIndexes[i] = i;
            }
        }
        if (columnIndexes == null) {
            columnIndexes = new int[this.columns];
            i = this.columns;
            while (--i >= 0) {
                columnIndexes[i] = i;
            }
        }
        this.checkSliceIndexes(sliceIndexes);
        this.checkRowIndexes(rowIndexes);
        this.checkColumnIndexes(columnIndexes);
        int[] sliceOffsets = new int[sliceIndexes.length];
        int[] rowOffsets = new int[rowIndexes.length];
        int[] columnOffsets = new int[columnIndexes.length];
        int i2 = sliceIndexes.length;
        while (--i2 >= 0) {
            sliceOffsets[i2] = this._sliceOffset(this._sliceRank(sliceIndexes[i2]));
        }
        i2 = rowIndexes.length;
        while (--i2 >= 0) {
            rowOffsets[i2] = this._rowOffset(this._rowRank(rowIndexes[i2]));
        }
        i2 = columnIndexes.length;
        while (--i2 >= 0) {
            columnOffsets[i2] = this._columnOffset(this._columnRank(columnIndexes[i2]));
        }
        return this.viewSelectionLike(sliceOffsets, rowOffsets, columnOffsets);
    }

    public ObjectMatrix3D viewSelection(ObjectMatrix2DProcedure condition) {
        IntArrayList matches = new IntArrayList();
        for (int i = 0; i < this.slices; ++i) {
            if (!condition.apply(this.viewSlice(i))) continue;
            matches.add(i);
        }
        matches.trimToSize();
        return this.viewSelection(matches.elements(), null, null);
    }

    protected abstract ObjectMatrix3D viewSelectionLike(int[] var1, int[] var2, int[] var3);

    public ObjectMatrix2D viewSlice(int slice) {
        this.checkSlice(slice);
        int sliceRows = this.rows;
        int sliceColumns = this.columns;
        int sliceRowZero = this.rowZero;
        int sliceColumnZero = this.columnZero + this._sliceOffset(this._sliceRank(slice));
        int sliceRowStride = this.rowStride;
        int sliceColumnStride = this.columnStride;
        return this.like2D(sliceRows, sliceColumns, sliceRowZero, sliceColumnZero, sliceRowStride, sliceColumnStride);
    }

    public ObjectMatrix3D viewSliceFlip() {
        return (ObjectMatrix3D)this.view().vSliceFlip();
    }

    public ObjectMatrix3D viewSorted(int row, int column) {
        return ObjectSorting.mergeSort.sort(this, row, column);
    }

    public ObjectMatrix3D viewStrides(int sliceStride, int rowStride, int columnStride) {
        return (ObjectMatrix3D)this.view().vStrides(sliceStride, rowStride, columnStride);
    }
}

