/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.IntMatrix3D;

public class WrapperIntMatrix1D
extends IntMatrix1D {
    private static final long serialVersionUID = 1L;
    protected IntMatrix1D content;

    public WrapperIntMatrix1D(IntMatrix1D newContent) {
        if (newContent != null) {
            this.setUp((int)newContent.size());
        }
        this.content = newContent;
    }

    protected IntMatrix1D getContent() {
        return this.content;
    }

    public synchronized int getQuick(int index) {
        return this.content.getQuick(index);
    }

    public Object elements() {
        return this.content.elements();
    }

    public IntMatrix1D like(int size) {
        return this.content.like(size);
    }

    public IntMatrix2D like2D(int rows, int columns) {
        return this.content.like2D(rows, columns);
    }

    public IntMatrix2D reshape(int rows, int columns) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public IntMatrix3D reshape(int slices, int rows, int columns) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public synchronized void setQuick(int index, int value) {
        this.content.setQuick(index, value);
    }

    public IntMatrix1D viewFlip() {
        WrapperIntMatrix1D view = new WrapperIntMatrix1D(this){
            private static final long serialVersionUID = 1L;

            public synchronized int getQuick(int index) {
                return this.content.getQuick(this.size - 1 - index);
            }

            public synchronized void setQuick(int index, int value) {
                this.content.setQuick(this.size - 1 - index, value);
            }

            public synchronized int get(int index) {
                return this.content.get(this.size - 1 - index);
            }

            public synchronized void set(int index, int value) {
                this.content.set(this.size - 1 - index, value);
            }
        };
        return view;
    }

    public IntMatrix1D viewPart(final int index, int width) {
        this.checkRange(index, width);
        WrapperIntMatrix1D view = new WrapperIntMatrix1D(this){
            private static final long serialVersionUID = 1L;

            public synchronized int getQuick(int i) {
                return this.content.getQuick(index + i);
            }

            public synchronized void setQuick(int i, int value) {
                this.content.setQuick(index + i, value);
            }

            public synchronized int get(int i) {
                return this.content.get(index + i);
            }

            public synchronized void set(int i, int value) {
                this.content.set(index + i, value);
            }
        };
        view.setSize(width);
        return view;
    }

    public IntMatrix1D viewSelection(int[] indexes) {
        if (indexes == null) {
            indexes = new int[this.size];
            int i = this.size;
            while (--i >= 0) {
                indexes[i] = i;
            }
        }
        this.checkIndexes(indexes);
        final int[] idx = indexes;
        WrapperIntMatrix1D view = new WrapperIntMatrix1D(this){
            private static final long serialVersionUID = 1L;

            public synchronized int getQuick(int i) {
                return this.content.getQuick(idx[i]);
            }

            public synchronized void setQuick(int i, int value) {
                this.content.setQuick(idx[i], value);
            }

            public synchronized int get(int i) {
                return this.content.get(idx[i]);
            }

            public synchronized void set(int i, int value) {
                this.content.set(idx[i], value);
            }
        };
        view.setSize(indexes.length);
        return view;
    }

    protected IntMatrix1D viewSelectionLike(int[] offsets) {
        throw new InternalError();
    }

    public IntMatrix1D viewStrides(final int _stride) {
        if (this.stride <= 0) {
            throw new IndexOutOfBoundsException("illegal stride: " + this.stride);
        }
        WrapperIntMatrix1D view = new WrapperIntMatrix1D(this){
            private static final long serialVersionUID = 1L;

            public synchronized int getQuick(int index) {
                return this.content.getQuick(index * _stride);
            }

            public synchronized void setQuick(int index, int value) {
                this.content.setQuick(index * _stride, value);
            }

            public synchronized int get(int index) {
                return this.content.get(index * _stride);
            }

            public synchronized void set(int index, int value) {
                this.content.set(index * _stride, value);
            }
        };
        view.setSize(this.size);
        if (this.size != 0) {
            view.setSize((this.size - 1) / _stride + 1);
        }
        return view;
    }
}

