/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.function.tint.IntFunction;
import cern.colt.function.tint.IntIntFunction;
import cern.colt.function.tint.IntIntIntFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.impl.DenseIntMatrix1D;
import cern.colt.matrix.tint.impl.DenseIntMatrix2D;
import cern.colt.matrix.tint.impl.SparseIntMatrix1D;
import cern.colt.matrix.tint.impl.SparseRCIntMatrix2D;
import cern.colt.matrix.tint.impl.WrapperIntMatrix2D;
import cern.jet.math.tint.IntFunctions;
import cern.jet.math.tint.IntMult;
import cern.jet.math.tint.IntPlusMultFirst;
import cern.jet.math.tint.IntPlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.Arrays;
import java.util.concurrent.Future;

public class SparseCCIntMatrix2D
extends WrapperIntMatrix2D {
    private static final long serialVersionUID = 1L;
    protected int[] columnPointers;
    protected int[] rowIndexes;
    protected int[] values;
    protected boolean rowIndexesSorted;

    public SparseCCIntMatrix2D(int[][] values) {
        this(values.length, values[0].length);
        this.assign(values);
    }

    public SparseCCIntMatrix2D(int rows, int columns) {
        this(rows, columns, (int)Math.min(10L * (long)rows, Integer.MAX_VALUE));
    }

    public SparseCCIntMatrix2D(int rows, int columns, int nzmax) {
        block2: {
            super(null);
            this.rowIndexesSorted = false;
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.rowIndexes = new int[nzmax];
        this.values = new int[nzmax];
        this.columnPointers = new int[columns + 1];
    }

    public SparseCCIntMatrix2D(int rows, int columns, int[] rowIndexes, int[] columnIndexes, int value, boolean removeDuplicates, boolean sortRowIndexes) {
        int k;
        block8: {
            super(null);
            this.rowIndexesSorted = false;
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block8;
                throw exc;
            }
        }
        if (rowIndexes.length != columnIndexes.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (value == 0) {
            throw new IllegalArgumentException("value cannot be 0");
        }
        int nz = Math.max(rowIndexes.length, 1);
        this.rowIndexes = new int[nz];
        this.values = new int[nz];
        this.columnPointers = new int[columns + 1];
        int[] w = new int[columns];
        for (k = 0; k < nz; ++k) {
            int n = columnIndexes[k];
            w[n] = w[n] + 1;
        }
        this.cumsum(this.columnPointers, w, columns);
        for (k = 0; k < nz; ++k) {
            int n = columnIndexes[k];
            w[n] = w[n] + 1;
            this.rowIndexes[r] = rowIndexes[k];
            this.values[r] = value;
        }
        if (removeDuplicates) {
            this.removeDuplicates();
        }
        if (sortRowIndexes) {
            this.sortRowIndexes();
        }
    }

    public SparseCCIntMatrix2D(int rows, int columns, int[] rowIndexes, int[] columnIndexes, int[] values, boolean removeDuplicates, boolean removeZeroes, boolean sortRowIndexes) {
        int k;
        block8: {
            super(null);
            this.rowIndexesSorted = false;
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block8;
                throw exc;
            }
        }
        if (rowIndexes.length != columnIndexes.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (rowIndexes.length != values.length) {
            throw new IllegalArgumentException("rowIndexes.length != values.length");
        }
        int nz = Math.max(rowIndexes.length, 1);
        this.rowIndexes = new int[nz];
        this.values = new int[nz];
        this.columnPointers = new int[columns + 1];
        int[] w = new int[columns];
        for (k = 0; k < nz; ++k) {
            int n = columnIndexes[k];
            w[n] = w[n] + 1;
        }
        this.cumsum(this.columnPointers, w, columns);
        for (k = 0; k < nz; ++k) {
            int n = columnIndexes[k];
            w[n] = w[n] + 1;
            this.rowIndexes[r] = rowIndexes[k];
            this.values[r] = values[k];
        }
        if (removeDuplicates) {
            this.removeDuplicates();
        }
        if (sortRowIndexes) {
            this.sortRowIndexes();
        }
    }

    public IntMatrix2D assign(final IntFunction function) {
        if (function instanceof IntMult) {
            int alpha = ((IntMult)function).multiplicator;
            if (alpha == 1) {
                return this;
            }
            if (alpha == 0) {
                return this.assign(0);
            }
            if (alpha != alpha) {
                return this.assign(alpha);
            }
            int[] valuesE = this.values;
            int nz = this.cardinality();
            int j = 0;
            while (j < nz) {
                int n = j++;
                valuesE[n] = valuesE[n] * alpha;
            }
        } else {
            this.forEachNonZero(new IntIntIntFunction(){

                public int apply(int i, int j, int value) {
                    return function.apply(value);
                }
            });
        }
        return this;
    }

    public IntMatrix2D assign(int value) {
        if (value == 0) {
            Arrays.fill(this.rowIndexes, 0);
            Arrays.fill(this.columnPointers, 0);
            Arrays.fill(this.values, 0);
        } else {
            int nnz = this.cardinality();
            for (int i = 0; i < nnz; ++i) {
                this.values[i] = value;
            }
        }
        return this;
    }

    public IntMatrix2D assign(IntMatrix2D source) {
        if (source == this) {
            return this;
        }
        this.checkShape(source);
        if (source instanceof SparseCCIntMatrix2D) {
            SparseCCIntMatrix2D other = (SparseCCIntMatrix2D)source;
            System.arraycopy(other.getColumnPointers(), 0, this.columnPointers, 0, this.columns + 1);
            int nzmax = other.getRowIndexes().length;
            if (this.rowIndexes.length < nzmax) {
                this.rowIndexes = new int[nzmax];
                this.values = new int[nzmax];
            }
            System.arraycopy(other.getRowIndexes(), 0, this.rowIndexes, 0, nzmax);
            System.arraycopy(other.getValues(), 0, this.values, 0, nzmax);
            this.rowIndexesSorted = other.rowIndexesSorted;
        } else if (source instanceof SparseRCIntMatrix2D) {
            SparseRCIntMatrix2D other = ((SparseRCIntMatrix2D)source).getTranspose();
            this.columnPointers = other.getRowPointers();
            this.rowIndexes = other.getColumnIndexes();
            this.values = other.getValues();
            this.rowIndexesSorted = true;
        } else {
            this.assign(0);
            source.forEachNonZero(new IntIntIntFunction(){

                public int apply(int i, int j, int value) {
                    SparseCCIntMatrix2D.this.setQuick(i, j, value);
                    return value;
                }
            });
        }
        return this;
    }

    public IntMatrix2D assign(IntMatrix2D y, IntIntFunction function) {
        this.checkShape(y);
        if (y instanceof SparseCCIntMatrix2D && function == IntFunctions.plus) {
            SparseCCIntMatrix2D yy = (SparseCCIntMatrix2D)y;
            int nz = 0;
            int m = this.rows;
            int anz = this.columnPointers[this.columns];
            int n = yy.columns;
            int[] Bp = yy.columnPointers;
            int bnz = Bp[n];
            int[] w = new int[m];
            int[] x = new int[m];
            SparseCCIntMatrix2D C = new SparseCCIntMatrix2D(m, n, anz + bnz);
            int[] Cp = C.columnPointers;
            int[] Ci = C.rowIndexes;
            int[] Cx = C.values;
            for (int j = 0; j < n; ++j) {
                Cp[j] = nz;
                nz = this.scatter(this, j, 1, w, x, j + 1, C, nz);
                nz = this.scatter(yy, j, 1, w, x, j + 1, C, nz);
                for (int p = Cp[j]; p < nz; ++p) {
                    Cx[p] = x[Ci[p]];
                }
            }
            Cp[n] = nz;
            this.rowIndexes = Ci;
            this.columnPointers = Cp;
            this.values = Cx;
            return this;
        }
        if (function instanceof IntPlusMultSecond) {
            final int alpha = ((IntPlusMultSecond)function).multiplicator;
            if (alpha == 0) {
                return this;
            }
            y.forEachNonZero(new IntIntIntFunction(){

                public int apply(int i, int j, int value) {
                    SparseCCIntMatrix2D.this.setQuick(i, j, SparseCCIntMatrix2D.this.getQuick(i, j) + alpha * value);
                    return value;
                }
            });
            return this;
        }
        if (function instanceof IntPlusMultFirst) {
            final int alpha = ((IntPlusMultFirst)function).multiplicator;
            if (alpha == 0) {
                return this.assign(y);
            }
            y.forEachNonZero(new IntIntIntFunction(){

                public int apply(int i, int j, int value) {
                    SparseCCIntMatrix2D.this.setQuick(i, j, alpha * SparseCCIntMatrix2D.this.getQuick(i, j) + value);
                    return value;
                }
            });
            return this;
        }
        if (function == IntFunctions.mult) {
            int[] rowIndexesA = this.rowIndexes;
            int[] columnPointersA = this.columnPointers;
            int[] valuesA = this.values;
            int j = this.columns;
            while (--j >= 0) {
                int low = columnPointersA[j];
                int k = columnPointersA[j + 1];
                while (--k >= low) {
                    int i = rowIndexesA[k];
                    int n = k;
                    valuesA[n] = valuesA[n] * y.getQuick(i, j);
                    if (valuesA[k] != 0) continue;
                    this.remove(i, j);
                }
            }
            return this;
        }
        if (function == IntFunctions.div) {
            int[] rowIndexesA = this.rowIndexes;
            int[] columnPointersA = this.columnPointers;
            int[] valuesA = this.values;
            int j = this.columns;
            while (--j >= 0) {
                int low = columnPointersA[j];
                int k = columnPointersA[j + 1];
                while (--k >= low) {
                    int i = rowIndexesA[k];
                    int n = k;
                    valuesA[n] = valuesA[n] / y.getQuick(i, j);
                    if (valuesA[k] != 0) continue;
                    this.remove(i, j);
                }
            }
            return this;
        }
        return super.assign(y, function);
    }

    public int cardinality() {
        return this.columnPointers[this.columns];
    }

    public IntMatrix2D forEachNonZero(IntIntIntFunction function) {
        int[] rowIndexesA = this.rowIndexes;
        int[] columnPointersA = this.columnPointers;
        int[] valuesA = this.values;
        int j = this.columns;
        while (--j >= 0) {
            int low = columnPointersA[j];
            int k = columnPointersA[j + 1];
            while (--k >= low) {
                int r;
                int i = rowIndexesA[k];
                int value = valuesA[k];
                valuesA[k] = r = function.apply(i, j, value);
            }
        }
        return this;
    }

    public int[] getColumnPointers() {
        return this.columnPointers;
    }

    public DenseIntMatrix2D getDense() {
        final DenseIntMatrix2D dense = new DenseIntMatrix2D(this.rows, this.columns);
        this.forEachNonZero(new IntIntIntFunction(){

            public int apply(int i, int j, int value) {
                dense.setQuick(i, j, SparseCCIntMatrix2D.this.getQuick(i, j));
                return value;
            }
        });
        return dense;
    }

    public synchronized int getQuick(int row, int column) {
        int k = SparseCCIntMatrix2D.searchFromTo(this.rowIndexes, row, this.columnPointers[column], this.columnPointers[column + 1] - 1);
        int v = 0;
        if (k >= 0) {
            v = this.values[k];
        }
        return v;
    }

    public SparseRCIntMatrix2D getRowCompressed() {
        SparseCCIntMatrix2D tr = this.getTranspose();
        SparseRCIntMatrix2D rc = new SparseRCIntMatrix2D(this.rows, this.columns);
        rc.columnIndexes = tr.rowIndexes;
        rc.rowPointers = tr.columnPointers;
        rc.values = tr.values;
        rc.columnIndexesSorted = true;
        return rc;
    }

    public int[] getRowIndexes() {
        return this.rowIndexes;
    }

    public SparseCCIntMatrix2D getTranspose() {
        int p;
        int m = this.rows;
        int n = this.columns;
        int[] Ap = this.columnPointers;
        int[] Ai = this.rowIndexes;
        int[] Ax = this.values;
        SparseCCIntMatrix2D C = new SparseCCIntMatrix2D(this.columns, this.rows, Ai.length);
        int[] w = new int[m];
        int[] Cp = C.columnPointers;
        int[] Ci = C.rowIndexes;
        int[] Cx = C.values;
        for (p = 0; p < Ap[n]; ++p) {
            int n2 = Ai[p];
            w[n2] = w[n2] + 1;
        }
        this.cumsum(Cp, w, m);
        for (int j = 0; j < n; ++j) {
            for (p = Ap[j]; p < Ap[j + 1]; ++p) {
                int n3 = Ai[p];
                w[n3] = w[n3] + 1;
                Ci[q] = j;
                Cx[q] = Ax[p];
            }
        }
        return C;
    }

    public int[] getValues() {
        return this.values;
    }

    public boolean hasRowIndexesSorted() {
        return this.rowIndexesSorted;
    }

    public IntMatrix2D like(int rows, int columns) {
        return new SparseCCIntMatrix2D(rows, columns);
    }

    public IntMatrix1D like1D(int size) {
        return new SparseIntMatrix1D(size);
    }

    public synchronized void setQuick(int row, int column, int value) {
        int k = SparseCCIntMatrix2D.searchFromTo(this.rowIndexes, row, this.columnPointers[column], this.columnPointers[column + 1] - 1);
        if (k >= 0) {
            if (value == 0) {
                this.remove(column, k);
            } else {
                this.values[k] = value;
            }
            return;
        }
        if (value != 0) {
            k = -k - 1;
            this.insert(row, column, k, value);
        }
    }

    public void sortRowIndexes() {
        SparseCCIntMatrix2D tr = this.getTranspose();
        tr = tr.getTranspose();
        this.columnPointers = tr.columnPointers;
        this.rowIndexes = tr.rowIndexes;
        this.values = tr.values;
        this.rowIndexesSorted = true;
    }

    public void removeDuplicates() {
        int i;
        int nz = 0;
        int m = this.rows;
        int n = this.columns;
        int[] Ap = this.columnPointers;
        int[] Ai = this.rowIndexes;
        int[] Ax = this.values;
        int[] w = new int[m];
        for (i = 0; i < m; ++i) {
            w[i] = -1;
        }
        for (int j = 0; j < n; ++j) {
            int q = nz;
            for (int p = Ap[j]; p < Ap[j + 1]; ++p) {
                i = Ai[p];
                if (w[i] >= q) {
                    int n2 = w[i];
                    Ax[n2] = Ax[n2] + Ax[p];
                    continue;
                }
                w[i] = nz;
                Ai[nz] = i;
                Ax[nz++] = Ax[p];
            }
            Ap[j] = q;
        }
        Ap[n] = nz;
    }

    public void removeZeroes() {
        int nz = 0;
        int n = this.columns;
        int[] Ap = this.columnPointers;
        int[] Ai = this.rowIndexes;
        int[] Ax = this.values;
        for (int j = 0; j < n; ++j) {
            Ap[j] = nz;
            for (int p = Ap[j]; p < Ap[j + 1]; ++p) {
                if (Ax[p] == 0) continue;
                Ax[nz] = Ax[p];
                Ai[nz++] = Ai[p];
            }
        }
        Ap[n] = nz;
    }

    public void trimToSize() {
        this.realloc(0);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.rows).append(" x ").append(this.columns).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        for (int i = 0; i < this.columns; ++i) {
            int high = this.columnPointers[i + 1];
            for (int j = this.columnPointers[i]; j < high; ++j) {
                builder.append('(').append(this.rowIndexes[j]).append(',').append(i).append(')').append('\t').append(this.values[j]).append('\n');
            }
        }
        return builder.toString();
    }

    public IntMatrix1D zMult(IntMatrix1D y, IntMatrix1D z, final int alpha, final int beta, boolean transposeA) {
        boolean ignore;
        int rowsA = transposeA ? this.columns : this.rows;
        int columnsA = transposeA ? this.rows : this.columns;
        boolean bl = ignore = z == null || transposeA;
        if (z == null) {
            z = new DenseIntMatrix1D(rowsA);
        }
        if (!(y instanceof DenseIntMatrix1D) || !(z instanceof DenseIntMatrix1D)) {
            return super.zMult(y, z, alpha, beta, transposeA);
        }
        if ((long)columnsA != y.size() || (long)rowsA > z.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (transposeA ? this.viewDice() : this).toStringShort() + ", " + y.toStringShort() + ", " + z.toStringShort());
        }
        DenseIntMatrix1D zz = (DenseIntMatrix1D)z;
        final int[] elementsZ = zz.elements;
        final int strideZ = zz.stride();
        final int zeroZ = (int)zz.index(0);
        DenseIntMatrix1D yy = (DenseIntMatrix1D)y;
        final int[] elementsY = yy.elements;
        final int strideY = yy.stride();
        final int zeroY = (int)yy.index(0);
        final int[] rowIndexesA = this.rowIndexes;
        final int[] columnPointersA = this.columnPointers;
        final int[] valuesA = this.values;
        int zidx = zeroZ;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (!transposeA) {
            if (!ignore && beta != 1) {
                z.assign(IntFunctions.mult(beta));
            }
            if (nthreads > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                int rem;
                int j;
                nthreads = 2;
                Future[] futures = new Future[nthreads];
                final int[] result = new int[rowsA];
                int k = this.columns / nthreads;
                for (int j2 = 0; j2 < nthreads; ++j2) {
                    final int firstColumn = j2 * k;
                    final int lastColumn = j2 == nthreads - 1 ? this.columns : firstColumn + k;
                    final int threadID = j2;
                    futures[j2] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            if (threadID == 0) {
                                for (int i = firstColumn; i < lastColumn; ++i) {
                                    int high = columnPointersA[i + 1];
                                    int yElem = elementsY[zeroY + strideY * i];
                                    for (int k = columnPointersA[i]; k < high; ++k) {
                                        int j = rowIndexesA[k];
                                        int n = zeroZ + strideZ * j;
                                        elementsZ[n] = elementsZ[n] + alpha * valuesA[k] * yElem;
                                    }
                                }
                            } else {
                                for (int i = firstColumn; i < lastColumn; ++i) {
                                    int high = columnPointersA[i + 1];
                                    int yElem = elementsY[zeroY + strideY * i];
                                    for (int k = columnPointersA[i]; k < high; ++k) {
                                        int j;
                                        int n = j = rowIndexesA[k];
                                        result[n] = result[n] + alpha * valuesA[k] * yElem;
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
                for (j = rem = rowsA % 10; j < rowsA; j += 10) {
                    int n = zeroZ + j * strideZ;
                    elementsZ[n] = elementsZ[n] + result[j];
                    int n2 = zeroZ + (j + 1) * strideZ;
                    elementsZ[n2] = elementsZ[n2] + result[j + 1];
                    int n3 = zeroZ + (j + 2) * strideZ;
                    elementsZ[n3] = elementsZ[n3] + result[j + 2];
                    int n4 = zeroZ + (j + 3) * strideZ;
                    elementsZ[n4] = elementsZ[n4] + result[j + 3];
                    int n5 = zeroZ + (j + 4) * strideZ;
                    elementsZ[n5] = elementsZ[n5] + result[j + 4];
                    int n6 = zeroZ + (j + 5) * strideZ;
                    elementsZ[n6] = elementsZ[n6] + result[j + 5];
                    int n7 = zeroZ + (j + 6) * strideZ;
                    elementsZ[n7] = elementsZ[n7] + result[j + 6];
                    int n8 = zeroZ + (j + 7) * strideZ;
                    elementsZ[n8] = elementsZ[n8] + result[j + 7];
                    int n9 = zeroZ + (j + 8) * strideZ;
                    elementsZ[n9] = elementsZ[n9] + result[j + 8];
                    int n10 = zeroZ + (j + 9) * strideZ;
                    elementsZ[n10] = elementsZ[n10] + result[j + 9];
                }
                for (j = 0; j < rem; ++j) {
                    int n = zeroZ + j * strideZ;
                    elementsZ[n] = elementsZ[n] + result[j];
                }
            } else {
                for (int i = 0; i < this.columns; ++i) {
                    int high = columnPointersA[i + 1];
                    int yElem = elementsY[zeroY + strideY * i];
                    for (int k = columnPointersA[i]; k < high; ++k) {
                        int j = rowIndexesA[k];
                        int n = zeroZ + strideZ * j;
                        elementsZ[n] = elementsZ[n] + alpha * valuesA[k] * yElem;
                    }
                }
            }
        } else if (nthreads > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int zidx = zeroZ + firstColumn * strideZ;
                        int k = SparseCCIntMatrix2D.this.columnPointers[firstColumn];
                        for (int i = firstColumn; i < lastColumn; ++i) {
                            int sum = 0;
                            int high = SparseCCIntMatrix2D.this.columnPointers[i + 1];
                            while (k + 10 < high) {
                                int ind = k + 9;
                                sum += valuesA[ind] * elementsY[zeroY + strideY * SparseCCIntMatrix2D.this.rowIndexes[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * SparseCCIntMatrix2D.this.rowIndexes[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * SparseCCIntMatrix2D.this.rowIndexes[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * SparseCCIntMatrix2D.this.rowIndexes[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * SparseCCIntMatrix2D.this.rowIndexes[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * SparseCCIntMatrix2D.this.rowIndexes[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * SparseCCIntMatrix2D.this.rowIndexes[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * SparseCCIntMatrix2D.this.rowIndexes[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * SparseCCIntMatrix2D.this.rowIndexes[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * SparseCCIntMatrix2D.this.rowIndexes[ind--]];
                                k += 10;
                            }
                            while (k < high) {
                                sum += valuesA[k] * elementsY[SparseCCIntMatrix2D.this.rowIndexes[k]];
                                ++k;
                            }
                            elementsZ[zidx] = alpha * sum + beta * elementsZ[zidx];
                            zidx += strideZ;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int k = this.columnPointers[0];
            for (int i = 0; i < this.columns; ++i) {
                int sum = 0;
                int high = this.columnPointers[i + 1];
                while (k + 10 < high) {
                    int ind = k + 9;
                    sum += valuesA[ind] * elementsY[zeroY + strideY * this.rowIndexes[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * this.rowIndexes[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * this.rowIndexes[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * this.rowIndexes[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * this.rowIndexes[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * this.rowIndexes[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * this.rowIndexes[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * this.rowIndexes[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * this.rowIndexes[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * this.rowIndexes[ind--]];
                    k += 10;
                }
                while (k < high) {
                    sum += valuesA[k] * elementsY[this.rowIndexes[k]];
                    ++k;
                }
                elementsZ[zidx] = alpha * sum + beta * elementsZ[zidx];
                zidx += strideZ;
            }
        }
        return z;
    }

    public IntMatrix2D zMult(IntMatrix2D B, IntMatrix2D C, int alpha, int beta, boolean transposeA, boolean transposeB) {
        boolean ignore;
        int rowsA = this.rows;
        int columnsA = this.columns;
        if (transposeA) {
            rowsA = this.columns;
            columnsA = this.rows;
        }
        int rowsB = B.rows();
        int columnsB = B.columns();
        if (transposeB) {
            rowsB = B.columns();
            columnsB = B.rows();
        }
        int p = columnsB;
        boolean bl = ignore = C == null;
        if (C == null) {
            C = B instanceof SparseCCIntMatrix2D ? new SparseCCIntMatrix2D(rowsA, p, rowsA * p) : new DenseIntMatrix2D(rowsA, p);
        }
        if (rowsB != columnsA) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + (transposeB ? B.viewDice() : B).toStringShort());
        }
        if (C.rows() != rowsA || C.columns() != p) {
            throw new IllegalArgumentException("Incompatible result matrix: " + this.toStringShort() + ", " + (transposeB ? B.viewDice() : B).toStringShort() + ", " + C.toStringShort());
        }
        if (this == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!ignore && (double)beta != 1.0) {
            C.assign(IntFunctions.mult(beta));
        }
        if (B instanceof DenseIntMatrix2D && C instanceof DenseIntMatrix2D) {
            SparseCCIntMatrix2D AA = transposeA ? this.getTranspose() : this;
            DenseIntMatrix2D BB = transposeB ? (DenseIntMatrix2D)B.viewDice() : (DenseIntMatrix2D)B;
            DenseIntMatrix2D CC = (DenseIntMatrix2D)C;
            int[] columnPointersA = AA.columnPointers;
            int[] rowIndexesA = AA.rowIndexes;
            int[] valuesA = AA.values;
            int zeroB = (int)BB.index(0, 0);
            int rowStrideB = BB.rowStride();
            int columnStrideB = BB.columnStride();
            int[] elementsB = BB.elements;
            int zeroC = (int)CC.index(0, 0);
            int rowStrideC = CC.rowStride();
            int columnStrideC = CC.columnStride();
            int[] elementsC = CC.elements;
            for (int jj = 0; jj < columnsB; ++jj) {
                for (int kk = 0; kk < columnsA; ++kk) {
                    int high = columnPointersA[kk + 1];
                    int yElem = elementsB[zeroB + kk * rowStrideB + jj * columnStrideB];
                    for (int ii = columnPointersA[kk]; ii < high; ++ii) {
                        int j = rowIndexesA[ii];
                        int n = zeroC + j * rowStrideC + jj * columnStrideC;
                        elementsC[n] = elementsC[n] + valuesA[ii] * yElem;
                    }
                }
            }
            if ((double)alpha != 1.0) {
                C.assign(IntFunctions.mult(alpha));
            }
        } else if (B instanceof SparseCCIntMatrix2D && C instanceof SparseCCIntMatrix2D) {
            SparseCCIntMatrix2D AA = transposeA ? this.getTranspose() : this;
            SparseCCIntMatrix2D BB = (SparseCCIntMatrix2D)B;
            if (transposeB) {
                BB = BB.getTranspose();
            }
            SparseCCIntMatrix2D CC = (SparseCCIntMatrix2D)C;
            int nz = 0;
            int m = rowsA;
            int n = columnsB;
            int[] Bp = BB.columnPointers;
            int[] Bi = BB.rowIndexes;
            int[] Bx = BB.values;
            int[] w = new int[m];
            int[] x = new int[m];
            int[] Cp = CC.columnPointers;
            int[] Ci = CC.rowIndexes;
            int[] Cx = CC.values;
            for (int j = 0; j < n; ++j) {
                int nzmaxC = CC.rowIndexes.length;
                if (nz + m > nzmaxC) {
                    nzmaxC = 2 * nzmaxC + m;
                    int[] rowIndexesNew = new int[nzmaxC];
                    System.arraycopy(Ci, 0, rowIndexesNew, 0, Ci.length);
                    Ci = rowIndexesNew;
                    int[] valuesNew = new int[nzmaxC];
                    System.arraycopy(Cx, 0, valuesNew, 0, Cx.length);
                    Cx = valuesNew;
                }
                Cp[j] = nz;
                for (p = Bp[j]; p < Bp[j + 1]; ++p) {
                    nz = this.scatter(AA, Bi[p], Bx[p], w, x, j + 1, CC, nz);
                }
                for (p = Cp[j]; p < nz; ++p) {
                    Cx[p] = x[Ci[p]];
                }
            }
            Cp[n] = nz;
            if ((double)alpha != 1.0) {
                CC.assign(IntFunctions.mult(alpha));
            }
        } else {
            if (transposeB) {
                B = B.viewDice();
            }
            IntMatrix1D[] Brows = new IntMatrix1D[columnsA];
            int i = columnsA;
            while (--i >= 0) {
                Brows[i] = B.viewRow(i);
            }
            IntMatrix1D[] Crows = new IntMatrix1D[rowsA];
            int i2 = rowsA;
            while (--i2 >= 0) {
                Crows[i2] = C.viewRow(i2);
            }
            IntPlusMultSecond fun = IntPlusMultSecond.plusMult(0);
            int[] rowIndexesA = this.rowIndexes;
            int[] columnPointersA = this.columnPointers;
            int[] valuesA = this.values;
            int i3 = this.columns;
            while (--i3 >= 0) {
                int low = columnPointersA[i3];
                int k = columnPointersA[i3 + 1];
                while (--k >= low) {
                    int j = rowIndexesA[k];
                    fun.multiplicator = valuesA[k] * alpha;
                    if (!transposeA) {
                        Crows[j].assign(Brows[i3], fun);
                        continue;
                    }
                    Crows[i3].assign(Brows[j], fun);
                }
            }
        }
        return C;
    }

    protected IntMatrix2D getContent() {
        return this;
    }

    protected void insert(int row, int column, int index, int value) {
        IntArrayList rowIndexesList = new IntArrayList(this.rowIndexes);
        rowIndexesList.setSizeRaw(this.columnPointers[this.columns]);
        IntArrayList valuesList = new IntArrayList(this.values);
        valuesList.setSizeRaw(this.columnPointers[this.columns]);
        rowIndexesList.beforeInsert(index, row);
        valuesList.beforeInsert(index, value);
        int i = this.columnPointers.length;
        while (--i > column) {
            int n = i;
            this.columnPointers[n] = this.columnPointers[n] + 1;
        }
        this.rowIndexes = rowIndexesList.elements();
        this.values = valuesList.elements();
    }

    protected void remove(int column, int index) {
        IntArrayList rowIndexesList = new IntArrayList(this.rowIndexes);
        IntArrayList valuesList = new IntArrayList(this.values);
        rowIndexesList.remove(index);
        valuesList.remove(index);
        int i = this.columnPointers.length;
        while (--i > column) {
            int n = i;
            this.columnPointers[n] = this.columnPointers[n] - 1;
        }
        this.rowIndexes = rowIndexesList.elements();
        this.values = valuesList.elements();
    }

    private static int searchFromTo(int[] list, int key, int from, int to) {
        while (from <= to) {
            if (list[from] == key) {
                return from;
            }
            ++from;
        }
        return -(from + 1);
    }

    private int cumsum(int[] p, int[] c, int n) {
        int nz = 0;
        int nz2 = 0;
        for (int k = 0; k < n; ++k) {
            p[k] = nz;
            nz += c[k];
            nz2 += c[k];
            c[k] = p[k];
        }
        p[n] = nz;
        return nz2;
    }

    private void realloc(int nzmax) {
        if (nzmax <= 0) {
            nzmax = this.columnPointers[this.columns];
        }
        int[] rowIndexesNew = new int[nzmax];
        int length = Math.min(nzmax, this.rowIndexes.length);
        System.arraycopy(this.rowIndexes, 0, rowIndexesNew, 0, length);
        this.rowIndexes = rowIndexesNew;
        int[] valuesNew = new int[nzmax];
        length = Math.min(nzmax, this.values.length);
        System.arraycopy(this.values, 0, valuesNew, 0, length);
        this.values = valuesNew;
    }

    private int scatter(SparseCCIntMatrix2D A, int j, int beta, int[] w, int[] x, int mark, SparseCCIntMatrix2D C, int nz) {
        int[] Ap = A.columnPointers;
        int[] Ai = A.rowIndexes;
        int[] Ax = A.values;
        int[] Ci = C.rowIndexes;
        for (int p = Ap[j]; p < Ap[j + 1]; ++p) {
            int i = Ai[p];
            if (w[i] < mark) {
                w[i] = mark;
                Ci[nz++] = i;
                if (x == null) continue;
                x[i] = beta * Ax[p];
                continue;
            }
            if (x == null) continue;
            int n = i;
            x[n] = x[n] + beta * Ax[p];
        }
        return nz;
    }
}

