/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver;

import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.algo.solver.AbstractFloatIterationMonitor;
import cern.colt.matrix.tfloat.algo.solver.FloatNotConvergedException;
import cern.colt.matrix.tfloat.algo.solver.IterativeSolverFloatNotConvergedException;

public class HyBRFloatIterationMonitor
extends AbstractFloatIterationMonitor {
    protected HyBRStoppingCondition stoppingCondition;
    protected int maxIter;
    protected float dtol;
    protected float initR;
    protected float regularizationParameter;

    public HyBRFloatIterationMonitor() {
        this.maxIter = 100;
        this.dtol = 100000.0f;
        this.stoppingCondition = HyBRStoppingCondition.PERFORMED_MAX_NUMBER_OF_ITERATIONS;
    }

    public HyBRFloatIterationMonitor(int maxIter, float dtol) {
        this.maxIter = maxIter;
        this.dtol = dtol;
        this.stoppingCondition = HyBRStoppingCondition.PERFORMED_MAX_NUMBER_OF_ITERATIONS;
    }

    public boolean converged(float r, FloatMatrix1D x) throws IterativeSolverFloatNotConvergedException {
        if (!this.isFirst()) {
            this.reporter.monitor(r, x, this.iter);
        }
        this.residual = r;
        return this.convergedI(r, x);
    }

    public boolean converged(float r) throws IterativeSolverFloatNotConvergedException {
        if (!this.isFirst()) {
            this.reporter.monitor(r, this.iter);
        }
        this.residual = r;
        return this.convergedI(r);
    }

    protected boolean convergedI(float r) throws IterativeSolverFloatNotConvergedException {
        if (this.isFirst()) {
            this.initR = r;
        }
        if ((double)this.initR != -1.0 && r > this.dtol * this.initR) {
            throw new IterativeSolverFloatNotConvergedException(FloatNotConvergedException.Reason.Divergence, this);
        }
        if (this.iter >= this.maxIter + 1) {
            throw new IterativeSolverFloatNotConvergedException(FloatNotConvergedException.Reason.Iterations, this);
        }
        if (Float.isNaN(r)) {
            throw new IterativeSolverFloatNotConvergedException(FloatNotConvergedException.Reason.Divergence, this);
        }
        return false;
    }

    protected boolean convergedI(float r, FloatMatrix1D x) throws IterativeSolverFloatNotConvergedException {
        return this.convergedI(r);
    }

    public int getMaxIterations() {
        return this.maxIter;
    }

    public void setMaxIterations(int maxIter) {
        this.maxIter = maxIter;
    }

    public void setDivergenceTolerance(float dtol) {
        this.dtol = dtol;
    }

    public float getDivergenceTolerance() {
        return this.dtol;
    }

    public float getRegularizationParameter() {
        return this.regularizationParameter;
    }

    public void setRegularizationParameter(float regularizationParameter) {
        this.regularizationParameter = regularizationParameter;
    }

    public void setStoppingCondition(HyBRStoppingCondition stoppingCondition) {
        this.stoppingCondition = stoppingCondition;
    }

    public HyBRStoppingCondition getStoppingCondition() {
        return this.stoppingCondition;
    }

    public int iterations() {
        return Math.min(this.iter, this.maxIter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum HyBRStoppingCondition {
        FLAT_GCV_CURVE,
        MIN_OF_GCV_CURVE_WITHIN_WINDOW_OF_4_ITERATIONS,
        PERFORMED_MAX_NUMBER_OF_ITERATIONS;

    }
}

