/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver;

import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.solver.AbstractFloatIterativeSolver;
import cern.colt.matrix.tfloat.algo.solver.FloatNotConvergedException;
import cern.colt.matrix.tfloat.algo.solver.IterativeSolverFloatNotConvergedException;
import cern.jet.math.tfloat.FloatFunctions;

public class FloatCGS
extends AbstractFloatIterativeSolver {
    private FloatMatrix1D p;
    private FloatMatrix1D q;
    private FloatMatrix1D u;
    private FloatMatrix1D phat;
    private FloatMatrix1D qhat;
    private FloatMatrix1D vhat;
    private FloatMatrix1D uhat;
    private FloatMatrix1D sum;
    private FloatMatrix1D r;
    private FloatMatrix1D rtilde;

    public FloatCGS(FloatMatrix1D template) {
        this.p = template.copy();
        this.q = template.copy();
        this.u = template.copy();
        this.phat = template.copy();
        this.qhat = template.copy();
        this.vhat = template.copy();
        this.uhat = template.copy();
        this.sum = template.copy();
        this.r = template.copy();
        this.rtilde = template.copy();
    }

    public FloatMatrix1D solve(FloatMatrix2D A, FloatMatrix1D b, FloatMatrix1D x) throws IterativeSolverFloatNotConvergedException {
        this.checkSizes(A, b, x);
        float rho_1 = 0.0f;
        float rho_2 = 0.0f;
        float alpha = 0.0f;
        float beta = 0.0f;
        A.zMult(x, this.r.assign(b), -1.0f, 1.0f, false);
        this.rtilde.assign(this.r);
        this.iter.setFirst();
        while (!this.iter.converged(this.r, x)) {
            rho_1 = this.rtilde.zDotProduct(this.r);
            if (rho_1 == 0.0f) {
                throw new IterativeSolverFloatNotConvergedException(FloatNotConvergedException.Reason.Breakdown, "rho", this.iter);
            }
            if (this.iter.isFirst()) {
                this.u.assign(this.r);
                this.p.assign(this.u);
            } else {
                beta = rho_1 / rho_2;
                this.u.assign(this.r).assign(this.q, FloatFunctions.plusMultSecond(beta));
                this.sum.assign(this.q).assign(this.p, FloatFunctions.plusMultSecond(beta));
                this.p.assign(this.u).assign(this.sum, FloatFunctions.plusMultSecond(beta));
            }
            this.M.apply(this.p, this.phat);
            A.zMult(this.phat, this.vhat);
            alpha = rho_1 / this.rtilde.zDotProduct(this.vhat);
            this.q.assign(this.vhat, FloatFunctions.multSecond(-alpha)).assign(this.u, FloatFunctions.plus);
            this.M.apply(this.sum.assign(this.u).assign(this.q, FloatFunctions.plus), this.uhat);
            x.assign(this.uhat, FloatFunctions.plusMultSecond(alpha));
            A.zMult(this.uhat, this.qhat);
            this.r.assign(this.qhat, FloatFunctions.plusMultSecond(-alpha));
            rho_2 = rho_1;
            this.iter.next();
        }
        return x;
    }
}

