/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.decomposition;

import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.FloatProperty;
import cern.colt.matrix.tfloat.impl.SparseCCFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseRCFloatMatrix2D;
import edu.emory.mathcs.csparsej.tfloat.Scs_common;
import edu.emory.mathcs.csparsej.tfloat.Scs_happly;
import edu.emory.mathcs.csparsej.tfloat.Scs_ipvec;
import edu.emory.mathcs.csparsej.tfloat.Scs_pvec;
import edu.emory.mathcs.csparsej.tfloat.Scs_qr;
import edu.emory.mathcs.csparsej.tfloat.Scs_sqr;
import edu.emory.mathcs.csparsej.tfloat.Scs_usolve;
import edu.emory.mathcs.csparsej.tfloat.Scs_utsolve;

public class SparseFloatQRDecomposition {
    private Scs_common.Scss S;
    private Scs_common.Scsn N;
    private FloatMatrix2D R;
    private FloatMatrix2D V;
    private int m;
    private int n;
    private boolean rcMatrix = false;

    public SparseFloatQRDecomposition(FloatMatrix2D A, int order) {
        Scs_common.Scs dcs;
        FloatProperty.DEFAULT.checkSparse(A);
        if (order < 0 || order > 3) {
            throw new IllegalArgumentException("order must be a number between 0 and 3");
        }
        this.m = A.rows();
        this.n = A.columns();
        if (A instanceof SparseRCFloatMatrix2D) {
            this.rcMatrix = true;
            dcs = this.m >= this.n ? ((SparseRCFloatMatrix2D)A).getColumnCompressed().elements() : ((SparseRCFloatMatrix2D)A).getColumnCompressed().getTranspose().elements();
        } else {
            dcs = this.m >= this.n ? (Scs_common.Scs)A.elements() : ((SparseCCFloatMatrix2D)A).getTranspose().elements();
        }
        this.S = Scs_sqr.cs_sqr(order, dcs, true);
        if (this.S == null) {
            throw new IllegalArgumentException("Exception occured in cs_sqr()");
        }
        this.N = Scs_qr.cs_qr(dcs, this.S);
        if (this.N == null) {
            throw new IllegalArgumentException("Exception occured in cs_qr()");
        }
    }

    public FloatMatrix2D getV() {
        if (this.V == null) {
            this.V = new SparseCCFloatMatrix2D(this.N.L);
            if (this.rcMatrix) {
                this.V = ((SparseCCFloatMatrix2D)this.V).getRowCompressed();
            }
        }
        return this.V.copy();
    }

    public float[] getBeta() {
        if (this.N.B == null) {
            return null;
        }
        float[] beta = new float[this.N.B.length];
        System.arraycopy(this.N.B, 0, beta, 0, this.N.B.length);
        return beta;
    }

    public FloatMatrix2D getR() {
        if (this.R == null) {
            this.R = new SparseCCFloatMatrix2D(this.N.U);
            if (this.rcMatrix) {
                this.R = ((SparseCCFloatMatrix2D)this.R).getRowCompressed();
            }
        }
        return this.R.copy();
    }

    public Scs_common.Scss getSymbolicAnalysis() {
        Scs_common.Scss S2 = new Scs_common.Scss();
        S2.cp = this.S.cp != null ? (int[])this.S.cp.clone() : null;
        S2.leftmost = this.S.leftmost != null ? (int[])this.S.leftmost.clone() : null;
        S2.lnz = this.S.lnz;
        S2.m2 = this.S.m2;
        S2.parent = this.S.parent != null ? (int[])this.S.parent.clone() : null;
        S2.pinv = this.S.pinv != null ? (int[])this.S.pinv.clone() : null;
        S2.q = this.S.q != null ? (int[])this.S.q.clone() : null;
        S2.unz = this.S.unz;
        return S2;
    }

    public boolean hasFullRank() {
        if (this.R == null) {
            this.R = new SparseCCFloatMatrix2D(this.N.U);
            if (this.rcMatrix) {
                this.R = ((SparseCCFloatMatrix2D)this.R).getRowCompressed();
            }
        }
        int mn = Math.min(this.m, this.n);
        for (int j = 0; j < mn; ++j) {
            if (this.R.getQuick(j, j) != 0.0f) continue;
            return false;
        }
        return true;
    }

    public void solve(FloatMatrix1D b) {
        if (b.size() != (long)Math.max(this.m, this.n)) {
            throw new IllegalArgumentException("The size b must be equal to max(A.rows(), A.columns()).");
        }
        if (!this.hasFullRank()) {
            throw new IllegalArgumentException("Matrix is rank deficient.");
        }
        float[] x = b.isView() ? (float[])b.copy().elements() : (float[])b.elements();
        if (this.m >= this.n) {
            float[] y = new float[this.S != null ? this.S.m2 : 1];
            Scs_ipvec.cs_ipvec(this.S.pinv, x, y, this.m);
            for (int k = 0; k < this.n; ++k) {
                Scs_happly.cs_happly(this.N.L, k, this.N.B[k], y);
            }
            Scs_usolve.cs_usolve(this.N.U, y);
            Scs_ipvec.cs_ipvec(this.S.q, y, x, this.n);
        } else {
            float[] y = new float[this.S != null ? this.S.m2 : 1];
            Scs_pvec.cs_pvec(this.S.q, x, y, this.m);
            Scs_utsolve.cs_utsolve(this.N.U, y);
            for (int k = this.m - 1; k >= 0; --k) {
                Scs_happly.cs_happly(this.N.L, k, this.N.B[k], y);
            }
            Scs_pvec.cs_pvec(this.S.pinv, y, x, this.n);
        }
    }
}

