/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.decomposition;

import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.FloatProperty;
import cern.colt.matrix.tfloat.impl.SparseCCFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseRCFloatMatrix2D;
import edu.emory.mathcs.csparsej.tfloat.Scs_chol;
import edu.emory.mathcs.csparsej.tfloat.Scs_common;
import edu.emory.mathcs.csparsej.tfloat.Scs_ipvec;
import edu.emory.mathcs.csparsej.tfloat.Scs_lsolve;
import edu.emory.mathcs.csparsej.tfloat.Scs_ltsolve;
import edu.emory.mathcs.csparsej.tfloat.Scs_pvec;
import edu.emory.mathcs.csparsej.tfloat.Scs_schol;

public class SparseFloatCholeskyDecomposition {
    private Scs_common.Scss S;
    private Scs_common.Scsn N;
    private FloatMatrix2D L;
    private boolean rcMatrix = false;
    private int n;

    public SparseFloatCholeskyDecomposition(FloatMatrix2D A, int order) {
        Scs_common.Scs dcs;
        FloatProperty.DEFAULT.checkSquare(A);
        FloatProperty.DEFAULT.checkSparse(A);
        if (order < 0 || order > 1) {
            throw new IllegalArgumentException("order must be equal 0 or 1");
        }
        if (A instanceof SparseRCFloatMatrix2D) {
            this.rcMatrix = true;
            dcs = ((SparseRCFloatMatrix2D)A).getColumnCompressed().elements();
        } else {
            dcs = (Scs_common.Scs)A.elements();
        }
        this.n = A.rows();
        this.S = Scs_schol.cs_schol(order, dcs);
        if (this.S == null) {
            throw new IllegalArgumentException("Exception occured in cs_schol()");
        }
        this.N = Scs_chol.cs_chol(dcs, this.S);
        if (this.N == null) {
            throw new IllegalArgumentException("Matrix is not symmetric positive definite");
        }
    }

    public FloatMatrix2D getL() {
        if (this.L == null) {
            this.L = new SparseCCFloatMatrix2D(this.N.L);
            if (this.rcMatrix) {
                this.L = ((SparseCCFloatMatrix2D)this.L).getRowCompressed();
            }
        }
        return this.L.copy();
    }

    public FloatMatrix2D getLtranspose() {
        if (this.L == null) {
            this.L = new SparseCCFloatMatrix2D(this.N.L);
            if (this.rcMatrix) {
                this.L = ((SparseCCFloatMatrix2D)this.L).getRowCompressed();
            }
        }
        if (this.rcMatrix) {
            return ((SparseRCFloatMatrix2D)this.L).getTranspose();
        }
        return ((SparseCCFloatMatrix2D)this.L).getTranspose();
    }

    public Scs_common.Scss getSymbolicAnalysis() {
        Scs_common.Scss S2 = new Scs_common.Scss();
        S2.cp = this.S.cp != null ? (int[])this.S.cp.clone() : null;
        S2.leftmost = this.S.leftmost != null ? (int[])this.S.leftmost.clone() : null;
        S2.lnz = this.S.lnz;
        S2.m2 = this.S.m2;
        S2.parent = this.S.parent != null ? (int[])this.S.parent.clone() : null;
        S2.pinv = this.S.pinv != null ? (int[])this.S.pinv.clone() : null;
        S2.q = this.S.q != null ? (int[])this.S.q.clone() : null;
        S2.unz = this.S.unz;
        return S2;
    }

    public void solve(FloatMatrix1D b) {
        if (b.size() != (long)this.n) {
            throw new IllegalArgumentException("b.size() != A.rows()");
        }
        FloatProperty.DEFAULT.checkDense(b);
        float[] y = new float[this.n];
        float[] x = b.isView() ? (float[])b.copy().elements() : (float[])b.elements();
        Scs_ipvec.cs_ipvec(this.S.pinv, x, y, this.n);
        Scs_lsolve.cs_lsolve(this.N.L, y);
        Scs_ltsolve.cs_ltsolve(this.N.L, y);
        Scs_pvec.cs_pvec(this.S.pinv, y, x, this.n);
        if (b.isView()) {
            b.assign(x);
        }
    }
}

