/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.function.tdouble.DoubleFunction;
import cern.colt.function.tdouble.IntIntDoubleFunction;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseCCDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.WrapperDoubleMatrix2D;
import cern.jet.math.tdouble.DoubleFunctions;
import cern.jet.math.tdouble.DoubleMult;
import cern.jet.math.tdouble.DoublePlusMultFirst;
import cern.jet.math.tdouble.DoublePlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.Arrays;
import java.util.concurrent.Future;

public class SparseRCDoubleMatrix2D
extends WrapperDoubleMatrix2D {
    private static final long serialVersionUID = 1L;
    protected int[] rowPointers;
    protected int[] columnIndexes;
    protected double[] values;
    protected boolean columnIndexesSorted;

    private static int searchFromTo(int[] list, int key, int from, int to) {
        while (from <= to) {
            if (list[from] == key) {
                return from;
            }
            ++from;
        }
        return -(from + 1);
    }

    public SparseRCDoubleMatrix2D(double[][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length);
        this.assign(values);
    }

    public SparseRCDoubleMatrix2D(int rows, int columns) {
        this(rows, columns, (int)Math.min(10L * (long)rows, Integer.MAX_VALUE));
    }

    public SparseRCDoubleMatrix2D(int rows, int columns, int nzmax) {
        block2: {
            super(null);
            this.columnIndexesSorted = false;
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.columnIndexes = new int[nzmax];
        this.values = new double[nzmax];
        this.rowPointers = new int[rows + 1];
    }

    public SparseRCDoubleMatrix2D(int rows, int columns, int[] rowIndexes, int[] columnIndexes, double value, boolean removeDuplicates, boolean sortColumnIndexes) {
        int k;
        block8: {
            super(null);
            this.columnIndexesSorted = false;
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block8;
                throw exc;
            }
        }
        if (rowIndexes.length != columnIndexes.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (value == 0.0) {
            throw new IllegalArgumentException("value cannot be 0");
        }
        int nz = Math.max(rowIndexes.length, 1);
        this.columnIndexes = new int[nz];
        this.values = new double[nz];
        this.rowPointers = new int[rows + 1];
        int[] w = new int[rows];
        for (k = 0; k < nz; ++k) {
            int n = rowIndexes[k];
            w[n] = w[n] + 1;
        }
        this.cumsum(this.rowPointers, w, rows);
        for (k = 0; k < nz; ++k) {
            int n = rowIndexes[k];
            w[n] = w[n] + 1;
            this.columnIndexes[r] = columnIndexes[k];
            this.values[r] = value;
        }
        if (removeDuplicates) {
            this.removeDuplicates();
        }
        if (sortColumnIndexes) {
            this.sortColumnIndexes();
        }
    }

    public SparseRCDoubleMatrix2D(int rows, int columns, int[] rowIndexes, int[] columnIndexes, double[] values, boolean removeDuplicates, boolean removeZeroes, boolean sortColumnIndexes) {
        int k;
        block9: {
            super(null);
            this.columnIndexesSorted = false;
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block9;
                throw exc;
            }
        }
        if (rowIndexes.length != columnIndexes.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (rowIndexes.length != values.length) {
            throw new IllegalArgumentException("rowIndexes.length != values.length");
        }
        int nz = Math.max(rowIndexes.length, 1);
        this.columnIndexes = new int[nz];
        this.values = new double[nz];
        this.rowPointers = new int[rows + 1];
        int[] w = new int[rows];
        for (k = 0; k < nz; ++k) {
            int n = rowIndexes[k];
            w[n] = w[n] + 1;
        }
        this.cumsum(this.rowPointers, w, rows);
        for (k = 0; k < nz; ++k) {
            int n = rowIndexes[k];
            w[n] = w[n] + 1;
            this.columnIndexes[r] = columnIndexes[k];
            this.values[r] = values[k];
        }
        if (removeZeroes) {
            this.removeZeroes();
        }
        if (removeDuplicates) {
            this.removeDuplicates();
        }
        if (sortColumnIndexes) {
            this.sortColumnIndexes();
        }
    }

    public SparseRCDoubleMatrix2D(int rows, int columns, int[] rowPointers, int[] columnIndexes, double[] values) {
        block3: {
            super(null);
            this.columnIndexesSorted = false;
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block3;
                throw exc;
            }
        }
        if (rowPointers.length != rows + 1) {
            throw new IllegalArgumentException("rowPointers.length != rows + 1");
        }
        this.rowPointers = rowPointers;
        this.columnIndexes = columnIndexes;
        this.values = values;
    }

    public DoubleMatrix2D assign(final DoubleFunction function) {
        if (function instanceof DoubleMult) {
            double alpha = ((DoubleMult)function).multiplicator;
            if (alpha == 1.0) {
                return this;
            }
            if (alpha == 0.0) {
                return this.assign(0.0);
            }
            if (alpha != alpha) {
                return this.assign(alpha);
            }
            int nz = this.cardinality();
            int j = 0;
            while (j < nz) {
                int n = j++;
                this.values[n] = this.values[n] * alpha;
            }
        } else {
            this.forEachNonZero(new IntIntDoubleFunction(){

                public double apply(int i, int j, double value) {
                    return function.apply(value);
                }
            });
        }
        return this;
    }

    public DoubleMatrix2D assign(double value) {
        if (value == 0.0) {
            Arrays.fill(this.rowPointers, 0);
            Arrays.fill(this.columnIndexes, 0);
            Arrays.fill(this.values, 0.0);
        } else {
            int nnz = this.cardinality();
            for (int i = 0; i < nnz; ++i) {
                this.values[i] = value;
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(DoubleMatrix2D source) {
        if (source == this) {
            return this;
        }
        this.checkShape(source);
        if (source instanceof SparseRCDoubleMatrix2D) {
            SparseRCDoubleMatrix2D other = (SparseRCDoubleMatrix2D)source;
            System.arraycopy(other.rowPointers, 0, this.rowPointers, 0, this.rows + 1);
            int nzmax = other.columnIndexes.length;
            if (this.columnIndexes.length < nzmax) {
                this.columnIndexes = new int[nzmax];
                this.values = new double[nzmax];
            }
            System.arraycopy(other.columnIndexes, 0, this.columnIndexes, 0, nzmax);
            System.arraycopy(other.values, 0, this.values, 0, nzmax);
            this.columnIndexesSorted = other.columnIndexesSorted;
        } else if (source instanceof SparseCCDoubleMatrix2D) {
            SparseCCDoubleMatrix2D other = ((SparseCCDoubleMatrix2D)source).getTranspose();
            this.rowPointers = other.getColumnPointers();
            this.columnIndexes = other.getRowIndexes();
            this.values = other.getValues();
            this.columnIndexesSorted = true;
        } else {
            this.assign(0.0);
            source.forEachNonZero(new IntIntDoubleFunction(){

                public double apply(int i, int j, double value) {
                    SparseRCDoubleMatrix2D.this.setQuick(i, j, value);
                    return value;
                }
            });
        }
        return this;
    }

    public DoubleMatrix2D assign(DoubleMatrix2D y, DoubleDoubleFunction function) {
        this.checkShape(y);
        if (y instanceof SparseRCDoubleMatrix2D && function == DoubleFunctions.plus) {
            SparseRCDoubleMatrix2D yy = (SparseRCDoubleMatrix2D)y;
            int[] rowPointersY = yy.rowPointers;
            int[] columnIndexesY = yy.columnIndexes;
            double[] valuesY = yy.values;
            int[] rowPointersC = new int[this.rows + 1];
            int cnz = Math.max(this.columnIndexes.length, (int)Math.min(Integer.MAX_VALUE, (long)this.rowPointers[this.rows] + (long)rowPointersY[this.rows]));
            int[] columnIndexesC = new int[cnz];
            double[] valuesC = new double[cnz];
            int nrow = this.rows;
            int ncol = this.columns;
            int nzmax = valuesC.length;
            if (function == DoubleFunctions.plus) {
                int kc;
                rowPointersC[0] = kc = 0;
                for (int i = 0; i < nrow; ++i) {
                    int ka = this.rowPointers[i];
                    int kb = rowPointersY[i];
                    int kamax = this.rowPointers[i + 1] - 1;
                    int kbmax = rowPointersY[i + 1] - 1;
                    while (ka <= kamax || kb <= kbmax) {
                        int j2;
                        int j1 = ka <= kamax ? this.columnIndexes[ka] : ncol + 1;
                        if (j1 == (j2 = kb <= kbmax ? columnIndexesY[kb] : ncol + 1)) {
                            valuesC[kc] = this.values[ka] + valuesY[kb];
                            columnIndexesC[kc] = j1;
                            ++ka;
                            ++kb;
                            ++kc;
                        } else if (j1 < j2) {
                            columnIndexesC[kc] = j1;
                            valuesC[kc] = this.values[ka];
                            ++ka;
                            ++kc;
                        } else if (j1 > j2) {
                            columnIndexesC[kc] = j2;
                            valuesC[kc] = valuesY[kb];
                            ++kb;
                            ++kc;
                        }
                        if (kc < nzmax) continue;
                        throw new IllegalArgumentException("The number of elements in C exceeds nzmax");
                    }
                    rowPointersC[i + 1] = kc;
                }
                this.rowPointers = rowPointersC;
                this.columnIndexes = columnIndexesC;
                this.values = valuesC;
                return this;
            }
        }
        if (function instanceof DoublePlusMultSecond) {
            final double alpha = ((DoublePlusMultSecond)function).multiplicator;
            if (alpha == 0.0) {
                return this;
            }
            y.forEachNonZero(new IntIntDoubleFunction(){

                public double apply(int i, int j, double value) {
                    SparseRCDoubleMatrix2D.this.setQuick(i, j, SparseRCDoubleMatrix2D.this.getQuick(i, j) + alpha * value);
                    return value;
                }
            });
            return this;
        }
        if (function instanceof DoublePlusMultFirst) {
            final double alpha = ((DoublePlusMultFirst)function).multiplicator;
            if (alpha == 0.0) {
                return this.assign(y);
            }
            y.forEachNonZero(new IntIntDoubleFunction(){

                public double apply(int i, int j, double value) {
                    SparseRCDoubleMatrix2D.this.setQuick(i, j, alpha * SparseRCDoubleMatrix2D.this.getQuick(i, j) + value);
                    return value;
                }
            });
            return this;
        }
        if (function == DoubleFunctions.mult) {
            int i = this.rows;
            while (--i >= 0) {
                int low = this.rowPointers[i];
                int k = this.rowPointers[i + 1];
                while (--k >= low) {
                    int j = this.columnIndexes[k];
                    int n = k;
                    this.values[n] = this.values[n] * y.getQuick(i, j);
                    if (this.values[k] != 0.0) continue;
                    this.remove(i, j);
                }
            }
            return this;
        }
        if (function == DoubleFunctions.div) {
            int i = this.rows;
            while (--i >= 0) {
                int low = this.rowPointers[i];
                int k = this.rowPointers[i + 1];
                while (--k >= low) {
                    int j = this.columnIndexes[k];
                    int n = k;
                    this.values[n] = this.values[n] / y.getQuick(i, j);
                    if (this.values[k] != 0.0) continue;
                    this.remove(i, j);
                }
            }
            return this;
        }
        return super.assign(y, function);
    }

    public int cardinality() {
        return this.rowPointers[this.rows];
    }

    public DoubleMatrix2D forEachNonZero(IntIntDoubleFunction function) {
        int i = this.rows;
        while (--i >= 0) {
            int low = this.rowPointers[i];
            int k = this.rowPointers[i + 1];
            while (--k >= low) {
                int j = this.columnIndexes[k];
                double value = this.values[k];
                double r = function.apply(i, j, value);
                if (r == value) continue;
                this.values[k] = r;
            }
        }
        return this;
    }

    public SparseCCDoubleMatrix2D getColumnCompressed() {
        SparseRCDoubleMatrix2D tr = this.getTranspose();
        SparseCCDoubleMatrix2D cc = new SparseCCDoubleMatrix2D(this.rows, this.columns);
        cc.dcs.i = tr.columnIndexes;
        cc.dcs.p = tr.rowPointers;
        cc.dcs.x = tr.values;
        cc.dcs.nzmax = tr.values.length;
        cc.rowIndexesSorted = true;
        return cc;
    }

    public int[] getColumnIndexes() {
        return this.columnIndexes;
    }

    public DenseDoubleMatrix2D getDense() {
        final DenseDoubleMatrix2D dense = new DenseDoubleMatrix2D(this.rows, this.columns);
        this.forEachNonZero(new IntIntDoubleFunction(){

            public double apply(int i, int j, double value) {
                dense.setQuick(i, j, SparseRCDoubleMatrix2D.this.getQuick(i, j));
                return value;
            }
        });
        return dense;
    }

    public synchronized double getQuick(int row, int column) {
        int k = SparseRCDoubleMatrix2D.searchFromTo(this.columnIndexes, column, this.rowPointers[row], this.rowPointers[row + 1] - 1);
        double v = 0.0;
        if (k >= 0) {
            v = this.values[k];
        }
        return v;
    }

    public int[] getRowPointers() {
        return this.rowPointers;
    }

    public SparseRCDoubleMatrix2D getTranspose() {
        int nnz = this.rowPointers[this.rows];
        int[] w = new int[this.columns];
        int[] rowPointersT = new int[this.columns + 1];
        int[] columnIndexesT = new int[nnz];
        double[] valuesT = new double[nnz];
        for (int p = 0; p < nnz; ++p) {
            int n = this.columnIndexes[p];
            w[n] = w[n] + 1;
        }
        this.cumsum(rowPointersT, w, this.columns);
        for (int j = 0; j < this.rows; ++j) {
            int high = this.rowPointers[j + 1];
            for (int p = this.rowPointers[j]; p < high; ++p) {
                int n = this.columnIndexes[p];
                w[n] = w[n] + 1;
                columnIndexesT[q] = j;
                valuesT[q] = this.values[p];
            }
        }
        SparseRCDoubleMatrix2D T = new SparseRCDoubleMatrix2D(this.columns, this.rows);
        T.rowPointers = rowPointersT;
        T.columnIndexes = columnIndexesT;
        T.values = valuesT;
        return T;
    }

    public double[] getValues() {
        return this.values;
    }

    public boolean hasColumnIndexesSorted() {
        return this.columnIndexesSorted;
    }

    public DoubleMatrix2D like(int rows, int columns) {
        return new SparseRCDoubleMatrix2D(rows, columns);
    }

    public DoubleMatrix1D like1D(int size) {
        return new SparseDoubleMatrix1D(size);
    }

    public void removeDuplicates() {
        int i;
        int nz = 0;
        int[] w = new int[this.columns];
        for (i = 0; i < this.columns; ++i) {
            w[i] = -1;
        }
        for (int j = 0; j < this.rows; ++j) {
            int q = nz;
            for (int p = this.rowPointers[j]; p < this.rowPointers[j + 1]; ++p) {
                i = this.columnIndexes[p];
                if (w[i] >= q) {
                    int n = w[i];
                    this.values[n] = this.values[n] + this.values[p];
                    continue;
                }
                w[i] = nz;
                this.columnIndexes[nz] = i;
                this.values[nz++] = this.values[p];
            }
            this.rowPointers[j] = q;
        }
        this.rowPointers[this.rows] = nz;
    }

    public void removeZeroes() {
        int nz = 0;
        double eps = Math.pow(2.0, -52.0);
        for (int j = 0; j < this.rows; ++j) {
            this.rowPointers[j] = nz;
            for (int p = this.rowPointers[j]; p < this.rowPointers[j + 1]; ++p) {
                if (!(Math.abs(this.values[p]) > eps)) continue;
                this.values[nz] = this.values[p];
                this.columnIndexes[nz++] = this.columnIndexes[p];
            }
        }
        this.rowPointers[this.rows] = nz;
    }

    public synchronized void setQuick(int row, int column, double value) {
        int k = SparseRCDoubleMatrix2D.searchFromTo(this.columnIndexes, column, this.rowPointers[row], this.rowPointers[row + 1] - 1);
        if (k >= 0) {
            if (value == 0.0) {
                this.remove(row, k);
            } else {
                this.values[k] = value;
            }
            return;
        }
        if (value != 0.0) {
            k = -k - 1;
            this.insert(row, column, k, value);
        }
    }

    public void sortColumnIndexes() {
        SparseRCDoubleMatrix2D T = this.getTranspose();
        this.rows = T.rows;
        this.columns = T.columns;
        this.columnIndexes = T.columnIndexes;
        this.rowPointers = T.rowPointers;
        this.values = T.values;
        T = this.getTranspose();
        this.rows = T.rows;
        this.columns = T.columns;
        this.columnIndexes = T.columnIndexes;
        this.rowPointers = T.rowPointers;
        this.values = T.values;
        this.columnIndexesSorted = true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.rows).append(" x ").append(this.columns).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        for (int i = 0; i < this.rows; ++i) {
            int high = this.rowPointers[i + 1];
            for (int j = this.rowPointers[i]; j < high; ++j) {
                builder.append('(').append(i).append(',').append(this.columnIndexes[j]).append(')').append('\t').append(this.values[j]).append('\n');
            }
        }
        return builder.toString();
    }

    public void trimToSize() {
        this.realloc(0);
    }

    public DoubleMatrix1D zMult(DoubleMatrix1D y, DoubleMatrix1D z, final double alpha, final double beta, boolean transposeA) {
        boolean ignore;
        int rowsA = transposeA ? this.columns : this.rows;
        int columnsA = transposeA ? this.rows : this.columns;
        boolean bl = ignore = z == null || !transposeA;
        if (z == null) {
            z = new DenseDoubleMatrix1D(rowsA);
        }
        if (!(y instanceof DenseDoubleMatrix1D) || !(z instanceof DenseDoubleMatrix1D)) {
            return super.zMult(y, z, alpha, beta, transposeA);
        }
        if ((long)columnsA != y.size() || (long)rowsA > z.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (transposeA ? this.viewDice() : this).toStringShort() + ", " + y.toStringShort() + ", " + z.toStringShort());
        }
        DenseDoubleMatrix1D zz = (DenseDoubleMatrix1D)z;
        final double[] elementsZ = zz.elements;
        final int strideZ = zz.stride();
        final int zeroZ = (int)z.index(0);
        DenseDoubleMatrix1D yy = (DenseDoubleMatrix1D)y;
        final double[] elementsY = yy.elements;
        final int strideY = yy.stride();
        final int zeroY = (int)y.index(0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (transposeA) {
            if (!ignore && beta != 1.0) {
                z.assign(DoubleFunctions.mult(beta));
            }
            if (nthreads > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                int rem;
                int j;
                nthreads = 2;
                Future[] futures = new Future[nthreads];
                final double[] result = new double[rowsA];
                int k = this.rows / nthreads;
                for (int j2 = 0; j2 < nthreads; ++j2) {
                    final int firstRow = j2 * k;
                    final int lastRow = j2 == nthreads - 1 ? this.rows : firstRow + k;
                    final int threadID = j2;
                    futures[j2] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            if (threadID == 0) {
                                for (int i = firstRow; i < lastRow; ++i) {
                                    int high = SparseRCDoubleMatrix2D.this.rowPointers[i + 1];
                                    double yElem = alpha * elementsY[zeroY + strideY * i];
                                    for (int k = SparseRCDoubleMatrix2D.this.rowPointers[i]; k < high; ++k) {
                                        int j = SparseRCDoubleMatrix2D.this.columnIndexes[k];
                                        int n = zeroZ + strideZ * j;
                                        elementsZ[n] = elementsZ[n] + SparseRCDoubleMatrix2D.this.values[k] * yElem;
                                    }
                                }
                            } else {
                                for (int i = firstRow; i < lastRow; ++i) {
                                    int high = SparseRCDoubleMatrix2D.this.rowPointers[i + 1];
                                    double yElem = alpha * elementsY[zeroY + strideY * i];
                                    for (int k = SparseRCDoubleMatrix2D.this.rowPointers[i]; k < high; ++k) {
                                        int j;
                                        int n = j = SparseRCDoubleMatrix2D.this.columnIndexes[k];
                                        result[n] = result[n] + SparseRCDoubleMatrix2D.this.values[k] * yElem;
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
                for (j = rem = rowsA % 10; j < rowsA; j += 10) {
                    int n = zeroZ + j * strideZ;
                    elementsZ[n] = elementsZ[n] + result[j];
                    int n2 = zeroZ + (j + 1) * strideZ;
                    elementsZ[n2] = elementsZ[n2] + result[j + 1];
                    int n3 = zeroZ + (j + 2) * strideZ;
                    elementsZ[n3] = elementsZ[n3] + result[j + 2];
                    int n4 = zeroZ + (j + 3) * strideZ;
                    elementsZ[n4] = elementsZ[n4] + result[j + 3];
                    int n5 = zeroZ + (j + 4) * strideZ;
                    elementsZ[n5] = elementsZ[n5] + result[j + 4];
                    int n6 = zeroZ + (j + 5) * strideZ;
                    elementsZ[n6] = elementsZ[n6] + result[j + 5];
                    int n7 = zeroZ + (j + 6) * strideZ;
                    elementsZ[n7] = elementsZ[n7] + result[j + 6];
                    int n8 = zeroZ + (j + 7) * strideZ;
                    elementsZ[n8] = elementsZ[n8] + result[j + 7];
                    int n9 = zeroZ + (j + 8) * strideZ;
                    elementsZ[n9] = elementsZ[n9] + result[j + 8];
                    int n10 = zeroZ + (j + 9) * strideZ;
                    elementsZ[n10] = elementsZ[n10] + result[j + 9];
                }
                for (j = 0; j < rem; ++j) {
                    int n = zeroZ + j * strideZ;
                    elementsZ[n] = elementsZ[n] + result[j];
                }
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    int high = this.rowPointers[i + 1];
                    double yElem = alpha * elementsY[zeroY + strideY * i];
                    for (int k = this.rowPointers[i]; k < high; ++k) {
                        int j = this.columnIndexes[k];
                        int n = zeroZ + strideZ * j;
                        elementsZ[n] = elementsZ[n] + this.values[k] * yElem;
                    }
                }
            }
            return z;
        }
        if (nthreads > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int zidx = zeroZ + firstRow * strideZ;
                        int k = SparseRCDoubleMatrix2D.this.rowPointers[firstRow];
                        if (beta == 0.0) {
                            for (int i = firstRow; i < lastRow; ++i) {
                                double sum = 0.0;
                                int high = SparseRCDoubleMatrix2D.this.rowPointers[i + 1];
                                while (k + 10 < high) {
                                    int ind = k + 9;
                                    sum += SparseRCDoubleMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCDoubleMatrix2D.this.columnIndexes[ind--]] + SparseRCDoubleMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCDoubleMatrix2D.this.columnIndexes[ind--]] + SparseRCDoubleMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCDoubleMatrix2D.this.columnIndexes[ind--]] + SparseRCDoubleMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCDoubleMatrix2D.this.columnIndexes[ind--]] + SparseRCDoubleMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCDoubleMatrix2D.this.columnIndexes[ind--]] + SparseRCDoubleMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCDoubleMatrix2D.this.columnIndexes[ind--]] + SparseRCDoubleMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCDoubleMatrix2D.this.columnIndexes[ind--]] + SparseRCDoubleMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCDoubleMatrix2D.this.columnIndexes[ind--]] + SparseRCDoubleMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCDoubleMatrix2D.this.columnIndexes[ind--]] + SparseRCDoubleMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCDoubleMatrix2D.this.columnIndexes[ind--]];
                                    k += 10;
                                }
                                while (k < high) {
                                    sum += SparseRCDoubleMatrix2D.this.values[k] * elementsY[SparseRCDoubleMatrix2D.this.columnIndexes[k]];
                                    ++k;
                                }
                                elementsZ[zidx] = alpha * sum;
                                zidx += strideZ;
                            }
                        } else {
                            for (int i = firstRow; i < lastRow; ++i) {
                                double sum = 0.0;
                                int high = SparseRCDoubleMatrix2D.this.rowPointers[i + 1];
                                while (k + 10 < high) {
                                    int ind = k + 9;
                                    sum += SparseRCDoubleMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCDoubleMatrix2D.this.columnIndexes[ind--]] + SparseRCDoubleMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCDoubleMatrix2D.this.columnIndexes[ind--]] + SparseRCDoubleMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCDoubleMatrix2D.this.columnIndexes[ind--]] + SparseRCDoubleMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCDoubleMatrix2D.this.columnIndexes[ind--]] + SparseRCDoubleMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCDoubleMatrix2D.this.columnIndexes[ind--]] + SparseRCDoubleMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCDoubleMatrix2D.this.columnIndexes[ind--]] + SparseRCDoubleMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCDoubleMatrix2D.this.columnIndexes[ind--]] + SparseRCDoubleMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCDoubleMatrix2D.this.columnIndexes[ind--]] + SparseRCDoubleMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCDoubleMatrix2D.this.columnIndexes[ind--]] + SparseRCDoubleMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCDoubleMatrix2D.this.columnIndexes[ind--]];
                                    k += 10;
                                }
                                while (k < high) {
                                    sum += SparseRCDoubleMatrix2D.this.values[k] * elementsY[SparseRCDoubleMatrix2D.this.columnIndexes[k]];
                                    ++k;
                                }
                                elementsZ[zidx] = alpha * sum + beta * elementsZ[zidx];
                                zidx += strideZ;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int zidx = zeroZ;
            int k = this.rowPointers[0];
            if (beta == 0.0) {
                for (int i = 0; i < this.rows; ++i) {
                    double sum = 0.0;
                    int high = this.rowPointers[i + 1];
                    while (k + 10 < high) {
                        int ind = k + 9;
                        sum += this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]];
                        k += 10;
                    }
                    while (k < high) {
                        sum += this.values[k] * elementsY[this.columnIndexes[k]];
                        ++k;
                    }
                    elementsZ[zidx] = alpha * sum;
                    zidx += strideZ;
                }
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    double sum = 0.0;
                    int high = this.rowPointers[i + 1];
                    while (k + 10 < high) {
                        int ind = k + 9;
                        sum += this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]];
                        k += 10;
                    }
                    while (k < high) {
                        sum += this.values[k] * elementsY[this.columnIndexes[k]];
                        ++k;
                    }
                    elementsZ[zidx] = alpha * sum + beta * elementsZ[zidx];
                    zidx += strideZ;
                }
            }
        }
        return z;
    }

    public DoubleMatrix2D zMult(DoubleMatrix2D B, DoubleMatrix2D C, double alpha, double beta, boolean transposeA, boolean transposeB) {
        boolean ignore;
        int rowsA = this.rows;
        int columnsA = this.columns;
        if (transposeA) {
            rowsA = this.columns;
            columnsA = this.rows;
        }
        int rowsB = B.rows();
        int columnsB = B.columns();
        if (transposeB) {
            rowsB = B.columns();
            columnsB = B.rows();
        }
        int p = columnsB;
        boolean bl = ignore = C == null;
        if (C == null) {
            C = B instanceof SparseRCDoubleMatrix2D ? new SparseRCDoubleMatrix2D(rowsA, p, rowsA * p) : new DenseDoubleMatrix2D(rowsA, p);
        }
        if (rowsB != columnsA) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + (transposeB ? B.viewDice() : B).toStringShort());
        }
        if (C.rows() != rowsA || C.columns() != p) {
            throw new IllegalArgumentException("Incompatible result matrix: " + this.toStringShort() + ", " + (transposeB ? B.viewDice() : B).toStringShort() + ", " + C.toStringShort());
        }
        if (this == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!ignore && beta != 1.0) {
            C.assign(DoubleFunctions.mult(beta));
        }
        if (B instanceof DenseDoubleMatrix2D && C instanceof DenseDoubleMatrix2D) {
            SparseRCDoubleMatrix2D AA = transposeA ? this.getTranspose() : this;
            DenseDoubleMatrix2D BB = transposeB ? (DenseDoubleMatrix2D)B.viewDice() : (DenseDoubleMatrix2D)B;
            DenseDoubleMatrix2D CC = (DenseDoubleMatrix2D)C;
            int[] rowPointersA = AA.rowPointers;
            int[] columnIndexesA = AA.columnIndexes;
            double[] valuesA = AA.values;
            for (int ii = 0; ii < rowsA; ++ii) {
                int highA = rowPointersA[ii + 1];
                for (int ka = rowPointersA[ii]; ka < highA; ++ka) {
                    double scal = valuesA[ka] * alpha;
                    int jj = columnIndexesA[ka];
                    CC.viewRow(ii).assign(BB.viewRow(jj), DoubleFunctions.plusMultSecond(scal));
                }
            }
        } else if (B instanceof SparseRCDoubleMatrix2D && C instanceof SparseRCDoubleMatrix2D) {
            SparseRCDoubleMatrix2D CC = (SparseRCDoubleMatrix2D)C;
            SparseRCDoubleMatrix2D AA = transposeA ? this.getTranspose() : this;
            SparseRCDoubleMatrix2D BB = transposeB ? ((SparseRCDoubleMatrix2D)B).getTranspose() : (SparseRCDoubleMatrix2D)B;
            int[] rowPointersA = AA.rowPointers;
            int[] columnIndexesA = AA.columnIndexes;
            double[] valuesA = AA.values;
            int[] rowPointersB = BB.rowPointers;
            int[] columnIndexesB = BB.columnIndexes;
            double[] valuesB = BB.values;
            int[] rowPointersC = CC.rowPointers;
            int[] columnIndexesC = CC.columnIndexes;
            double[] valuesC = CC.values;
            int nzmax = valuesC.length;
            int[] iw = new int[columnsB + 1];
            for (int i = 0; i < iw.length; ++i) {
                iw[i] = -1;
            }
            int len = -1;
            for (int ii = 0; ii < rowsA; ++ii) {
                int highA = rowPointersA[ii + 1];
                for (int ka = rowPointersA[ii]; ka < highA; ++ka) {
                    double scal = valuesA[ka] * alpha;
                    int jj = columnIndexesA[ka];
                    int highB = rowPointersB[jj + 1];
                    for (int kb = rowPointersB[jj]; kb < highB; ++kb) {
                        int jcol = columnIndexesB[kb];
                        int jpos = iw[jcol];
                        if (jpos == -1) {
                            if (++len >= nzmax) {
                                throw new IllegalArgumentException("The max number of nonzero elements in C is too small.");
                            }
                            columnIndexesC[len] = jcol;
                            iw[jcol] = len;
                            valuesC[len] = scal * valuesB[kb];
                            continue;
                        }
                        int n = jpos;
                        valuesC[n] = valuesC[n] + scal * valuesB[kb];
                    }
                }
                for (int k = rowPointersC[ii]; k < len + 1; ++k) {
                    iw[columnIndexesC[k]] = -1;
                }
                rowPointersC[ii + 1] = len + 1;
            }
        } else {
            if (transposeB) {
                B = B.viewDice();
            }
            DoubleMatrix1D[] Brows = new DoubleMatrix1D[columnsA];
            int i = columnsA;
            while (--i >= 0) {
                Brows[i] = B.viewRow(i);
            }
            DoubleMatrix1D[] Crows = new DoubleMatrix1D[rowsA];
            int i2 = rowsA;
            while (--i2 >= 0) {
                Crows[i2] = C.viewRow(i2);
            }
            DoublePlusMultSecond fun = DoublePlusMultSecond.plusMult(0.0);
            int[] columnIndexesA = this.columnIndexes;
            double[] valuesA = this.values;
            int i3 = this.rows;
            while (--i3 >= 0) {
                int low = this.rowPointers[i3];
                int k = this.rowPointers[i3 + 1];
                while (--k >= low) {
                    int j = columnIndexesA[k];
                    fun.multiplicator = valuesA[k] * alpha;
                    if (!transposeA) {
                        Crows[i3].assign(Brows[j], fun);
                        continue;
                    }
                    Crows[j].assign(Brows[i3], fun);
                }
            }
        }
        return C;
    }

    private double cumsum(int[] p, int[] c, int n) {
        int nz = 0;
        double nz2 = 0.0;
        for (int k = 0; k < n; ++k) {
            p[k] = nz;
            nz += c[k];
            nz2 += (double)c[k];
            c[k] = p[k];
        }
        p[n] = nz;
        return nz2;
    }

    private void realloc(int nzmax) {
        if (nzmax <= 0) {
            nzmax = this.rowPointers[this.rows];
        }
        int[] columnIndexesNew = new int[nzmax];
        int length = Math.min(nzmax, this.columnIndexes.length);
        System.arraycopy(this.columnIndexes, 0, columnIndexesNew, 0, length);
        this.columnIndexes = columnIndexesNew;
        double[] valuesNew = new double[nzmax];
        length = Math.min(nzmax, this.values.length);
        System.arraycopy(this.values, 0, valuesNew, 0, length);
        this.values = valuesNew;
    }

    protected DoubleMatrix2D getContent() {
        return this;
    }

    protected void insert(int row, int column, int index, double value) {
        IntArrayList columnIndexesList = new IntArrayList(this.columnIndexes);
        columnIndexesList.setSizeRaw(this.rowPointers[this.rows]);
        DoubleArrayList valuesList = new DoubleArrayList(this.values);
        valuesList.setSizeRaw(this.rowPointers[this.rows]);
        columnIndexesList.beforeInsert(index, column);
        valuesList.beforeInsert(index, value);
        int i = this.rowPointers.length;
        while (--i > row) {
            int n = i;
            this.rowPointers[n] = this.rowPointers[n] + 1;
        }
        this.columnIndexes = columnIndexesList.elements();
        this.values = valuesList.elements();
    }

    protected void remove(int row, int index) {
        IntArrayList columnIndexesList = new IntArrayList(this.columnIndexes);
        columnIndexesList.setSizeRaw(this.rowPointers[this.rows]);
        DoubleArrayList valuesList = new DoubleArrayList(this.values);
        valuesList.setSizeRaw(this.rowPointers[this.rows]);
        columnIndexesList.remove(index);
        valuesList.remove(index);
        int i = this.rowPointers.length;
        while (--i > row) {
            int n = i;
            this.rowPointers[n] = this.rowPointers[n] - 1;
        }
        this.columnIndexes = columnIndexesList.elements();
        this.values = valuesList.elements();
    }
}

