/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.matrix.tdcomplex.impl.DenseLargeDComplexMatrix3D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.impl.WrapperDoubleMatrix3D;
import edu.emory.mathcs.jtransforms.dct.DoubleDCT_2D;
import edu.emory.mathcs.jtransforms.dct.DoubleDCT_3D;
import edu.emory.mathcs.jtransforms.dht.DoubleDHT_2D;
import edu.emory.mathcs.jtransforms.dht.DoubleDHT_3D;
import edu.emory.mathcs.jtransforms.dst.DoubleDST_2D;
import edu.emory.mathcs.jtransforms.dst.DoubleDST_3D;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_2D;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_3D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class DenseLargeDoubleMatrix3D
extends WrapperDoubleMatrix3D {
    private static final long serialVersionUID = 1L;
    private double[][][] elements;
    private DoubleFFT_3D fft3;
    private DoubleDCT_3D dct3;
    private DoubleDST_3D dst3;
    private DoubleDHT_3D dht3;
    private DoubleFFT_2D fft2Slices;
    private DoubleDCT_2D dct2Slices;
    private DoubleDST_2D dst2Slices;
    private DoubleDHT_2D dht2Slices;

    public DenseLargeDoubleMatrix3D(int slices, int rows, int columns) {
        block2: {
            super(null);
            try {
                this.setUp(slices, rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.elements = new double[slices][rows][columns];
    }

    public void dct3(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dct3 == null) {
            this.dct3 = new DoubleDCT_3D(this.slices, this.rows, this.columns);
        }
        this.dct3.forward(this.elements, scale);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dct2Slices(final boolean scale) {
        int nthreads;
        if (this.dct2Slices == null) {
            this.dct2Slices = new DoubleDCT_2D(this.rows, this.columns);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            ConcurrencyUtils.setThreadsBeginN_2D(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            DenseLargeDoubleMatrix3D.this.dct2Slices.forward(DenseLargeDoubleMatrix3D.this.elements[s], scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN();
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int s = 0; s < this.slices; ++s) {
                this.dct2Slices.forward(this.elements[s], scale);
            }
        }
    }

    public void dht3() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dht3 == null) {
            this.dht3 = new DoubleDHT_3D(this.slices, this.rows, this.columns);
        }
        this.dht3.forward(this.elements);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dht2Slices() {
        int nthreads;
        if (this.dht2Slices == null) {
            this.dht2Slices = new DoubleDHT_2D(this.rows, this.columns);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            ConcurrencyUtils.setThreadsBeginN_2D(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            DenseLargeDoubleMatrix3D.this.dht2Slices.forward(DenseLargeDoubleMatrix3D.this.elements[s]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN();
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int s = 0; s < this.slices; ++s) {
                this.dht2Slices.forward(this.elements[s]);
            }
        }
    }

    public void dst3(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dst3 == null) {
            this.dst3 = new DoubleDST_3D(this.slices, this.rows, this.columns);
        }
        this.dst3.forward(this.elements, scale);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dst2Slices(final boolean scale) {
        int nthreads;
        if (this.dst2Slices == null) {
            this.dst2Slices = new DoubleDST_2D(this.rows, this.columns);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            ConcurrencyUtils.setThreadsBeginN_2D(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            DenseLargeDoubleMatrix3D.this.dst2Slices.forward(DenseLargeDoubleMatrix3D.this.elements[s], scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN();
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int s = 0; s < this.slices; ++s) {
                this.dst2Slices.forward(this.elements[s], scale);
            }
        }
    }

    public void fft3() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft3 == null) {
            this.fft3 = new DoubleFFT_3D(this.slices, this.rows, this.columns);
        }
        this.fft3.realForward(this.elements);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public DenseLargeDComplexMatrix3D getFft2Slices() {
        if (this.fft2Slices == null) {
            this.fft2Slices = new DoubleFFT_2D(this.rows, this.columns);
        }
        DenseLargeDComplexMatrix3D C = new DenseLargeDComplexMatrix3D(this.slices, this.rows, this.columns);
        final double[][][] cElems = C.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            ConcurrencyUtils.setThreadsBeginN_2D(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DenseLargeDoubleMatrix3D.this.rows; ++r) {
                                System.arraycopy(DenseLargeDoubleMatrix3D.this.elements[s][r], 0, cElems[s][r], 0, DenseLargeDoubleMatrix3D.this.columns);
                            }
                            DenseLargeDoubleMatrix3D.this.fft2Slices.realForwardFull(cElems[s]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN();
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    System.arraycopy(this.elements[s][r], 0, cElems[s][r], 0, this.columns);
                }
                this.fft2Slices.realForwardFull(cElems[s]);
            }
        }
        return C;
    }

    public DenseLargeDComplexMatrix3D getFft3() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        DenseLargeDComplexMatrix3D C = new DenseLargeDComplexMatrix3D(this.slices, this.rows, this.columns);
        final double[][][] cElems = C.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int startslice = j * k;
                final int stopslice = j == nthreads - 1 ? this.slices : startslice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = startslice; s < stopslice; ++s) {
                            for (int r = 0; r < DenseLargeDoubleMatrix3D.this.rows; ++r) {
                                System.arraycopy(DenseLargeDoubleMatrix3D.this.elements[s][r], 0, cElems[s][r], 0, DenseLargeDoubleMatrix3D.this.columns);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    System.arraycopy(this.elements[s][r], 0, cElems[s][r], 0, this.columns);
                }
            }
        }
        if (this.fft3 == null) {
            this.fft3 = new DoubleFFT_3D(this.slices, this.rows, this.columns);
        }
        this.fft3.realForwardFull(cElems);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    public DenseLargeDComplexMatrix3D getIfft2Slices(final boolean scale) {
        if (this.fft2Slices == null) {
            this.fft2Slices = new DoubleFFT_2D(this.rows, this.columns);
        }
        DenseLargeDComplexMatrix3D C = new DenseLargeDComplexMatrix3D(this.slices, this.rows, this.columns);
        final double[][][] cElems = C.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            ConcurrencyUtils.setThreadsBeginN_2D(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DenseLargeDoubleMatrix3D.this.rows; ++r) {
                                System.arraycopy(DenseLargeDoubleMatrix3D.this.elements[s][r], 0, cElems[s][r], 0, DenseLargeDoubleMatrix3D.this.columns);
                            }
                            DenseLargeDoubleMatrix3D.this.fft2Slices.realInverseFull(cElems[s], scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN();
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    System.arraycopy(this.elements[s][r], 0, cElems[s][r], 0, this.columns);
                }
                this.fft2Slices.realInverseFull(cElems[s], scale);
            }
        }
        return C;
    }

    public DenseLargeDComplexMatrix3D getIfft3(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        DenseLargeDComplexMatrix3D C = new DenseLargeDComplexMatrix3D(this.slices, this.rows, this.columns);
        final double[][][] cElems = C.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int startslice = j * k;
                final int stopslice = j == nthreads - 1 ? this.slices : startslice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = startslice; s < stopslice; ++s) {
                            for (int r = 0; r < DenseLargeDoubleMatrix3D.this.rows; ++r) {
                                System.arraycopy(DenseLargeDoubleMatrix3D.this.elements[s][r], 0, cElems[s][r], 0, DenseLargeDoubleMatrix3D.this.columns);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    System.arraycopy(this.elements[s][r], 0, cElems[s][r], 0, this.columns);
                }
            }
        }
        if (this.fft3 == null) {
            this.fft3 = new DoubleFFT_3D(this.slices, this.rows, this.columns);
        }
        this.fft3.realInverseFull(cElems, scale);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    public double getQuick(int slice, int row, int column) {
        return this.elements[slice][row][column];
    }

    public void idct2Slices(final boolean scale) {
        int nthreads;
        if (this.dct2Slices == null) {
            this.dct2Slices = new DoubleDCT_2D(this.rows, this.columns);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            ConcurrencyUtils.setThreadsBeginN_2D(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            DenseLargeDoubleMatrix3D.this.dct2Slices.inverse(DenseLargeDoubleMatrix3D.this.elements[s], scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN();
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int s = 0; s < this.slices; ++s) {
                this.dct2Slices.inverse(this.elements[s], scale);
            }
        }
    }

    public void idht3(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dht3 == null) {
            this.dht3 = new DoubleDHT_3D(this.slices, this.rows, this.columns);
        }
        this.dht3.inverse(this.elements, scale);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idht2Slices(final boolean scale) {
        int nthreads;
        if (this.dht2Slices == null) {
            this.dht2Slices = new DoubleDHT_2D(this.rows, this.columns);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            ConcurrencyUtils.setThreadsBeginN_2D(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            DenseLargeDoubleMatrix3D.this.dht2Slices.inverse(DenseLargeDoubleMatrix3D.this.elements[s], scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN();
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int s = 0; s < this.slices; ++s) {
                this.dht2Slices.inverse(this.elements[s], scale);
            }
        }
    }

    public void idct3(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dct3 == null) {
            this.dct3 = new DoubleDCT_3D(this.slices, this.rows, this.columns);
        }
        this.dct3.inverse(this.elements, scale);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idst2Slices(final boolean scale) {
        int nthreads;
        if (this.dst2Slices == null) {
            this.dst2Slices = new DoubleDST_2D(this.rows, this.columns);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            ConcurrencyUtils.setThreadsBeginN_2D(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            DenseLargeDoubleMatrix3D.this.dst2Slices.inverse(DenseLargeDoubleMatrix3D.this.elements[s], scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN();
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int s = 0; s < this.slices; ++s) {
                this.dst2Slices.inverse(this.elements[s], scale);
            }
        }
    }

    public void idst3(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dst3 == null) {
            this.dst3 = new DoubleDST_3D(this.slices, this.rows, this.columns);
        }
        this.dst3.inverse(this.elements, scale);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void ifft3(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft3 == null) {
            this.fft3 = new DoubleFFT_3D(this.slices, this.rows, this.columns);
        }
        this.fft3.realInverse(this.elements, scale);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void setQuick(int slice, int row, int column, double value) {
        this.elements[slice][row][column] = value;
    }

    public double[][][] elements() {
        return this.elements;
    }

    protected DoubleMatrix3D getContent() {
        return this;
    }

    public DoubleMatrix3D like(int slices, int rows, int columns) {
        return new DenseLargeDoubleMatrix3D(slices, rows, columns);
    }
}

