/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.matrix.tdcomplex.impl.DenseLargeDComplexMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.WrapperDoubleMatrix2D;
import edu.emory.mathcs.jtransforms.dct.DoubleDCT_1D;
import edu.emory.mathcs.jtransforms.dct.DoubleDCT_2D;
import edu.emory.mathcs.jtransforms.dht.DoubleDHT_1D;
import edu.emory.mathcs.jtransforms.dht.DoubleDHT_2D;
import edu.emory.mathcs.jtransforms.dst.DoubleDST_1D;
import edu.emory.mathcs.jtransforms.dst.DoubleDST_2D;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class DenseLargeDoubleMatrix2D
extends WrapperDoubleMatrix2D {
    private static final long serialVersionUID = 1L;
    private double[][] elements;
    private DoubleFFT_2D fft2;
    private DoubleDCT_2D dct2;
    private DoubleDST_2D dst2;
    private DoubleDHT_2D dht2;
    private DoubleFFT_1D fftRows;
    private DoubleFFT_1D fftColumns;
    private DoubleDCT_1D dctRows;
    private DoubleDCT_1D dctColumns;
    private DoubleDST_1D dstRows;
    private DoubleDST_1D dstColumns;
    private DoubleDHT_1D dhtRows;
    private DoubleDHT_1D dhtColumns;

    public DenseLargeDoubleMatrix2D(int rows, int columns) {
        block2: {
            super(null);
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.elements = new double[rows][columns];
        this.content = this;
    }

    public void dct2(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dct2 == null) {
            this.dct2 = new DoubleDCT_2D(this.rows, this.columns);
        }
        this.dct2.forward(this.elements, scale);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dctColumns(final boolean scale) {
        int nthreads;
        if (this.dctColumns == null) {
            this.dctColumns = new DoubleDCT_1D(this.rows);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstCol = j * k;
                final int lastCol = j == nthreads - 1 ? this.columns : firstCol + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int c = firstCol; c < lastCol; ++c) {
                            double[] column = (double[])DenseLargeDoubleMatrix2D.this.viewColumn(c).copy().elements();
                            DenseLargeDoubleMatrix2D.this.dctColumns.forward(column, scale);
                            DenseLargeDoubleMatrix2D.this.viewColumn(c).assign(column);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int c = 0; c < this.columns; ++c) {
                double[] column = (double[])this.viewColumn(c).copy().elements();
                this.dctColumns.forward(column, scale);
                this.viewColumn(c).assign(column);
            }
        }
    }

    public void dctRows(final boolean scale) {
        int nthreads;
        if (this.dctRows == null) {
            this.dctRows = new DoubleDCT_1D(this.columns);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            DenseLargeDoubleMatrix2D.this.dctRows.forward(DenseLargeDoubleMatrix2D.this.elements[r], scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int r = 0; r < this.rows; ++r) {
                this.dctRows.forward(this.elements[r], scale);
            }
        }
    }

    public void dht2() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dht2 == null) {
            this.dht2 = new DoubleDHT_2D(this.rows, this.columns);
        }
        this.dht2.forward(this.elements);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dhtColumns() {
        int nthreads;
        if (this.dhtColumns == null) {
            this.dhtColumns = new DoubleDHT_1D(this.rows);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstCol = j * k;
                final int lastCol = j == nthreads - 1 ? this.columns : firstCol + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int c = firstCol; c < lastCol; ++c) {
                            double[] column = (double[])DenseLargeDoubleMatrix2D.this.viewColumn(c).copy().elements();
                            DenseLargeDoubleMatrix2D.this.dhtColumns.forward(column);
                            DenseLargeDoubleMatrix2D.this.viewColumn(c).assign(column);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int c = 0; c < this.columns; ++c) {
                double[] column = (double[])this.viewColumn(c).copy().elements();
                this.dhtColumns.forward(column);
                this.viewColumn(c).assign(column);
            }
        }
    }

    public void dhtRows() {
        int nthreads;
        if (this.dhtRows == null) {
            this.dhtRows = new DoubleDHT_1D(this.columns);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            DenseLargeDoubleMatrix2D.this.dhtRows.forward(DenseLargeDoubleMatrix2D.this.elements[r]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int r = 0; r < this.rows; ++r) {
                this.dhtRows.forward(this.elements[r]);
            }
        }
    }

    public void dst2(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dst2 == null) {
            this.dst2 = new DoubleDST_2D(this.rows, this.columns);
        }
        this.dst2.forward(this.elements, scale);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dstColumns(final boolean scale) {
        int nthreads;
        if (this.dstColumns == null) {
            this.dstColumns = new DoubleDST_1D(this.rows);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstCol = j * k;
                final int lastCol = j == nthreads - 1 ? this.columns : firstCol + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int c = firstCol; c < lastCol; ++c) {
                            double[] column = (double[])DenseLargeDoubleMatrix2D.this.viewColumn(c).copy().elements();
                            DenseLargeDoubleMatrix2D.this.dstColumns.forward(column, scale);
                            DenseLargeDoubleMatrix2D.this.viewColumn(c).assign(column);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int c = 0; c < this.columns; ++c) {
                double[] column = (double[])this.viewColumn(c).copy().elements();
                this.dstColumns.forward(column, scale);
                this.viewColumn(c).assign(column);
            }
        }
    }

    public void dstRows(final boolean scale) {
        int nthreads;
        if (this.dstRows == null) {
            this.dstRows = new DoubleDST_1D(this.columns);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            DenseLargeDoubleMatrix2D.this.dstRows.forward(DenseLargeDoubleMatrix2D.this.elements[r], scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int r = 0; r < this.rows; ++r) {
                this.dstRows.forward(this.elements[r], scale);
            }
        }
    }

    public void fft2() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft2 == null) {
            this.fft2 = new DoubleFFT_2D(this.rows, this.columns);
        }
        this.fft2.realForward(this.elements);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public DenseLargeDComplexMatrix2D getFft2() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft2 == null) {
            this.fft2 = new DoubleFFT_2D(this.rows, this.columns);
        }
        DenseLargeDComplexMatrix2D C = new DenseLargeDComplexMatrix2D(this.rows, this.columns);
        final double[][] elementsC = C.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            System.arraycopy(DenseLargeDoubleMatrix2D.this.elements[r], 0, elementsC[r], 0, DenseLargeDoubleMatrix2D.this.columns);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                System.arraycopy(this.elements[r], 0, elementsC[r], 0, this.columns);
            }
        }
        this.fft2.realForwardFull(elementsC);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    public DenseLargeDComplexMatrix2D getFftColumns() {
        if (this.fftColumns == null) {
            this.fftColumns = new DoubleFFT_1D(this.rows);
        }
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        final DenseLargeDComplexMatrix2D C = new DenseLargeDComplexMatrix2D(this.rows, this.columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstCol = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstCol + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int c = firstCol; c < lastColumn; ++c) {
                            double[] column = new double[2 * DenseLargeDoubleMatrix2D.this.rows];
                            System.arraycopy(DenseLargeDoubleMatrix2D.this.viewColumn(c).copy().elements(), 0, column, 0, DenseLargeDoubleMatrix2D.this.rows);
                            DenseLargeDoubleMatrix2D.this.fftColumns.realForwardFull(column);
                            C.viewColumn(c).assign(column);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int c = 0; c < this.columns; ++c) {
                double[] column = new double[2 * this.rows];
                System.arraycopy(this.viewColumn(c).copy().elements(), 0, column, 0, this.rows);
                this.fftColumns.realForwardFull(column);
                C.viewColumn(c).assign(column);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    public DenseLargeDComplexMatrix2D getFftRows() {
        if (this.fftRows == null) {
            this.fftRows = new DoubleFFT_1D(this.columns);
        }
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        final DenseLargeDComplexMatrix2D C = new DenseLargeDComplexMatrix2D(this.rows, this.columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            double[] row = new double[2 * DenseLargeDoubleMatrix2D.this.columns];
                            System.arraycopy(DenseLargeDoubleMatrix2D.this.elements[r], 0, row, 0, DenseLargeDoubleMatrix2D.this.columns);
                            DenseLargeDoubleMatrix2D.this.fftRows.realForwardFull(row);
                            C.viewRow(r).assign(row);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int r = 0; r < this.rows; ++r) {
                double[] row = new double[2 * this.columns];
                System.arraycopy(this.elements[r], 0, row, 0, this.columns);
                this.fftRows.realForwardFull(row);
                C.viewRow(r).assign(row);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    public DenseLargeDComplexMatrix2D getIfft2(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        DenseLargeDComplexMatrix2D C = new DenseLargeDComplexMatrix2D(this.rows, this.columns);
        final double[][] elementsC = C.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            System.arraycopy(DenseLargeDoubleMatrix2D.this.elements[r], 0, elementsC[r], 0, DenseLargeDoubleMatrix2D.this.columns);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                System.arraycopy(this.elements[r], 0, elementsC[r], 0, this.columns);
            }
        }
        if (this.fft2 == null) {
            this.fft2 = new DoubleFFT_2D(this.rows, this.columns);
        }
        this.fft2.realInverseFull(elementsC, scale);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    public DenseLargeDComplexMatrix2D getIfftColumns(final boolean scale) {
        if (this.fftColumns == null) {
            this.fftColumns = new DoubleFFT_1D(this.rows);
        }
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        final DenseLargeDComplexMatrix2D C = new DenseLargeDComplexMatrix2D(this.rows, this.columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int c = firstColumn; c < lastColumn; ++c) {
                            double[] column = new double[2 * DenseLargeDoubleMatrix2D.this.rows];
                            System.arraycopy(DenseLargeDoubleMatrix2D.this.viewColumn(c).copy().elements(), 0, column, 0, DenseLargeDoubleMatrix2D.this.rows);
                            DenseLargeDoubleMatrix2D.this.fftColumns.realInverseFull(column, scale);
                            C.viewColumn(c).assign(column);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int c = 0; c < this.columns; ++c) {
                double[] column = new double[2 * this.rows];
                System.arraycopy(this.viewColumn(c).copy().elements(), 0, column, 0, this.rows);
                this.fftColumns.realInverseFull(column, scale);
                C.viewColumn(c).assign(column);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    public DenseLargeDComplexMatrix2D getIfftRows(final boolean scale) {
        if (this.fftRows == null) {
            this.fftRows = new DoubleFFT_1D(this.columns);
        }
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        final DenseLargeDComplexMatrix2D C = new DenseLargeDComplexMatrix2D(this.rows, this.columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            double[] row = new double[2 * DenseLargeDoubleMatrix2D.this.columns];
                            System.arraycopy(DenseLargeDoubleMatrix2D.this.elements[r], 0, row, 0, DenseLargeDoubleMatrix2D.this.columns);
                            DenseLargeDoubleMatrix2D.this.fftRows.realInverseFull(row, scale);
                            C.viewRow(r).assign(row);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int r = 0; r < this.rows; ++r) {
                double[] row = new double[2 * this.columns];
                System.arraycopy(this.elements[r], 0, row, 0, this.columns);
                this.fftRows.realInverseFull(row, scale);
                C.viewRow(r).assign(row);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    public double getQuick(int row, int column) {
        return this.elements[row][column];
    }

    public void idct2(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dct2 == null) {
            this.dct2 = new DoubleDCT_2D(this.rows, this.columns);
        }
        this.dct2.inverse(this.elements, scale);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idctColumns(final boolean scale) {
        int nthreads;
        if (this.dctColumns == null) {
            this.dctColumns = new DoubleDCT_1D(this.rows);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int c = firstColumn; c < lastColumn; ++c) {
                            double[] column = (double[])DenseLargeDoubleMatrix2D.this.viewColumn(c).copy().elements();
                            DenseLargeDoubleMatrix2D.this.dctColumns.inverse(column, scale);
                            DenseLargeDoubleMatrix2D.this.viewColumn(c).assign(column);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int c = 0; c < this.columns; ++c) {
                double[] column = (double[])this.viewColumn(c).copy().elements();
                this.dctColumns.inverse(column, scale);
                this.viewColumn(c).assign(column);
            }
        }
    }

    public void idctRows(final boolean scale) {
        int nthreads;
        if (this.dctRows == null) {
            this.dctRows = new DoubleDCT_1D(this.columns);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            DenseLargeDoubleMatrix2D.this.dctRows.inverse(DenseLargeDoubleMatrix2D.this.elements[r], scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int r = 0; r < this.rows; ++r) {
                this.dctRows.inverse(this.elements[r], scale);
            }
        }
    }

    public void idht2(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dht2 == null) {
            this.dht2 = new DoubleDHT_2D(this.rows, this.columns);
        }
        this.dht2.inverse(this.elements, scale);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idhtColumns(final boolean scale) {
        int nthreads;
        if (this.dhtColumns == null) {
            this.dhtColumns = new DoubleDHT_1D(this.rows);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int c = firstColumn; c < lastColumn; ++c) {
                            double[] column = (double[])DenseLargeDoubleMatrix2D.this.viewColumn(c).copy().elements();
                            DenseLargeDoubleMatrix2D.this.dhtColumns.inverse(column, scale);
                            DenseLargeDoubleMatrix2D.this.viewColumn(c).assign(column);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int c = 0; c < this.columns; ++c) {
                double[] column = (double[])this.viewColumn(c).copy().elements();
                this.dhtColumns.inverse(column, scale);
                this.viewColumn(c).assign(column);
            }
        }
    }

    public void idhtRows(final boolean scale) {
        int nthreads;
        if (this.dhtRows == null) {
            this.dhtRows = new DoubleDHT_1D(this.columns);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            DenseLargeDoubleMatrix2D.this.dhtRows.inverse(DenseLargeDoubleMatrix2D.this.elements[r], scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int r = 0; r < this.rows; ++r) {
                this.dhtRows.inverse(this.elements[r], scale);
            }
        }
    }

    public void idst2(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dst2 == null) {
            this.dst2 = new DoubleDST_2D(this.rows, this.columns);
        }
        this.dst2.inverse(this.elements, scale);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idstColumns(final boolean scale) {
        int nthreads;
        if (this.dstColumns == null) {
            this.dstColumns = new DoubleDST_1D(this.rows);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int c = firstColumn; c < lastColumn; ++c) {
                            double[] column = (double[])DenseLargeDoubleMatrix2D.this.viewColumn(c).copy().elements();
                            DenseLargeDoubleMatrix2D.this.dstColumns.inverse(column, scale);
                            DenseLargeDoubleMatrix2D.this.viewColumn(c).assign(column);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int c = 0; c < this.columns; ++c) {
                double[] column = (double[])this.viewColumn(c).copy().elements();
                this.dstColumns.inverse(column, scale);
                this.viewColumn(c).assign(column);
            }
        }
    }

    public void idstRows(final boolean scale) {
        int nthreads;
        if (this.dstRows == null) {
            this.dstRows = new DoubleDST_1D(this.columns);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            DenseLargeDoubleMatrix2D.this.dstRows.inverse(DenseLargeDoubleMatrix2D.this.elements[r], scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int r = 0; r < this.rows; ++r) {
                this.dstRows.inverse(this.elements[r], scale);
            }
        }
    }

    public void ifft2(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft2 == null) {
            this.fft2 = new DoubleFFT_2D(this.rows, this.columns);
        }
        this.fft2.realInverse(this.elements, scale);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void setQuick(int row, int column, double value) {
        this.elements[row][column] = value;
    }

    public double[][] elements() {
        return this.elements;
    }

    protected DoubleMatrix2D getContent() {
        return this;
    }

    public DoubleMatrix2D like(int rows, int columns) {
        return new DenseLargeDoubleMatrix2D(rows, columns);
    }

    public DoubleMatrix1D like1D(int size) {
        return new DenseDoubleMatrix1D(size);
    }
}

