/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver.preconditioner;

import cern.colt.Sorting;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.colt.matrix.tdouble.algo.solver.preconditioner.DoublePreconditioner;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.SparseRCDoubleMatrix2D;
import java.util.Arrays;

public class DoubleICC
implements DoublePreconditioner {
    private SparseRCDoubleMatrix2D R;
    private final DoubleMatrix1D y;
    private int[] diagind;
    private final int n;

    public DoubleICC(int n) {
        this.n = n;
        this.y = new DenseDoubleMatrix1D(n);
    }

    public DoubleMatrix1D apply(DoubleMatrix1D b, DoubleMatrix1D x) {
        if (x == null) {
            x = b.like();
        }
        this.upperTransSolve(b, this.y);
        return this.upperSolve(this.y, x);
    }

    public DoubleMatrix1D transApply(DoubleMatrix1D b, DoubleMatrix1D x) {
        if (x == null) {
            x = b.like();
        }
        return this.apply(b, x);
    }

    public void setMatrix(DoubleMatrix2D A) {
        DoubleProperty.DEFAULT.isSquare(A);
        if (A.rows() != this.n) {
            throw new IllegalArgumentException("A.rows() != n");
        }
        this.R = new SparseRCDoubleMatrix2D(this.n, this.n);
        this.R.assign(A);
        if (!this.R.hasColumnIndexesSorted()) {
            this.R.sortColumnIndexes();
        }
        this.factor();
    }

    private void factor() {
        int n = this.R.rows();
        int[] colind = this.R.getColumnIndexes();
        int[] rowptr = this.R.getRowPointers();
        double[] data = this.R.getValues();
        double[] Rk = new double[n];
        this.diagind = this.findDiagonalIndexes(n, colind, rowptr);
        for (int k = 0; k < n; ++k) {
            int i;
            Arrays.fill(Rk, 0.0);
            for (i = rowptr[k]; i < rowptr[k + 1]; ++i) {
                Rk[colind[i]] = data[i];
            }
            for (i = 0; i < k; ++i) {
                double Rii = data[this.diagind[i]];
                if (Rii == 0.0) {
                    throw new RuntimeException("Zero pivot encountered on row " + (i + 1) + " during ICC process");
                }
                double Rki = Rk[i] / Rii;
                if (Rki == 0.0) continue;
                for (int j = this.diagind[i] + 1; j < rowptr[i + 1]; ++j) {
                    int n2 = colind[j];
                    Rk[n2] = Rk[n2] - Rki * data[j];
                }
            }
            if (Rk[k] == 0.0) {
                throw new RuntimeException("Zero diagonal entry encountered on row " + (k + 1) + " during ICC process");
            }
            double sqRkk = Math.sqrt(Rk[k]);
            for (int i2 = this.diagind[k]; i2 < rowptr[k + 1]; ++i2) {
                data[i2] = Rk[colind[i2]] / sqRkk;
            }
        }
    }

    private int[] findDiagonalIndexes(int m, int[] colind, int[] rowptr) {
        int[] diagind = new int[m];
        for (int k = 0; k < m; ++k) {
            diagind[k] = Sorting.binarySearchFromTo(colind, k, rowptr[k], rowptr[k + 1] - 1);
            if (diagind[k] >= 0) continue;
            throw new RuntimeException("Missing diagonal entry on row " + (k + 1));
        }
        return diagind;
    }

    private DoubleMatrix1D upperSolve(DoubleMatrix1D b, DoubleMatrix1D x) {
        double[] bd = ((DenseDoubleMatrix1D)b).elements();
        double[] xd = ((DenseDoubleMatrix1D)x).elements();
        int[] colind = this.R.getColumnIndexes();
        int[] rowptr = this.R.getRowPointers();
        double[] data = this.R.getValues();
        int rows = this.R.rows();
        for (int i = rows - 1; i >= 0; --i) {
            double sum = 0.0;
            for (int j = this.diagind[i] + 1; j < rowptr[i + 1]; ++j) {
                sum += data[j] * xd[colind[j]];
            }
            xd[i] = (bd[i] - sum) / data[this.diagind[i]];
        }
        return x;
    }

    private DoubleMatrix1D upperTransSolve(DoubleMatrix1D b, DoubleMatrix1D x) {
        x.assign(b);
        double[] xd = ((DenseDoubleMatrix1D)x).elements();
        int[] colind = this.R.getColumnIndexes();
        int[] rowptr = this.R.getRowPointers();
        double[] data = this.R.getValues();
        int rows = this.R.rows();
        for (int i = 0; i < rows; ++i) {
            int n = i;
            xd[n] = xd[n] / data[this.diagind[i]];
            for (int j = this.diagind[i] + 1; j < rowptr[i + 1]; ++j) {
                int n2 = colind[j];
                xd[n2] = xd[n2] - data[j] * xd[i];
            }
        }
        return x;
    }
}

