/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver;

import cern.colt.matrix.Norm;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DenseDoubleAlgebra;
import cern.colt.matrix.tdouble.algo.solver.AbstractDoubleIterativeSolver;
import cern.colt.matrix.tdouble.algo.solver.DoubleGivensRotation;
import cern.colt.matrix.tdouble.algo.solver.IterativeSolverDoubleNotConvergedException;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.jet.math.tdouble.DoubleFunctions;

public class DoubleGMRES
extends AbstractDoubleIterativeSolver {
    private int restart;
    private DoubleMatrix1D w;
    private DoubleMatrix1D u;
    private DoubleMatrix1D r;
    private DoubleMatrix1D[] v;
    private DoubleMatrix1D s;
    private DoubleMatrix2D H;
    private DoubleGivensRotation[] rotation;

    public DoubleGMRES(DoubleMatrix1D template) {
        this(template, 30);
    }

    public DoubleGMRES(DoubleMatrix1D template, int restart) {
        this.w = template.copy();
        this.u = template.copy();
        this.r = template.copy();
        this.setRestart(restart);
    }

    public void setRestart(int restart) {
        this.restart = restart;
        if (restart <= 0) {
            throw new IllegalArgumentException("restart must be a positive integer");
        }
        this.s = new DenseDoubleMatrix1D(restart + 1);
        this.H = new DenseDoubleMatrix2D(restart + 1, restart);
        this.rotation = new DoubleGivensRotation[restart + 1];
        this.v = new DoubleMatrix1D[restart + 1];
        for (int i = 0; i < this.v.length; ++i) {
            this.v[i] = new DenseDoubleMatrix1D((int)this.r.size());
        }
    }

    public DoubleMatrix1D solve(DoubleMatrix2D A, DoubleMatrix1D b, DoubleMatrix1D x) throws IterativeSolverDoubleNotConvergedException {
        this.checkSizes(A, b, x);
        A.zMult(x, this.u.assign(b), -1.0, 1.0, false);
        this.M.apply(this.u, this.r);
        double normr = DenseDoubleAlgebra.DEFAULT.norm(this.r, Norm.Two);
        this.M.apply(b, this.u);
        this.iter.setFirst();
        while (!this.iter.converged(this.r, x)) {
            int i;
            this.v[0].assign(this.r, DoubleFunctions.multSecond(1.0 / normr));
            this.s.assign(0.0).setQuick(0, normr);
            for (i = 0; i < this.restart && !this.iter.converged(Math.abs(this.s.getQuick(i))); ++i) {
                int k;
                A.zMult(this.v[i], this.u);
                this.M.apply(this.u, this.w);
                for (k = 0; k <= i; ++k) {
                    this.H.setQuick(k, i, this.w.zDotProduct(this.v[k]));
                    this.w.assign(this.v[k], DoubleFunctions.plusMultSecond(-this.H.getQuick(k, i)));
                }
                this.H.setQuick(i + 1, i, DenseDoubleAlgebra.DEFAULT.norm(this.w, Norm.Two));
                this.v[i + 1].assign(this.w, DoubleFunctions.multSecond(1.0 / this.H.getQuick(i + 1, i)));
                for (k = 0; k < i; ++k) {
                    this.rotation[k].apply(this.H, i, k, k + 1);
                }
                this.rotation[i] = new DoubleGivensRotation(this.H.getQuick(i, i), this.H.getQuick(i + 1, i));
                this.rotation[i].apply(this.H, i, i, i + 1);
                this.rotation[i].apply(this.s, i, i + 1);
                this.iter.next();
            }
            this.s = DenseDoubleAlgebra.DEFAULT.backwardSolve(this.H.viewPart(0, 0, i, i), this.s);
            for (int j = 0; j < i; ++j) {
                x.assign(this.v[j], DoubleFunctions.plusMultSecond(this.s.getQuick(j)));
            }
            A.zMult(x, this.u.assign(b), -1.0, 1.0, false);
            this.M.apply(this.u, this.r);
            normr = DenseDoubleAlgebra.DEFAULT.norm(this.r, Norm.Two);
            this.iter.next();
        }
        return x;
    }
}

