/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver;

import cern.colt.matrix.Norm;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.algo.DenseDoubleAlgebra;
import cern.colt.matrix.tdouble.algo.solver.DoubleIterationMonitor;
import cern.colt.matrix.tdouble.algo.solver.DoubleIterationReporter;
import cern.colt.matrix.tdouble.algo.solver.IterativeSolverDoubleNotConvergedException;
import cern.colt.matrix.tdouble.algo.solver.NoDoubleIterationReporter;

public abstract class AbstractDoubleIterationMonitor
implements DoubleIterationMonitor {
    protected int iter;
    protected Norm normType = Norm.Two;
    protected DoubleIterationReporter reporter = new NoDoubleIterationReporter();
    protected double residual;

    public void setFirst() {
        this.iter = 0;
    }

    public boolean isFirst() {
        return this.iter == 0;
    }

    public void next() {
        ++this.iter;
    }

    public int iterations() {
        return this.iter;
    }

    public boolean converged(DoubleMatrix1D r, DoubleMatrix1D x) throws IterativeSolverDoubleNotConvergedException {
        return this.converged(DenseDoubleAlgebra.DEFAULT.norm(r, this.normType), x);
    }

    public boolean converged(double r, DoubleMatrix1D x) throws IterativeSolverDoubleNotConvergedException {
        this.reporter.monitor(r, x, this.iter);
        this.residual = r;
        return this.convergedI(r, x);
    }

    public boolean converged(double r) throws IterativeSolverDoubleNotConvergedException {
        this.reporter.monitor(r, this.iter);
        this.residual = r;
        return this.convergedI(r);
    }

    protected abstract boolean convergedI(double var1, DoubleMatrix1D var3) throws IterativeSolverDoubleNotConvergedException;

    protected abstract boolean convergedI(double var1) throws IterativeSolverDoubleNotConvergedException;

    public boolean converged(DoubleMatrix1D r) throws IterativeSolverDoubleNotConvergedException {
        return this.converged(DenseDoubleAlgebra.DEFAULT.norm(r, this.normType));
    }

    public Norm getNormType() {
        return this.normType;
    }

    public void setNormType(Norm normType) {
        this.normType = normType;
    }

    public DoubleIterationReporter getIterationReporter() {
        return this.reporter;
    }

    public void setIterationReporter(DoubleIterationReporter monitor) {
        this.reporter = monitor;
    }

    public double residual() {
        return this.residual;
    }
}

