/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.colt.matrix.tdouble.algo.decomposition.CSparseDoubleLUDecomposition;
import cern.colt.matrix.tdouble.algo.decomposition.SparseDoubleCholeskyDecomposition;
import cern.colt.matrix.tdouble.algo.decomposition.SparseDoubleLUDecomposition;
import cern.colt.matrix.tdouble.algo.decomposition.SparseDoubleQRDecomposition;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.SparseCCDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseRCDoubleMatrix2D;
import edu.emory.mathcs.csparsej.tdouble.Dcs_common;
import edu.emory.mathcs.csparsej.tdouble.Dcs_norm;

public class SparseDoubleAlgebra {
    public static final SparseDoubleAlgebra DEFAULT = new SparseDoubleAlgebra();
    public static final SparseDoubleAlgebra ZERO;
    protected DoubleProperty property;

    private static double normInfinityRC(SparseRCDoubleMatrix2D A) {
        double norm = 0.0;
        int n = A.rows();
        int[] Ap = A.getRowPointers();
        double[] Ax = A.getValues();
        for (int j = 0; j < n; ++j) {
            double s = 0.0;
            for (int p = Ap[j]; p < Ap[j + 1]; ++p) {
                s += Math.abs(Ax[p]);
            }
            norm = Math.max(norm, s);
        }
        return norm;
    }

    public SparseDoubleAlgebra() {
        this(DoubleProperty.DEFAULT.tolerance());
    }

    public SparseDoubleAlgebra(double tolerance) {
        this.setProperty(new DoubleProperty(tolerance));
    }

    public SparseDoubleCholeskyDecomposition chol(DoubleMatrix2D matrix, int order) {
        return new SparseDoubleCholeskyDecomposition(matrix, order);
    }

    public Object clone() {
        return new SparseDoubleAlgebra(this.property.tolerance());
    }

    public double det(DoubleMatrix2D A) {
        return this.lu(A, 0).det();
    }

    public SparseDoubleLUDecomposition lu(DoubleMatrix2D matrix, int order) {
        return new CSparseDoubleLUDecomposition(matrix, order, true);
    }

    public double norm1(DoubleMatrix2D A) {
        DoubleProperty.DEFAULT.checkSparse(A);
        double norm = A instanceof SparseCCDoubleMatrix2D ? Dcs_norm.cs_norm((Dcs_common.Dcs)A.elements()) : Dcs_norm.cs_norm(((SparseRCDoubleMatrix2D)A).getColumnCompressed().elements());
        return norm;
    }

    public double normInfinity(DoubleMatrix2D A) {
        DoubleProperty.DEFAULT.checkSparse(A);
        double norm = A instanceof SparseRCDoubleMatrix2D ? SparseDoubleAlgebra.normInfinityRC((SparseRCDoubleMatrix2D)A) : SparseDoubleAlgebra.normInfinityRC(((SparseCCDoubleMatrix2D)A).getRowCompressed());
        return norm;
    }

    public DoubleProperty property() {
        return this.property;
    }

    public SparseDoubleQRDecomposition qr(DoubleMatrix2D matrix, int order) {
        return new SparseDoubleQRDecomposition(matrix, order);
    }

    public void setProperty(DoubleProperty property) {
        if (this == DEFAULT && property != this.property) {
            throw new IllegalArgumentException("Attempted to modify immutable object.");
        }
        if (this == ZERO && property != this.property) {
            throw new IllegalArgumentException("Attempted to modify immutable object.");
        }
        this.property = property;
    }

    public DoubleMatrix1D solve(DoubleMatrix2D A, DoubleMatrix1D b) {
        DenseDoubleMatrix1D x = new DenseDoubleMatrix1D(Math.max(A.rows(), A.columns()));
        x.viewPart(0, (int)b.size()).assign(b);
        if (A.rows() == A.columns()) {
            this.lu(A, 0).solve(x);
            return x;
        }
        this.qr(A, 0).solve(x);
        return x.viewPart(0, A.columns()).copy();
    }

    static {
        SparseDoubleAlgebra.DEFAULT.property = DoubleProperty.DEFAULT;
        ZERO = new SparseDoubleAlgebra();
        SparseDoubleAlgebra.ZERO.property = DoubleProperty.ZERO;
    }
}

