/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.algo.decomposition;

import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.algo.DComplexProperty;
import cern.colt.matrix.tdcomplex.impl.SparseCCDComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.SparseRCDComplexMatrix2D;
import cern.jet.math.tdcomplex.DComplexFunctions;
import edu.emory.mathcs.csparsej.tdcomplex.DZcs_common;
import edu.emory.mathcs.csparsej.tdcomplex.DZcs_dmperm;
import edu.emory.mathcs.csparsej.tdcomplex.DZcs_ipvec;
import edu.emory.mathcs.csparsej.tdcomplex.DZcs_lsolve;
import edu.emory.mathcs.csparsej.tdcomplex.DZcs_lu;
import edu.emory.mathcs.csparsej.tdcomplex.DZcs_sqr;
import edu.emory.mathcs.csparsej.tdcomplex.DZcs_usolve;

public class SparseDComplexLUDecomposition {
    private DZcs_common.DZcss S;
    private DZcs_common.DZcsn N;
    private DComplexMatrix2D L;
    private DComplexMatrix2D U;
    private boolean rcMatrix = false;
    private boolean isNonSingular = true;
    private int n;

    public SparseDComplexLUDecomposition(DComplexMatrix2D A, int order, boolean checkIfSingular) {
        DZcs_common.DZcsd D;
        DZcs_common.DZcs dcs;
        DComplexProperty.DEFAULT.checkSquare(A);
        DComplexProperty.DEFAULT.checkSparse(A);
        if (order < 0 || order > 3) {
            throw new IllegalArgumentException("order must be a number between 0 and 3");
        }
        if (A instanceof SparseRCDComplexMatrix2D) {
            this.rcMatrix = true;
            dcs = ((SparseRCDComplexMatrix2D)A).getColumnCompressed().elements();
        } else {
            dcs = (DZcs_common.DZcs)A.elements();
        }
        this.n = A.rows();
        this.S = DZcs_sqr.cs_sqr(order, dcs, false);
        if (this.S == null) {
            throw new IllegalArgumentException("Exception occured in cs_sqr()");
        }
        this.N = DZcs_lu.cs_lu(dcs, this.S, 1.0);
        if (this.N == null) {
            throw new IllegalArgumentException("Exception occured in cs_lu()");
        }
        if (checkIfSingular && (D = DZcs_dmperm.cs_dmperm(dcs, 1)) != null && D.rr[3] < this.n) {
            this.isNonSingular = false;
        }
    }

    public double[] det() {
        if (!this.isNonsingular()) {
            return new double[]{0.0, 0.0};
        }
        int pivsign = 1;
        for (int i = 0; i < this.n; ++i) {
            if (this.N.pinv[i] == i) continue;
            pivsign = -pivsign;
        }
        if (this.U == null) {
            this.U = new SparseCCDComplexMatrix2D(this.N.U);
            if (this.rcMatrix) {
                this.U = ((SparseCCDComplexMatrix2D)this.U).getRowCompressed();
            }
        }
        double[] det = new double[]{pivsign, 0.0};
        for (int j = 0; j < this.n; ++j) {
            det = DComplexFunctions.mult(det).apply(this.U.getQuick(j, j));
        }
        return det;
    }

    public DComplexMatrix2D getL() {
        if (this.L == null) {
            this.L = new SparseCCDComplexMatrix2D(this.N.L);
            if (this.rcMatrix) {
                this.L = ((SparseCCDComplexMatrix2D)this.L).getRowCompressed();
            }
        }
        return this.L.copy();
    }

    public int[] getPivot() {
        if (this.N.pinv == null) {
            return null;
        }
        int[] pinv = new int[this.N.pinv.length];
        System.arraycopy(this.N.pinv, 0, pinv, 0, pinv.length);
        return pinv;
    }

    public DComplexMatrix2D getU() {
        if (this.U == null) {
            this.U = new SparseCCDComplexMatrix2D(this.N.U);
            if (this.rcMatrix) {
                this.U = ((SparseCCDComplexMatrix2D)this.U).getRowCompressed();
            }
        }
        return this.U.copy();
    }

    public DZcs_common.DZcss getSymbolicAnalysis() {
        DZcs_common.DZcss S2 = new DZcs_common.DZcss();
        S2.cp = this.S.cp != null ? (int[])this.S.cp.clone() : null;
        S2.leftmost = this.S.leftmost != null ? (int[])this.S.leftmost.clone() : null;
        S2.lnz = this.S.lnz;
        S2.m2 = this.S.m2;
        S2.parent = this.S.parent != null ? (int[])this.S.parent.clone() : null;
        S2.pinv = this.S.pinv != null ? (int[])this.S.pinv.clone() : null;
        S2.q = this.S.q != null ? (int[])this.S.q.clone() : null;
        S2.unz = this.S.unz;
        return S2;
    }

    public boolean isNonsingular() {
        return this.isNonSingular;
    }

    public void solve(DComplexMatrix1D b) {
        if (b.size() != (long)this.n) {
            throw new IllegalArgumentException("b.size() != A.rows()");
        }
        if (!this.isNonsingular()) {
            throw new IllegalArgumentException("A is singular");
        }
        DComplexProperty.DEFAULT.checkDense(b);
        DZcs_common.DZcsa y = new DZcs_common.DZcsa(this.n);
        DZcs_common.DZcsa x = b.isView() ? new DZcs_common.DZcsa((double[])b.copy().elements()) : new DZcs_common.DZcsa((double[])b.elements());
        DZcs_ipvec.cs_ipvec(this.N.pinv, x, y, this.n);
        DZcs_lsolve.cs_lsolve(this.N.L, y);
        DZcs_usolve.cs_usolve(this.N.U, y);
        DZcs_ipvec.cs_ipvec(this.S.q, y, x, this.n);
        if (b.isView()) {
            b.assign(x.x);
        }
    }
}

