/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tbit;

import cern.colt.PersistentObject;
import cern.colt.function.tint.IntProcedure;
import cern.colt.matrix.tbit.QuickBitVector;

public class BitVector
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    protected long[] bits;
    protected int nbits;

    public BitVector(long[] bits, int size) {
        this.elements(bits, size);
    }

    public BitVector(int size) {
        this(QuickBitVector.makeBitVector(size, 1), size);
    }

    public void and(BitVector other) {
        if (this == other) {
            return;
        }
        this.checkSize(other);
        long[] theBits = this.bits;
        long[] otherBits = other.bits;
        int i = theBits.length;
        while (--i >= 0) {
            int n = i;
            theBits[n] = theBits[n] & otherBits[i];
        }
    }

    public void andNot(BitVector other) {
        this.checkSize(other);
        long[] theBits = this.bits;
        long[] otherBits = other.bits;
        int i = theBits.length;
        while (--i >= 0) {
            int n = i;
            theBits[n] = theBits[n] & (otherBits[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public int cardinality() {
        int cardinality = 0;
        int fullUnits = this.numberOfFullUnits();
        int bitsPerUnit = 64;
        long[] theBits = this.bits;
        int i = fullUnits;
        while (--i >= 0) {
            long val = theBits[i];
            if (val == -1L) {
                cardinality += 64;
                continue;
            }
            if (val == 0L) continue;
            int j = 64;
            while (--j >= 0) {
                if ((val & 1L << j) == 0L) continue;
                ++cardinality;
            }
        }
        int j = this.numberOfBitsInPartialUnit();
        while (--j >= 0) {
            if ((theBits[fullUnits] & 1L << j) == 0L) continue;
            ++cardinality;
        }
        return cardinality;
    }

    protected static void checkRangeFromTo(int from, int to, int theSize) {
        if (from < 0 || from > to || to >= theSize) {
            throw new IndexOutOfBoundsException("from: " + from + ", to: " + to + ", size=" + theSize);
        }
    }

    protected void checkSize(BitVector other) {
        if (this.nbits > other.size()) {
            throw new IllegalArgumentException("Incompatible sizes: size=" + this.nbits + ", other.size()=" + other.size());
        }
    }

    public void clear() {
        long[] theBits = this.bits;
        int i = theBits.length;
        while (--i >= 0) {
            theBits[i] = 0L;
        }
    }

    public void clear(int bitIndex) {
        if (bitIndex < 0 || bitIndex >= this.nbits) {
            throw new IndexOutOfBoundsException(String.valueOf(bitIndex));
        }
        QuickBitVector.clear(this.bits, bitIndex);
    }

    public Object clone() {
        BitVector clone = (BitVector)super.clone();
        if (this.bits != null) {
            clone.bits = (long[])this.bits.clone();
        }
        return clone;
    }

    public BitVector copy() {
        return (BitVector)this.clone();
    }

    public long[] elements() {
        return this.bits;
    }

    public void elements(long[] bits, int size) {
        if (size < 0 || size > bits.length * 64) {
            throw new IllegalArgumentException();
        }
        this.bits = bits;
        this.nbits = size;
    }

    public boolean equals(Object obj) {
        int fullUnits;
        if (obj == null || !(obj instanceof BitVector)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        BitVector other = (BitVector)obj;
        if (this.size() != other.size()) {
            return false;
        }
        int i = fullUnits = this.numberOfFullUnits();
        while (--i >= 0) {
            if (this.bits[i] == other.bits[i]) continue;
            return false;
        }
        i = fullUnits * 64;
        int times = this.numberOfBitsInPartialUnit();
        while (--times >= 0) {
            if (this.get(i) != other.get(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean forEachIndexFromToInState(int from, int to, boolean state, IntProcedure procedure) {
        int partialWidth;
        if (this.nbits == 0) {
            return true;
        }
        BitVector.checkRangeFromTo(from, to, this.nbits);
        long[] theBits = this.bits;
        int bitsPerUnit = 64;
        int fromUnit = QuickBitVector.unit(from);
        int toUnit = QuickBitVector.unit(to);
        int i = from;
        int bitIndex = QuickBitVector.offset(from);
        if (bitIndex > 0) {
            partialWidth = Math.min(to - from + 1, 64 - bitIndex);
            while (--partialWidth >= 0) {
                if (QuickBitVector.get(theBits, i) == state && !procedure.apply(i)) {
                    return false;
                }
                ++i;
            }
            ++fromUnit;
        }
        if (i > to) {
            return true;
        }
        bitIndex = QuickBitVector.offset(to);
        if (bitIndex < 63) {
            --toUnit;
            partialWidth = bitIndex + 1;
        } else {
            partialWidth = 0;
        }
        long comparator = state ? 0L : -1L;
        for (int unit = fromUnit; unit <= toUnit; ++unit) {
            long val = theBits[unit];
            if (val != comparator) {
                int k;
                int j;
                if (state) {
                    j = 0;
                    k = 64;
                    while (--k >= 0) {
                        if ((val & 1L << j++) != 0L && !procedure.apply(i)) {
                            return false;
                        }
                        ++i;
                    }
                    continue;
                }
                j = 0;
                k = 64;
                while (--k >= 0) {
                    if ((val & 1L << j++) == 0L && !procedure.apply(i)) {
                        return false;
                    }
                    ++i;
                }
                continue;
            }
            i += 64;
        }
        while (--partialWidth >= 0) {
            if (QuickBitVector.get(theBits, i) == state && !procedure.apply(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean get(int bitIndex) {
        if (bitIndex < 0 || bitIndex >= this.nbits) {
            throw new IndexOutOfBoundsException(String.valueOf(bitIndex));
        }
        return QuickBitVector.get(this.bits, bitIndex);
    }

    public long getLongFromTo(int from, int to) {
        int width = to - from + 1;
        if (width == 0) {
            return 0L;
        }
        if (from < 0 || from >= this.nbits || to < 0 || to >= this.nbits || width < 0 || width > 64) {
            throw new IndexOutOfBoundsException("from:" + from + ", to:" + to);
        }
        return QuickBitVector.getLongFromTo(this.bits, from, to);
    }

    public boolean getQuick(int bitIndex) {
        return QuickBitVector.get(this.bits, bitIndex);
    }

    public int hashCode() {
        long h = 1234L;
        int i = this.bits.length;
        while (--i >= 0) {
            h ^= this.bits[i] * (long)(i + 1);
        }
        return (int)(h >> 32 ^ h);
    }

    public int indexOfFromTo(int from, int to, boolean state) {
        IndexProcedure indexProcedure = new IndexProcedure();
        this.forEachIndexFromToInState(from, to, state, indexProcedure);
        return indexProcedure.foundPos;
    }

    public void not() {
        long[] theBits = this.bits;
        int i = theBits.length;
        while (--i >= 0) {
            theBits[i] = theBits[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    protected int numberOfBitsInPartialUnit() {
        return QuickBitVector.offset(this.nbits);
    }

    protected int numberOfFullUnits() {
        return QuickBitVector.unit(this.nbits);
    }

    public void or(BitVector other) {
        if (this == other) {
            return;
        }
        this.checkSize(other);
        long[] theBits = this.bits;
        long[] otherBits = other.bits;
        int i = theBits.length;
        while (--i >= 0) {
            int n = i;
            theBits[n] = theBits[n] | otherBits[i];
        }
    }

    public BitVector partFromTo(int from, int to) {
        if (this.nbits == 0 || to == from - 1) {
            return new BitVector(0);
        }
        BitVector.checkRangeFromTo(from, to, this.nbits);
        int width = to - from + 1;
        BitVector part = new BitVector(width);
        part.replaceFromToWith(0, width - 1, this, from);
        return part;
    }

    public void put(int bitIndex, boolean value) {
        if (bitIndex < 0 || bitIndex >= this.nbits) {
            throw new IndexOutOfBoundsException(String.valueOf(bitIndex));
        }
        if (value) {
            QuickBitVector.set(this.bits, bitIndex);
        } else {
            QuickBitVector.clear(this.bits, bitIndex);
        }
    }

    public void putLongFromTo(long value, int from, int to) {
        int width = to - from + 1;
        if (width == 0) {
            return;
        }
        if (from < 0 || from >= this.nbits || to < 0 || to >= this.nbits || width < 0 || width > 64) {
            throw new IndexOutOfBoundsException("from:" + from + ", to:" + to);
        }
        QuickBitVector.putLongFromTo(this.bits, value, from, to);
    }

    public void putQuick(int bitIndex, boolean value) {
        if (value) {
            QuickBitVector.set(this.bits, bitIndex);
        } else {
            QuickBitVector.clear(this.bits, bitIndex);
        }
    }

    public void replaceFromToWith(int from, int to, BitVector source, int sourceFrom) {
        long val;
        if (this.nbits == 0 || to == from - 1) {
            return;
        }
        BitVector.checkRangeFromTo(from, to, this.nbits);
        int length = to - from + 1;
        if (sourceFrom < 0 || sourceFrom + length > source.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (source.bits == this.bits && from <= sourceFrom && sourceFrom <= to) {
            source = source.copy();
        }
        long[] theBits = this.bits;
        long[] sourceBits = source.bits;
        int width = to - from + 1;
        int blocks = QuickBitVector.unit(width);
        int bitsPerUnit = 64;
        int bitsPerUnitMinusOne = 63;
        int i = blocks;
        while (--i >= 0) {
            val = QuickBitVector.getLongFromTo(sourceBits, sourceFrom, sourceFrom + 63);
            QuickBitVector.putLongFromTo(theBits, val, from, from + 63);
            sourceFrom += 64;
            from += 64;
        }
        int offset = QuickBitVector.offset(width);
        val = QuickBitVector.getLongFromTo(sourceBits, sourceFrom, sourceFrom + offset - 1);
        QuickBitVector.putLongFromTo(theBits, val, from, from + offset - 1);
    }

    public void replaceFromToWith(int from, int to, boolean value) {
        if (this.nbits == 0 || to == from - 1) {
            return;
        }
        BitVector.checkRangeFromTo(from, to, this.nbits);
        long[] theBits = this.bits;
        int fromUnit = QuickBitVector.unit(from);
        int fromOffset = QuickBitVector.offset(from);
        int toUnit = QuickBitVector.unit(to);
        int toOffset = QuickBitVector.offset(to);
        int bitsPerUnit = 64;
        long filler = value ? -1L : 0L;
        int bitIndex = from;
        if (fromUnit == toUnit) {
            QuickBitVector.putLongFromTo(theBits, filler, bitIndex, bitIndex + to - from);
            return;
        }
        if (fromOffset > 0) {
            QuickBitVector.putLongFromTo(theBits, filler, bitIndex, bitIndex + bitsPerUnit - fromOffset);
            bitIndex += bitsPerUnit - fromOffset + 1;
            ++fromUnit;
        }
        if (toOffset < bitsPerUnit - 1) {
            --toUnit;
        }
        int i = fromUnit;
        while (i <= toUnit) {
            theBits[i++] = filler;
        }
        if (fromUnit <= toUnit) {
            bitIndex += (toUnit - fromUnit + 1) * bitsPerUnit;
        }
        if (toOffset < bitsPerUnit - 1) {
            QuickBitVector.putLongFromTo(theBits, filler, bitIndex, to);
        }
    }

    public void set(int bitIndex) {
        if (bitIndex < 0 || bitIndex >= this.nbits) {
            throw new IndexOutOfBoundsException(String.valueOf(bitIndex));
        }
        QuickBitVector.set(this.bits, bitIndex);
    }

    public void setSize(int newSize) {
        if (newSize != this.size()) {
            BitVector newVector = new BitVector(newSize);
            newVector.replaceFromToWith(0, Math.min(this.size(), newSize) - 1, this, 0);
            this.elements(newVector.elements(), newSize);
        }
    }

    public int size() {
        return this.nbits;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.nbits);
        String separator = "";
        buffer.append('{');
        for (int i = 0; i < this.nbits; ++i) {
            if (!this.get(i)) continue;
            buffer.append(separator);
            separator = ", ";
            buffer.append(i);
        }
        buffer.append('}');
        return buffer.toString();
    }

    public void xor(BitVector other) {
        this.checkSize(other);
        long[] theBits = this.bits;
        long[] otherBits = other.bits;
        int i = theBits.length;
        while (--i >= 0) {
            int n = i;
            theBits[n] = theBits[n] ^ otherBits[i];
        }
    }

    private class IndexProcedure
    implements IntProcedure {
        private int foundPos = -1;

        private IndexProcedure() {
        }

        public boolean apply(int index) {
            this.foundPos = index;
            return false;
        }
    }
}

