/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.map.tobject;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.tint.IntComparator;
import cern.colt.function.tint.IntProcedure;
import cern.colt.function.tobject.IntObjectProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tobject.ObjectArrayList;
import cern.colt.map.AbstractMap;

public abstract class AbstractIntObjectMap
extends AbstractMap {
    private static final long serialVersionUID = 1L;

    protected AbstractIntObjectMap() {
    }

    public boolean containsKey(final int key) {
        return !this.forEachKey(new IntProcedure(){

            public boolean apply(int iterKey) {
                return key != iterKey;
            }
        });
    }

    public boolean containsValue(final Object value) {
        return !this.forEachPair(new IntObjectProcedure(){

            public boolean apply(int iterKey, Object iterValue) {
                return value != iterValue;
            }
        });
    }

    public AbstractIntObjectMap copy() {
        return (AbstractIntObjectMap)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractIntObjectMap)) {
            return false;
        }
        final AbstractIntObjectMap other = (AbstractIntObjectMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new IntObjectProcedure(){

            public boolean apply(int key, Object value) {
                return other.containsKey(key) && other.get(key) == value;
            }
        }) && other.forEachPair(new IntObjectProcedure(){

            public boolean apply(int key, Object value) {
                return AbstractIntObjectMap.this.containsKey(key) && AbstractIntObjectMap.this.get(key) == value;
            }
        });
    }

    public abstract boolean forEachKey(IntProcedure var1);

    public boolean forEachPair(final IntObjectProcedure procedure) {
        return this.forEachKey(new IntProcedure(){

            public boolean apply(int key) {
                return procedure.apply(key, AbstractIntObjectMap.this.get(key));
            }
        });
    }

    public abstract Object get(int var1);

    public int keyOf(final Object value) {
        final int[] foundKey = new int[1];
        boolean notFound = this.forEachPair(new IntObjectProcedure(){

            public boolean apply(int iterKey, Object iterValue) {
                boolean found;
                boolean bl = found = value == iterValue;
                if (found) {
                    foundKey[0] = iterKey;
                }
                return !found;
            }
        });
        if (notFound) {
            return Integer.MIN_VALUE;
        }
        return foundKey[0];
    }

    public IntArrayList keys() {
        IntArrayList list = new IntArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final IntArrayList list) {
        list.clear();
        this.forEachKey(new IntProcedure(){

            public boolean apply(int key) {
                list.add(key);
                return true;
            }
        });
    }

    public void keysSortedByValue(IntArrayList keyList) {
        this.pairsSortedByValue(keyList, new ObjectArrayList(this.size()));
    }

    public void pairsMatching(final IntObjectProcedure condition, final IntArrayList keyList, final ObjectArrayList valueList) {
        keyList.clear();
        valueList.clear();
        this.forEachPair(new IntObjectProcedure(){

            public boolean apply(int key, Object value) {
                if (condition.apply(key, value)) {
                    keyList.add(key);
                    valueList.add(value);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(IntArrayList keyList, ObjectArrayList valueList) {
        this.keys(keyList);
        keyList.sort();
        valueList.setSize(keyList.size());
        int i = keyList.size();
        while (--i >= 0) {
            valueList.setQuick(i, this.get(keyList.getQuick(i)));
        }
    }

    public void pairsSortedByValue(IntArrayList keyList, ObjectArrayList valueList) {
        this.keys(keyList);
        this.values(valueList);
        final int[] k = keyList.elements();
        final Object[] v = valueList.elements();
        Swapper swapper = new Swapper(){

            public void swap(int a, int b) {
                Object t1 = v[a];
                v[a] = v[b];
                v[b] = t1;
                int t2 = k[a];
                k[a] = k[b];
                k[b] = t2;
            }
        };
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                int ab = ((Comparable)v[a]).compareTo(v[b]);
                return ab < 0 ? -1 : (ab > 0 ? 1 : (k[a] < k[b] ? -1 : (k[a] == k[b] ? 0 : 1)));
            }
        };
        GenericSorting.quickSort(0, keyList.size(), comp, swapper);
    }

    public abstract boolean put(int var1, Object var2);

    public abstract boolean removeKey(int var1);

    public String toString() {
        IntArrayList theKeys = this.keys();
        theKeys.sort();
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            int key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public String toStringByValue() {
        IntArrayList theKeys = new IntArrayList();
        this.keysSortedByValue(theKeys);
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            int key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public ObjectArrayList values() {
        ObjectArrayList list = new ObjectArrayList(this.size());
        this.values(list);
        return list;
    }

    public void values(final ObjectArrayList list) {
        list.clear();
        this.forEachKey(new IntProcedure(){

            public boolean apply(int key) {
                list.add(AbstractIntObjectMap.this.get(key));
                return true;
            }
        });
    }
}

