/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tchar;

import cern.colt.PersistentObject;
import cern.colt.buffer.tchar.CharBuffer3DConsumer;
import cern.colt.list.tchar.CharArrayList;

public class CharBuffer3D
extends PersistentObject
implements CharBuffer3DConsumer {
    private static final long serialVersionUID = 1L;
    protected CharBuffer3DConsumer target;
    protected char[] xElements;
    protected char[] yElements;
    protected char[] zElements;
    protected CharArrayList xList;
    protected CharArrayList yList;
    protected CharArrayList zList;
    protected int capacity;
    protected int size;

    public CharBuffer3D(CharBuffer3DConsumer target, int capacity) {
        this.target = target;
        this.capacity = capacity;
        this.xElements = new char[capacity];
        this.yElements = new char[capacity];
        this.zElements = new char[capacity];
        this.xList = new CharArrayList(this.xElements);
        this.yList = new CharArrayList(this.yElements);
        this.zList = new CharArrayList(this.zElements);
        this.size = 0;
    }

    public void add(char x, char y, char z) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.xElements[this.size] = x;
        this.yElements[this.size] = y;
        this.zElements[this.size++] = z;
    }

    public void addAllOf(CharArrayList xElements, CharArrayList yElements, CharArrayList zElements) {
        int listSize = xElements.size();
        if (this.size + listSize >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(xElements, yElements, zElements);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.xList.setSize(this.size);
            this.yList.setSize(this.size);
            this.zList.setSize(this.size);
            this.target.addAllOf(this.xList, this.yList, this.zList);
            this.size = 0;
        }
    }
}

