/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tbyte;

import cern.colt.PersistentObject;
import cern.colt.buffer.tbyte.ByteBuffer2DConsumer;
import cern.colt.list.tbyte.ByteArrayList;

public class ByteBuffer2D
extends PersistentObject
implements ByteBuffer2DConsumer {
    private static final long serialVersionUID = 1L;
    protected ByteBuffer2DConsumer target;
    protected byte[] xElements;
    protected byte[] yElements;
    protected ByteArrayList xList;
    protected ByteArrayList yList;
    protected int capacity;
    protected int size;

    public ByteBuffer2D(ByteBuffer2DConsumer target, int capacity) {
        this.target = target;
        this.capacity = capacity;
        this.xElements = new byte[capacity];
        this.yElements = new byte[capacity];
        this.xList = new ByteArrayList(this.xElements);
        this.yList = new ByteArrayList(this.yElements);
        this.size = 0;
    }

    public void add(byte x, byte y) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.xElements[this.size] = x;
        this.yElements[this.size++] = y;
    }

    public void addAllOf(ByteArrayList x, ByteArrayList y) {
        int listSize = x.size();
        if (this.size + listSize >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(x, y);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.xList.setSize(this.size);
            this.yList.setSize(this.size);
            this.target.addAllOf(this.xList, this.yList);
            this.size = 0;
        }
    }
}

