/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rdf.simple.experimental;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import org.apache.commons.rdf.api.Dataset;
import org.apache.commons.rdf.api.Graph;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Quad;
import org.apache.commons.rdf.api.RDF;
import org.apache.commons.rdf.api.RDFSyntax;
import org.apache.commons.rdf.experimental.RDFParser;
import org.apache.commons.rdf.simple.SimpleRDF;
import org.apache.commons.rdf.simple.experimental.RDFParseException;

public abstract class AbstractRDFParser<T extends AbstractRDFParser<T>>
implements RDFParser,
Cloneable {
    public static final ThreadGroup threadGroup = new ThreadGroup("Commons RDF parsers");
    private static final ExecutorService threadpool = Executors.newCachedThreadPool(r -> new Thread(threadGroup, r));
    private static RDF internalRdfTermFactory = new SimpleRDF();
    private Optional<RDF> rdfTermFactory = Optional.empty();
    private Optional<RDFSyntax> contentTypeSyntax = Optional.empty();
    private Optional<String> contentType = Optional.empty();
    private Optional<IRI> base = Optional.empty();
    private Optional<InputStream> sourceInputStream = Optional.empty();
    private Optional<Path> sourceFile = Optional.empty();
    private Optional<IRI> sourceIri = Optional.empty();
    private Consumer<Quad> target;
    private Optional<Dataset> targetDataset;
    private Optional<Graph> targetGraph;

    public Optional<RDF> getRdfTermFactory() {
        return this.rdfTermFactory;
    }

    public Optional<RDFSyntax> getContentTypeSyntax() {
        return this.contentTypeSyntax;
    }

    public final Optional<String> getContentType() {
        return this.contentType;
    }

    public Consumer<Quad> getTarget() {
        return this.target;
    }

    public Optional<Dataset> getTargetDataset() {
        return this.targetDataset;
    }

    public Optional<Graph> getTargetGraph() {
        return this.targetGraph;
    }

    public Optional<IRI> getBase() {
        return this.base;
    }

    public Optional<InputStream> getSourceInputStream() {
        return this.sourceInputStream;
    }

    public Optional<Path> getSourceFile() {
        return this.sourceFile;
    }

    public Optional<IRI> getSourceIri() {
        return this.sourceIri;
    }

    public T clone() {
        try {
            return (T)((AbstractRDFParser)super.clone());
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    protected T asT() {
        return (T)this;
    }

    public T rdfTermFactory(RDF rdfTermFactory) {
        Object c = this.clone();
        ((AbstractRDFParser)c).rdfTermFactory = Optional.ofNullable(rdfTermFactory);
        return ((AbstractRDFParser)c).asT();
    }

    public T contentType(RDFSyntax rdfSyntax) throws IllegalArgumentException {
        Object c = this.clone();
        ((AbstractRDFParser)c).contentTypeSyntax = Optional.ofNullable(rdfSyntax);
        ((AbstractRDFParser)c).contentType = ((AbstractRDFParser)c).contentTypeSyntax.map(syntax -> syntax.mediaType());
        return ((AbstractRDFParser)c).asT();
    }

    public T contentType(String contentType) throws IllegalArgumentException {
        Object c = this.clone();
        ((AbstractRDFParser)c).contentType = Optional.ofNullable(contentType);
        ((AbstractRDFParser)c).contentTypeSyntax = ((AbstractRDFParser)c).contentType.flatMap(RDFSyntax::byMediaType);
        return ((AbstractRDFParser)c).asT();
    }

    public T base(IRI base) {
        Object c = this.clone();
        ((AbstractRDFParser)c).base = Optional.ofNullable(base);
        ((AbstractRDFParser)c).base.ifPresent(i -> this.checkIsAbsolute((IRI)i));
        return ((AbstractRDFParser)c).asT();
    }

    public T base(String base) throws IllegalArgumentException {
        return (T)this.base(internalRdfTermFactory.createIRI(base));
    }

    public T source(InputStream inputStream) {
        Object c = this.clone();
        ((AbstractRDFParser)c).resetSource();
        ((AbstractRDFParser)c).sourceInputStream = Optional.ofNullable(inputStream);
        return ((AbstractRDFParser)c).asT();
    }

    public T source(Path file) {
        Object c = this.clone();
        ((AbstractRDFParser)c).resetSource();
        ((AbstractRDFParser)c).sourceFile = Optional.ofNullable(file);
        return ((AbstractRDFParser)c).asT();
    }

    public T source(IRI iri) {
        Object c = this.clone();
        ((AbstractRDFParser)c).resetSource();
        ((AbstractRDFParser)c).sourceIri = Optional.ofNullable(iri);
        ((AbstractRDFParser)c).sourceIri.ifPresent(i -> this.checkIsAbsolute((IRI)i));
        return ((AbstractRDFParser)c).asT();
    }

    public T source(String iri) throws IllegalArgumentException {
        Object c = this.clone();
        ((AbstractRDFParser)c).resetSource();
        ((AbstractRDFParser)c).sourceIri = Optional.ofNullable(iri).map(arg_0 -> ((RDF)internalRdfTermFactory).createIRI(arg_0));
        ((AbstractRDFParser)c).sourceIri.ifPresent(i -> this.checkIsAbsolute((IRI)i));
        return (T)this.source(internalRdfTermFactory.createIRI(iri));
    }

    protected void checkIsAbsolute(IRI iri) throws IllegalArgumentException {
        if (!URI.create(iri.getIRIString()).isAbsolute()) {
            throw new IllegalArgumentException("IRI is not absolute: " + iri);
        }
    }

    protected void checkSource() throws IOException {
        if (!(this.sourceFile.isPresent() || this.sourceInputStream.isPresent() || this.sourceIri.isPresent())) {
            throw new IllegalStateException("No source has been set");
        }
        if (this.sourceIri.isPresent() && this.sourceInputStream.isPresent()) {
            throw new IllegalStateException("Both sourceIri and sourceInputStream have been set");
        }
        if (this.sourceIri.isPresent() && this.sourceFile.isPresent()) {
            throw new IllegalStateException("Both sourceIri and sourceFile have been set");
        }
        if (this.sourceInputStream.isPresent() && this.sourceFile.isPresent()) {
            throw new IllegalStateException("Both sourceInputStream and sourceFile have been set");
        }
        if (this.sourceFile.isPresent() && !this.sourceFile.filter(Files::isReadable).isPresent()) {
            throw new IOException("Can't read file: " + this.sourceFile);
        }
    }

    protected void checkBaseRequired() throws IllegalStateException {
        if (!this.base.isPresent() && this.sourceInputStream.isPresent() && !this.contentTypeSyntax.filter(t -> t == RDFSyntax.NQUADS || t == RDFSyntax.NTRIPLES).isPresent()) {
            throw new IllegalStateException("base iri required for inputstream source");
        }
    }

    protected void resetSource() {
        this.sourceInputStream = Optional.empty();
        this.sourceIri = Optional.empty();
        this.sourceFile = Optional.empty();
    }

    protected void resetTarget() {
        this.targetDataset = Optional.empty();
        this.targetGraph = Optional.empty();
    }

    protected abstract void parseSynchronusly() throws IOException, RDFParseException;

    protected T prepareForParsing() throws IOException, IllegalStateException {
        this.checkSource();
        this.checkBaseRequired();
        this.checkContentType();
        this.checkTarget();
        Object c = this.clone();
        if (!((AbstractRDFParser)c).rdfTermFactory.isPresent()) {
            ((AbstractRDFParser)c).rdfTermFactory = Optional.of(this.createRDFTermFactory());
        }
        if (((AbstractRDFParser)c).sourceFile.isPresent() && !((AbstractRDFParser)c).base.isPresent()) {
            URI baseUri = ((AbstractRDFParser)c).sourceFile.get().toRealPath(new LinkOption[0]).toUri();
            ((AbstractRDFParser)c).base = Optional.of(internalRdfTermFactory.createIRI(baseUri.toString()));
        }
        return ((AbstractRDFParser)c).asT();
    }

    protected void checkTarget() {
        if (this.target == null) {
            throw new IllegalStateException("target has not been set");
        }
        if (this.targetGraph.isPresent() && this.targetDataset.isPresent()) {
            throw new IllegalStateException("targetGraph and targetDataset can't both be set");
        }
    }

    protected void checkContentType() throws IllegalStateException {
    }

    protected static Optional<RDFSyntax> guessRDFSyntax(Path path) {
        return AbstractRDFParser.fileExtension(path).flatMap(RDFSyntax::byFileExtension);
    }

    private static Optional<String> fileExtension(Path path) {
        Path fileName = path.getFileName();
        if (fileName == null) {
            return Optional.empty();
        }
        String filenameStr = fileName.toString();
        int last = filenameStr.lastIndexOf(".");
        if (last > -1) {
            return Optional.of(filenameStr.substring(last));
        }
        return Optional.empty();
    }

    protected RDF createRDFTermFactory() {
        return new SimpleRDF();
    }

    public Future<RDFParser.ParseResult> parse() throws IOException, IllegalStateException {
        Object c = this.prepareForParsing();
        return threadpool.submit(() -> {
            c.parseSynchronusly();
            return null;
        });
    }

    public T target(Consumer<Quad> consumer) {
        Object c = this.clone();
        ((AbstractRDFParser)c).resetTarget();
        ((AbstractRDFParser)c).target = consumer;
        return ((AbstractRDFParser)c).asT();
    }

    public T target(Dataset dataset) {
        AbstractRDFParser c = (AbstractRDFParser)super.target(dataset);
        c.resetTarget();
        c.targetDataset = Optional.of(dataset);
        return c.asT();
    }

    public T target(Graph graph) {
        AbstractRDFParser c = (AbstractRDFParser)super.target(graph);
        c.resetTarget();
        c.targetGraph = Optional.of(graph);
        return c.asT();
    }
}

