/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rdf.simple;

import java.util.Objects;
import java.util.Optional;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Quad;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.api.Triple;
import org.apache.commons.rdf.simple.TripleImpl;

final class QuadImpl
implements Quad {
    private final BlankNodeOrIRI graphName;
    private final BlankNodeOrIRI subject;
    private final IRI predicate;
    private final RDFTerm object;

    public QuadImpl(BlankNodeOrIRI graphName, BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        this.graphName = graphName;
        this.subject = Objects.requireNonNull(subject);
        this.predicate = Objects.requireNonNull(predicate);
        this.object = Objects.requireNonNull(object);
    }

    public Optional<BlankNodeOrIRI> getGraphName() {
        return Optional.ofNullable(this.graphName);
    }

    public BlankNodeOrIRI getSubject() {
        return this.subject;
    }

    public IRI getPredicate() {
        return this.predicate;
    }

    public RDFTerm getObject() {
        return this.object;
    }

    public String toString() {
        return this.getSubject().ntriplesString() + " " + this.getPredicate().ntriplesString() + " " + this.getObject().ntriplesString() + " " + this.getGraphName().map(g -> g.ntriplesString() + " ").orElse("") + ".";
    }

    public int hashCode() {
        return Objects.hash(this.subject, this.predicate, this.object, this.graphName);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Quad)) {
            return false;
        }
        Quad other = (Quad)obj;
        return this.getGraphName().equals(other.getGraphName()) && this.getSubject().equals(other.getSubject()) && this.getPredicate().equals((Object)other.getPredicate()) && this.getObject().equals((Object)other.getObject());
    }

    public Triple asTriple() {
        return new TripleImpl(this.getSubject(), this.getPredicate(), this.getObject());
    }
}

