/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rdf.simple;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.BlankNode;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.Graph;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Literal;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.api.Triple;
import org.apache.commons.rdf.simple.SimpleRDF;

final class GraphImpl
implements Graph {
    private static final int TO_STRING_MAX = 10;
    private final Set<Triple> triples = new HashSet<Triple>();
    private final SimpleRDF factory;

    GraphImpl(SimpleRDF simpleRDF) {
        this.factory = simpleRDF;
    }

    public void add(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        BlankNodeOrIRI newSubject = (BlankNodeOrIRI)this.internallyMap(subject);
        IRI newPredicate = (IRI)this.internallyMap(predicate);
        RDFTerm newObject = this.internallyMap(object);
        Triple result = this.factory.createTriple(newSubject, newPredicate, newObject);
        this.triples.add(result);
    }

    public void add(Triple triple) {
        this.triples.add(this.internallyMap(triple));
    }

    private <T extends RDFTerm> RDFTerm internallyMap(T object) {
        if (object == null || object instanceof SimpleRDF.SimpleRDFTerm) {
            return object;
        }
        if (object instanceof BlankNode) {
            BlankNode blankNode = (BlankNode)object;
            return this.factory.createBlankNode(blankNode.uniqueReference());
        }
        if (object instanceof IRI) {
            IRI iri = (IRI)object;
            return this.factory.createIRI(iri.getIRIString());
        }
        if (object instanceof Literal) {
            Literal literal = (Literal)object;
            if (literal.getLanguageTag().isPresent()) {
                return this.factory.createLiteral(literal.getLexicalForm(), (String)literal.getLanguageTag().get());
            }
            return this.factory.createLiteral(literal.getLexicalForm(), (IRI)this.internallyMap(literal.getDatatype()));
        }
        throw new IllegalArgumentException("RDFTerm was neither a BlankNode, IRI nor Literal: " + object);
    }

    private Triple internallyMap(Triple triple) {
        BlankNodeOrIRI newSubject = (BlankNodeOrIRI)this.internallyMap(triple.getSubject());
        IRI newPredicate = (IRI)this.internallyMap(triple.getPredicate());
        RDFTerm newObject = this.internallyMap(triple.getObject());
        if (newSubject == triple.getSubject() && newPredicate == triple.getPredicate() && newObject == triple.getObject()) {
            return triple;
        }
        return this.factory.createTriple(newSubject, newPredicate, newObject);
    }

    public void clear() {
        this.triples.clear();
    }

    public boolean contains(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        return this.stream(subject, predicate, object).findFirst().isPresent();
    }

    public boolean contains(Triple triple) {
        return this.triples.contains(this.internallyMap(triple));
    }

    public Stream<Triple> stream() {
        return (Stream)this.triples.parallelStream().unordered();
    }

    public Stream<Triple> stream(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        BlankNodeOrIRI newSubject = (BlankNodeOrIRI)this.internallyMap(subject);
        IRI newPredicate = (IRI)this.internallyMap(predicate);
        RDFTerm newObject = this.internallyMap(object);
        return this.getTriples(t -> {
            if (subject != null && !t.getSubject().equals(newSubject)) {
                return false;
            }
            if (predicate != null && !t.getPredicate().equals((Object)newPredicate)) {
                return false;
            }
            return object == null || t.getObject().equals((Object)newObject);
        });
    }

    private Stream<Triple> getTriples(Predicate<Triple> filter) {
        return this.stream().filter(filter);
    }

    public void remove(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        Stream<Triple> toRemove = this.stream(subject, predicate, object);
        for (Triple t : toRemove.collect(Collectors.toList())) {
            this.remove(t);
        }
    }

    public void remove(Triple triple) {
        this.triples.remove(this.internallyMap(triple));
    }

    public long size() {
        return this.triples.size();
    }

    public String toString() {
        String s = this.stream().limit(10L).map(Object::toString).collect(Collectors.joining("\n"));
        if (this.size() > 10L) {
            return s + "\n# ... +" + (this.size() - 10L) + " more";
        }
        return s;
    }
}

