/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rdf.simple;

import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.BlankNode;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.Dataset;
import org.apache.commons.rdf.api.Graph;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Literal;
import org.apache.commons.rdf.api.Quad;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.simple.BlankNodeImpl;
import org.apache.commons.rdf.simple.DatasetGraphView;
import org.apache.commons.rdf.simple.IRIImpl;
import org.apache.commons.rdf.simple.LiteralImpl;
import org.apache.commons.rdf.simple.SimpleRDF;

final class DatasetImpl
implements Dataset {
    private static final int TO_STRING_MAX = 10;
    private final Set<Quad> quads = new HashSet<Quad>();
    private final SimpleRDF factory;

    DatasetImpl(SimpleRDF simpleRDF) {
        this.factory = simpleRDF;
    }

    public void add(BlankNodeOrIRI graphName, BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        BlankNodeOrIRI newGraphName = (BlankNodeOrIRI)this.internallyMap(graphName);
        BlankNodeOrIRI newSubject = (BlankNodeOrIRI)this.internallyMap(subject);
        IRI newPredicate = (IRI)this.internallyMap(predicate);
        RDFTerm newObject = this.internallyMap(object);
        Quad result = this.factory.createQuad(newGraphName, newSubject, newPredicate, newObject);
        this.quads.add(result);
    }

    public void add(Quad quad) {
        BlankNodeOrIRI newGraph = (BlankNodeOrIRI)this.internallyMap(quad.getGraphName().orElse(null));
        BlankNodeOrIRI newSubject = (BlankNodeOrIRI)this.internallyMap(quad.getSubject());
        IRI newPredicate = (IRI)this.internallyMap(quad.getPredicate());
        RDFTerm newObject = this.internallyMap(quad.getObject());
        if (newGraph == quad.getGraphName().orElse(null) && newSubject == quad.getSubject() && newPredicate == quad.getPredicate() && newObject == quad.getObject()) {
            this.quads.add(quad);
        } else {
            Quad result = this.factory.createQuad(newGraph, newSubject, newPredicate, newObject);
            this.quads.add(result);
        }
    }

    private <T extends RDFTerm> RDFTerm internallyMap(T object) {
        if (object == null || object instanceof SimpleRDF.SimpleRDFTerm) {
            return object;
        }
        if (object instanceof BlankNode && !(object instanceof BlankNodeImpl)) {
            BlankNode blankNode = (BlankNode)object;
            return this.factory.createBlankNode(blankNode.uniqueReference());
        }
        if (object instanceof IRI && !(object instanceof IRIImpl)) {
            IRI iri = (IRI)object;
            return this.factory.createIRI(iri.getIRIString());
        }
        if (object instanceof Literal && !(object instanceof LiteralImpl)) {
            Literal literal = (Literal)object;
            if (literal.getLanguageTag().isPresent()) {
                return this.factory.createLiteral(literal.getLexicalForm(), (String)literal.getLanguageTag().get());
            }
            return this.factory.createLiteral(literal.getLexicalForm(), (IRI)this.internallyMap(literal.getDatatype()));
        }
        throw new IllegalArgumentException("Not a BlankNode, IRI or Literal: " + object);
    }

    public void clear() {
        this.quads.clear();
    }

    public boolean contains(Optional<BlankNodeOrIRI> graphName, BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        return this.stream(graphName, subject, predicate, object).findAny().isPresent();
    }

    public boolean contains(Quad quad) {
        return this.quads.contains(Objects.requireNonNull(quad));
    }

    public Stream<Quad> stream() {
        return (Stream)this.quads.parallelStream().unordered();
    }

    public Stream<Quad> stream(Optional<BlankNodeOrIRI> graphName, BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        Optional<BlankNodeOrIRI> newGraphName = graphName == null ? null : graphName.map(g -> (BlankNodeOrIRI)this.internallyMap(g));
        BlankNodeOrIRI newSubject = (BlankNodeOrIRI)this.internallyMap(subject);
        IRI newPredicate = (IRI)this.internallyMap(predicate);
        RDFTerm newObject = this.internallyMap(object);
        return this.getQuads(t -> {
            if (newGraphName != null && !t.getGraphName().equals(newGraphName)) {
                return false;
            }
            if (subject != null && !t.getSubject().equals(newSubject)) {
                return false;
            }
            if (predicate != null && !t.getPredicate().equals((Object)newPredicate)) {
                return false;
            }
            return object == null || t.getObject().equals((Object)newObject);
        });
    }

    private Stream<Quad> getQuads(Predicate<Quad> filter) {
        return this.stream().filter(filter);
    }

    public void remove(Optional<BlankNodeOrIRI> graphName, BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        Stream<Quad> toRemove = this.stream(graphName, subject, predicate, object);
        for (Quad t : toRemove.collect(Collectors.toList())) {
            this.remove(t);
        }
    }

    public void remove(Quad quad) {
        this.quads.remove(Objects.requireNonNull(quad));
    }

    public long size() {
        return this.quads.size();
    }

    public String toString() {
        String s = this.stream().limit(10L).map(Object::toString).collect(Collectors.joining("\n"));
        if (this.size() > 10L) {
            return s + "\n# ... +" + (this.size() - 10L) + " more";
        }
        return s;
    }

    public void close() {
    }

    public Graph getGraph() {
        return this.getGraph(null).get();
    }

    public Optional<Graph> getGraph(BlankNodeOrIRI graphName) {
        return Optional.of(new DatasetGraphView(this, graphName));
    }

    public Stream<BlankNodeOrIRI> getGraphNames() {
        return this.stream().map(Quad::getGraphName).filter(Optional::isPresent).map(Optional::get).distinct();
    }
}

