/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rdf.simple;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.rdf.api.BlankNode;
import org.apache.commons.rdf.simple.SimpleRDF;

final class BlankNodeImpl
implements BlankNode,
SimpleRDF.SimpleRDFTerm {
    private static final UUID SALT = UUID.randomUUID();
    private static final AtomicLong COUNTER = new AtomicLong();
    private final String uniqueReference;

    public BlankNodeImpl() {
        this(SALT, Long.toString(COUNTER.incrementAndGet()));
    }

    public BlankNodeImpl(UUID uuidSalt, String name) {
        if (Objects.requireNonNull(name).isEmpty()) {
            throw new IllegalArgumentException("Invalid blank node id: " + name);
        }
        String uuidInput = "urn:uuid:" + uuidSalt + "#" + name;
        this.uniqueReference = UUID.nameUUIDFromBytes(uuidInput.getBytes(StandardCharsets.UTF_8)).toString();
    }

    public String uniqueReference() {
        return this.uniqueReference;
    }

    public String ntriplesString() {
        return "_:" + this.uniqueReference;
    }

    public String toString() {
        return this.ntriplesString();
    }

    public int hashCode() {
        return this.uniqueReference.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlankNodeImpl)) {
            return false;
        }
        BlankNodeImpl other = (BlankNodeImpl)obj;
        return !(this.uniqueReference == null ? other.uniqueReference != null : !this.uniqueReference.equals(other.uniqueReference));
    }
}

