/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.cloud.google;

import com.google.api.client.http.AbstractHttpContent;
import com.google.api.client.http.HttpMediaType;
import com.google.api.client.util.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MultipartCompleteXMLContent
extends AbstractHttpContent {
    private final Map<Integer, String> partsMap;

    public MultipartCompleteXMLContent setMediaType(HttpMediaType mediaType) {
        super.setMediaType(mediaType);
        return this;
    }

    public MultipartCompleteXMLContent(Map<Integer, String> partsMap) {
        super(new HttpMediaType("application/xml"));
        this.partsMap = (Map)Preconditions.checkNotNull(partsMap);
    }

    public void writeTo(OutputStream out) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out, this.getCharset());
        List sorted = this.partsMap.keySet().stream().sorted().collect(Collectors.toList());
        writer.write("<CompleteMultipartUpload>");
        Iterator iterator = sorted.iterator();
        while (iterator.hasNext()) {
            int part = (Integer)iterator.next();
            writer.write("<Part>");
            writer.write("<PartNumber>" + part + "</PartNumber>");
            writer.write("<ETag>\"" + this.partsMap.get(part) + "\"</ETag>");
            writer.write("</Part>");
        }
        writer.write("</CompleteMultipartUpload>");
        ((Writer)writer).flush();
    }
}

