/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.cloud.google;

import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.EmptyContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.ontotext.graphdb.cloud.CloudMultipartUploader;
import com.ontotext.graphdb.cloud.google.GCPartUpload;
import com.ontotext.graphdb.cloud.google.GoogleBucketOptions;
import com.ontotext.graphdb.cloud.google.GoogleUtils;
import com.ontotext.graphdb.cloud.google.MultipartCompleteXMLContent;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCMultipartUploader
implements CloudMultipartUploader {
    private static final Logger logger = LoggerFactory.getLogger(GCMultipartUploader.class);
    private final String bucket;
    private final String fileKey;
    private String uploadId;
    private final Map<Integer, String> partsMap = Collections.synchronizedMap(new HashMap());
    private int partNumber;
    private final ExecutorService executorService;
    private final AtomicReference<IOException> uploadException = new AtomicReference();
    private final HttpRequestFactory requestFactory;

    public GCMultipartUploader(GoogleBucketOptions bucketOptions) {
        this.bucket = bucketOptions.getBucketName();
        this.fileKey = bucketOptions.getFileKey();
        this.partNumber = 0;
        int threadPoolSize = GoogleUtils.getAllowedConcurrentUploads();
        try {
            NetHttpTransport httpTransport = GoogleNetHttpTransport.newTrustedTransport();
            this.requestFactory = httpTransport.createRequestFactory((HttpRequestInitializer)new HttpCredentialsAdapter((Credentials)bucketOptions.acquireGoogleCredentials()));
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        this.executorService = new ThreadPoolExecutor(threadPoolSize, threadPoolSize, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(threadPoolSize), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    @Override
    public GCMultipartUploader start() throws IOException {
        this.validateCleanStart();
        GenericUrl url = new GenericUrl(GoogleUtils.getStorageDomain() + URLEncoder.encode(this.bucket, StandardCharsets.UTF_8) + "/" + this.fileKey + "?uploads");
        HttpRequest startMultipartRequest = this.requestFactory.buildPostRequest(url, (HttpContent)new EmptyContent());
        HttpResponse response = startMultipartRequest.execute();
        if (!response.isSuccessStatusCode()) {
            throw new IOException(response.getStatusMessage());
        }
        String content = response.parseAsString();
        this.uploadId = content.substring(content.indexOf("<UploadId>") + 10, content.indexOf("</UploadId>"));
        return this;
    }

    private void validateCleanStart() throws IOException {
        if (Objects.isNull(this.uploadId) && this.partsMap.isEmpty()) {
            return;
        }
        throw new IOException("Unable to start multipart backup upload, uploader has a previous upload id");
    }

    @Override
    public void partUpload(byte[] chunk) throws IOException {
        if (this.uploadException.get() != null) {
            throw this.uploadException.get();
        }
        this.executorService.execute(new GCPartUpload(this.requestFactory, ++this.partNumber, this.partsMap, this.bucket, this.fileKey, this.uploadId, chunk, this.uploadException));
    }

    @Override
    public void complete(byte[] chunk) throws IOException {
        logger.info("Completing upload to Google Cloud Storage");
        if (chunk.length > 0) {
            this.partUpload(chunk);
        }
        try {
            this.executorService.shutdown();
            if (!this.executorService.awaitTermination(GoogleUtils.getClientWriteTimeout(), TimeUnit.SECONDS)) {
                throw new IOException("Part upload timeout");
            }
            if (this.uploadException.get() != null) {
                throw this.uploadException.get();
            }
            GenericUrl url = new GenericUrl(GoogleUtils.getStorageDomain() + URLEncoder.encode(this.bucket, StandardCharsets.UTF_8) + "/" + this.fileKey + "?uploadId=" + this.uploadId);
            HttpRequest completeMultipartRequest = this.requestFactory.buildPostRequest(url, (HttpContent)new MultipartCompleteXMLContent(this.partsMap));
            HttpResponse response = completeMultipartRequest.execute();
            if (!response.isSuccessStatusCode()) {
                throw new IOException(response.getStatusMessage());
            }
            logger.info("Backup multipart upload completed successfully");
        }
        catch (Exception e) {
            throw new IOException("Failed to complete google cloud multipart upload", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        try {
            GenericUrl url = new GenericUrl(GoogleUtils.getStorageDomain() + URLEncoder.encode(this.bucket, StandardCharsets.UTF_8) + "/" + this.fileKey + "?uploadId=" + this.uploadId);
            HttpRequest abortUploadRequest = this.requestFactory.buildDeleteRequest(url);
            HttpResponse response = abortUploadRequest.execute();
            if (!response.isSuccessStatusCode()) {
                throw new IOException(response.getStatusMessage());
            }
        }
        catch (IOException e) {
            logger.error("Backup multipart upload failed to abort. uploaded parts might need a manual clean up: {}", (Object)e.getMessage());
        }
        finally {
            this.executorService.shutdownNow();
        }
        logger.error("Backup multipart upload aborted");
    }
}

