/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.cloud.azure;

import com.azure.core.credential.AzureSasCredential;
import com.azure.identity.DefaultAzureCredential;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.ontotext.graphdb.cloud.CloudUtils;
import java.net.URI;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import software.amazon.awssdk.utils.StringUtils;

public class AzureBlobOptions {
    private static final String AZURE_STORAGE_ACCOUNT = "blob_storage_account";
    private static final String AZURE_ACCESS_KEY = "blob_access_key";
    private final String sasSignature;
    private final String rawQuery;
    @NotNull
    private final String storageAccount;
    private final String accessKey;
    @NotNull
    private final String containerName;
    @NotNull
    private final String fileKey;

    public AzureBlobOptions(URI bucketUrl) {
        this.containerName = bucketUrl.getHost();
        if (StringUtils.isEmpty((CharSequence)this.containerName)) {
            throw new IllegalArgumentException("Container name cannot be empty");
        }
        String filePath = bucketUrl.getPath();
        if (StringUtils.isEmpty((CharSequence)filePath) || filePath.equals("/")) {
            throw new IllegalArgumentException("Backup name cannot be empty");
        }
        this.fileKey = bucketUrl.getPath().substring(1);
        this.rawQuery = bucketUrl.getRawQuery();
        Map<String, String> queryParams = CloudUtils.getQueryMap(this.rawQuery);
        this.storageAccount = queryParams.get(AZURE_STORAGE_ACCOUNT);
        if (StringUtils.isEmpty((CharSequence)this.storageAccount)) {
            throw new IllegalArgumentException("Storage account cannot be empty");
        }
        if (this.storageAccount.contains("?")) {
            throw new IllegalArgumentException("Invalid storage account: {}" + this.storageAccount);
        }
        this.accessKey = queryParams.get(AZURE_ACCESS_KEY);
        this.sasSignature = queryParams.get("sig");
    }

    public AzureBlobOptions(@NotNull String storageAccount, String accessKeyId, @NotNull String containerName, @NotNull String fileKey, String sasSignature, String rawQuery) {
        this.storageAccount = storageAccount;
        this.accessKey = accessKeyId;
        this.sasSignature = sasSignature;
        this.rawQuery = rawQuery;
        this.containerName = containerName;
        this.fileKey = fileKey;
    }

    @NotNull
    public String getStorageAccount() {
        return this.storageAccount;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSasSignature() {
        return this.sasSignature;
    }

    public String getRawQuery() {
        return this.rawQuery;
    }

    @NotNull
    public String getContainerName() {
        return this.containerName;
    }

    @NotNull
    public String getFileKey() {
        return this.fileKey;
    }

    public StorageSharedKeyCredential getSharedKeyCredentials() {
        if (StringUtils.isEmpty((CharSequence)this.accessKey)) {
            return null;
        }
        return new StorageSharedKeyCredential(this.storageAccount, this.accessKey);
    }

    public AzureSasCredential getAzureSasCredential() {
        if (StringUtils.isEmpty((CharSequence)this.sasSignature)) {
            return null;
        }
        return new AzureSasCredential(this.rawQuery);
    }

    public DefaultAzureCredential getIdentityCredentials() {
        return new DefaultAzureCredentialBuilder().build();
    }
}

