/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.cloud.aws;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.ontotext.graphdb.cloud.CloudMultipartDownloader;
import com.ontotext.graphdb.cloud.aws.S3BucketOptions;
import com.ontotext.graphdb.cloud.aws.S3ChunkDownload;
import com.ontotext.graphdb.cloud.aws.S3Utils;
import com.ontotext.license.LicenseRegistry;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.s3.S3AsyncClient;

public class S3MultipartDownloader
extends CloudMultipartDownloader {
    private static final Logger logger = LoggerFactory.getLogger(S3MultipartDownloader.class);
    private final int chunksToDownload;
    private final long downloadFileSize;
    private final S3AsyncClient s3Client;
    private final S3BucketOptions s3BucketOptions;

    public S3MultipartDownloader(S3AsyncClient s3Client, S3BucketOptions s3BucketOptions) throws IOException, GeneralSecurityException, ExecutionException, InterruptedException {
        this.s3Client = s3Client;
        this.s3BucketOptions = s3BucketOptions;
        this.downloadFileSize = S3Utils.getS3FileSize(s3Client, s3BucketOptions);
        this.chunksToDownload = (int)Math.ceil((double)this.downloadFileSize / (double)S3Utils.getMinimumPartSize());
    }

    @Override
    protected ExecutorService initDownloadingExecutor() {
        int threadCount = LicenseRegistry.getInstance().getLicensedCores(CONFIGURED_THREAD_COUNT);
        if (threadCount < 4) {
            threadCount = 1;
        }
        logger.info("Using {} threads to download a backup from S3 bucket", (Object)threadCount);
        ExecutorService executor = Executors.newFixedThreadPool(threadCount, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("s3-download-thread-%d").build());
        for (int i = 0; i < this.chunksToDownload; ++i) {
            long chunkStart = this.chunkCounter == 0 ? 0L : (long)this.chunkCounter * (long)S3Utils.getMinimumPartSize();
            long chunkEnd = Math.min(chunkStart + (long)S3Utils.getMinimumPartSize() - 1L, this.downloadFileSize - 1L);
            if (chunkStart > this.downloadFileSize) break;
            executor.execute(new S3ChunkDownload(this.pipedStreamsManager, this.lastChunk, ++this.chunkCounter, chunkStart, chunkEnd, this.s3BucketOptions.getBucketName(), this.s3BucketOptions.getFileKey(), this.s3Client, this.downloadError, this.closed, this.chunksToDownload));
        }
        return executor;
    }
}

