/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.cloud.aws;

import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.cloud.CloudUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.utils.StringUtils;

public class S3BucketOptions {
    private static final String AWS_SECRET_ACCESS_KEY = "aws_secret_access_key";
    private static final String AWS_ACCESS_KEY_ID = "aws_access_key_id";
    private final String accessKey;
    private final String accessKeyId;
    private final String region;
    @NotNull
    private final String bucketName;
    private final String fileKey;
    private final String host;

    public S3BucketOptions(URI bucketUrl) {
        Map<String, String> queryParams = CloudUtils.getQueryMap(bucketUrl.getQuery());
        this.accessKey = queryParams.get(AWS_SECRET_ACCESS_KEY);
        this.accessKeyId = queryParams.get(AWS_ACCESS_KEY_ID);
        this.region = queryParams.get("region");
        String filePath = bucketUrl.getPath();
        int endOfBucket = filePath.indexOf("/", 1);
        if (endOfBucket == -1) {
            this.bucketName = filePath.substring(1);
            this.fileKey = "";
        } else {
            this.bucketName = filePath.substring(1, endOfBucket);
            this.fileKey = filePath.substring(endOfBucket + 1);
        }
        try {
            bucketUrl.parseServerAuthority();
            this.host = bucketUrl.getAuthority();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("Invalid provided host: %s", bucketUrl.getAuthority()));
        }
    }

    public S3BucketOptions(String accessKey, String accessKeyId, String region, @NotNull String bucketName, String fileKey, String host) {
        this.accessKey = accessKey;
        this.accessKeyId = accessKeyId;
        this.region = region;
        this.bucketName = bucketName;
        this.fileKey = fileKey;
        this.host = host;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public String getRegion() {
        return this.region;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getFileKey() {
        return this.fileKey;
    }

    public String getHost() {
        return this.host;
    }

    public URI getHostAsUri() {
        try {
            return StringUtils.isNotBlank((CharSequence)this.host) ? new URI(Config.getPropertyAsBoolean((String)"graphdb.s3.tls.enabled", (boolean)false) ? "https" : "http", this.host, null, null, null) : null;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public AwsCredentialsProvider acquireCredentialProvider() {
        if (StringUtils.isNotBlank((CharSequence)this.accessKey) && StringUtils.isNotBlank((CharSequence)this.accessKeyId)) {
            return StaticCredentialsProvider.create((AwsCredentials)this.getBucketCredentials());
        }
        return DefaultCredentialsProvider.builder().build();
    }

    private AwsBasicCredentials getBucketCredentials() {
        return AwsBasicCredentials.create((String)this.accessKeyId, (String)this.accessKey);
    }
}

