/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.cloud;

import com.ontotext.graphdb.cloud.CloudMultipartUploader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

public class CloudOutputStream
extends OutputStream {
    private final ByteArrayOutputStream outputStream;
    private final int partSize;
    private final CloudMultipartUploader uploader;
    private boolean closed;
    private boolean finishedUpload;

    public CloudOutputStream(CloudMultipartUploader multipartUploader, long partSize) throws IOException {
        this.uploader = multipartUploader;
        this.partSize = (int)partSize;
        this.outputStream = new ByteArrayOutputStream();
        this.uploader.start();
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.outputStream.write(b);
        if (this.outputStream.size() >= this.partSize) {
            this.flushToUploader();
        }
    }

    @Override
    public synchronized void write(@NotNull byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public synchronized void write(@NotNull byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int freeSpace = this.partSize - this.outputStream.size();
            if (freeSpace < 1) {
                this.flushToUploader();
                freeSpace = this.partSize;
            }
            int writable = Math.min(freeSpace, len);
            this.outputStream.write(b, off, writable);
            off += writable;
            len -= writable;
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.outputStream.size() > 0) {
            this.flushToUploader();
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (!this.finishedUpload) {
                this.uploader.complete(this.outputStream.toByteArray());
            }
        }
        catch (IOException e) {
            this.uploader.abort();
            throw e;
        }
        finally {
            this.finishedUpload = true;
            if (!this.closed) {
                this.outputStream.close();
                this.closed = true;
            }
        }
    }

    private void flushToUploader() throws IOException {
        this.uploader.partUpload(this.outputStream.toByteArray());
        this.outputStream.reset();
    }
}

