/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.cloud;

import com.google.common.annotations.VisibleForTesting;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.cloud.PipedStreamsManager;
import java.io.Closeable;
import java.io.IOException;
import java.io.PipedInputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CloudMultipartDownloader
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(CloudMultipartDownloader.class);
    private static final String GRAPHDB_CLOUD_RESTORE_THREAD_COUNT = "graphdb.cloud.restore.download.thread.count";
    protected static final int CONFIGURED_THREAD_COUNT;
    protected static final int DEFAULT_THREAD_COUNT = 4;
    protected ExecutorService executorService;
    protected final AtomicInteger lastChunk;
    protected final AtomicBoolean closed;
    protected final AtomicReference<Throwable> downloadError;
    protected final PipedStreamsManager pipedStreamsManager = new PipedStreamsManager();
    protected int chunkCounter = 0;

    public CloudMultipartDownloader() throws IOException {
        this.lastChunk = new AtomicInteger(0);
        this.closed = new AtomicBoolean(false);
        this.downloadError = new AtomicReference();
    }

    protected void init() {
        this.executorService = this.initDownloadingExecutor();
    }

    @Override
    public void close() throws IOException {
        this.pipedStreamsManager.closeOutputStream();
        this.pipedStreamsManager.closeInputStream();
        this.shutDownExecutor();
    }

    public PipedInputStream getPipedInputStream() {
        return this.pipedStreamsManager.getInputStream();
    }

    @VisibleForTesting
    public void NotifyAboutError(Throwable error) {
        this.downloadError.set(error);
    }

    private void shutDownExecutor() throws IOException {
        try {
            if (this.closed.compareAndSet(false, true)) {
                this.executorService.shutdown();
                if (!this.executorService.awaitTermination(3L, TimeUnit.SECONDS)) {
                    throw new IOException("Chunk download interrupted");
                }
                if (this.downloadError.get() != null) {
                    throw this.downloadError.get();
                }
                logger.debug("Backup multipart downloaded successfully");
            }
        }
        catch (Throwable e) {
            throw new IOException("Failed to complete multipart download", e);
        }
    }

    protected ExecutorService initDownloadingExecutor() {
        throw new RuntimeException("Method not implemented");
    }

    static {
        int threads = Config.getPropertyAsInt((String)GRAPHDB_CLOUD_RESTORE_THREAD_COUNT, (int)4);
        if (threads > 16 || threads < 4) {
            logger.warn("Invalid thread count \"{}\" for downloading a backup from cloud, switching to default value {}", (Object)threads, (Object)4);
            threads = 4;
        }
        CONFIGURED_THREAD_COUNT = threads;
    }
}

