/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.entitychange;

import com.google.common.annotations.VisibleForTesting;
import com.ontotext.trree.OwlimSchemaRepository;
import com.ontotext.trree.monitorRepository.MonitorRepository;
import com.ontotext.trree.plugin.externalsync.ExternalSyncPlugin;
import com.ontotext.trree.plugin.externalsync.api.ExternalStore;
import com.ontotext.trree.plugin.externalsync.impl.entitychange.EntityChangeInternalStore;
import com.ontotext.trree.plugin.externalsync.impl.entitychange.EntityChangeResult;
import com.ontotext.trree.plugin.externalsync.impl.entitychange.EntityChangeSearchOptions;
import com.ontotext.trree.plugin.externalsync.iterators.master.MasterResultIterator;
import com.ontotext.trree.plugin.externalsync.util.EntitiesUtil;
import com.ontotext.trree.sdk.HealthCheckable;
import com.ontotext.trree.sdk.HealthResult;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.sail.Sail;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class EntityChangePersistence
implements HealthCheckable {
    private static final IRI TX_AT = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/connectors/entity-change/at");
    private static final IRI TX_ID = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/connectors/entity-change/txId");
    private static final IRI ORIGINAL_TX = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/connectors/entity-change/originalTx");
    private static final IRI TX_CREATE = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/connectors/entity-change/added");
    private static final IRI TX_UPDATE = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/connectors/entity-change/updated");
    private static final IRI TX_REMOVE = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/connectors/entity-change/removed");
    private static final IRI LAST_OP = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/connectors/entity-change/lastOp");
    private static final IRI FIRST = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/connectors/entity-change/first");
    private static final IRI NEXT = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/connectors/entity-change/next");
    private static final IRI LAST = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/connectors/entity-change/last");
    private static final IRI CREATE = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/connectors/entity-change/create");
    private static final IRI UPDATE = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/connectors/entity-change/update");
    private static final IRI REMOVE = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/connectors/entity-change/remove");
    private static final RepositorySupplier DEFAULT_REPOSITORY_SUPPLIER;
    private static RepositorySupplier internalStoreSupplier;
    private final Logger logger;
    private final String storeName;
    private ExternalStore store;
    private EntityChangeInternalStore internalStore;
    private ValueFactory valueFactory;
    private IRI context;
    private final TransactionState txState = new TransactionState();

    private EntityChangePersistence(Logger logger, String storeName) {
        this.logger = logger;
        this.storeName = storeName;
    }

    void initialize(ExternalStore store, ExternalSyncPlugin syncPlugin) {
        this.store = store;
        this.internalStore = internalStoreSupplier.getStore(syncPlugin.getDataDir().toPath());
        this.valueFactory = this.internalStore.getValueFactory();
        this.context = this.valueFactory.createIRI("http://www.ontotext.com/connectors/entity-change/" + this.storeName);
        this.transactionStarted();
    }

    public void createStore() {
        if (this.store.isTestingTransaction()) {
            this.logger.info("[{}] Creating store..", (Object)this.storeName);
            this.internalStore.registerStore(this.storeName);
            this.transactionStarted();
        }
    }

    public void dropStore() {
        if (!this.internalStore.isInitialized()) {
            return;
        }
        if (this.store.isTestingTransaction()) {
            this.logger.info("[{}] Dropping store..", (Object)this.storeName);
            this.internalStore.dropStore(this.storeName);
        }
    }

    public EntityChangeResult query(MasterResultIterator mri) {
        EntityChangeSearchOptions searchOptions = (EntityChangeSearchOptions)mri.getSearchOptions();
        long subjectFilter = mri.getEntitySubjectFilter();
        String subjectMatch = null;
        if (subjectFilter != 0L) {
            subjectMatch = EntitiesUtil.valueToString((Value)mri.getEntities().get(subjectFilter));
        }
        return new EntityChangeResult(this.logger, searchOptions.offset, searchOptions.limit, subjectMatch, searchOptions.getTransaction(), searchOptions.getOperationNumber(), searchOptions.isAddOnly(), this);
    }

    List<IRI> getTransactionRange(@Nullable String initialTxId, int limit) {
        IRI initialTx = FIRST;
        if (initialTxId != null) {
            initialTx = EntityChangePersistence.createTxIri(this.valueFactory, initialTxId);
        }
        String query = this.buildQueryFromTemplate("?tx", "?initial :next+ ?tx. FILTER(?tx != :last).", 0, limit, Collections.emptyList(), null);
        try (RepositoryConnection connection = this.internalStore.getConnection();){
            List<IRI> list;
            block13: {
                TupleQuery tupleQuery = connection.prepareTupleQuery(query);
                tupleQuery.setBinding("initial", (Value)initialTx);
                TupleQueryResult evaluate = tupleQuery.evaluate();
                Stream stream = evaluate.stream();
                try {
                    list = stream.map(bindings -> bindings.getValue("tx")).map(IRI.class::cast).collect(Collectors.toList());
                    if (stream == null) break block13;
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stream.close();
            }
            return list;
        }
    }

    <R> List<R> getChangedEntities(List<IRI> transactionIds, @Nullable String subjectMatch, int offset, int limit, Function<BindingSet, R> resultMapper) {
        String projection = "?entity ?txId ?txAt ?op ?originalTx";
        Object body = "";
        if (subjectMatch != null) {
            body = String.format("bind(<%s> as ?entity). ", subjectMatch);
        }
        body = (String)body + " { ?entity :added ?tx . BIND(\"CREATE\" as ?op) } \n   UNION { ?entity :updated ?tx . BIND(\"UPDATE\" as ?op) } \n   UNION { ?entity :removed ?tx . BIND(\"DELETE\" as ?op) } \n   ?tx :at ?txAt ;\n       :txId ?txId ;\n       :originalTx ?originalTx .\n";
        String orderBy = null;
        if (transactionIds.size() > 1) {
            orderBy = " ORDER BY ASC(?txId) ";
        }
        String queryString = this.buildQueryFromTemplate(projection, (String)body, offset, limit, transactionIds, orderBy);
        return this.getEntities(queryString, resultMapper);
    }

    <R> List<R> getAddedEntities(List<IRI> transactionIds, @Nullable String subjectMatch, int offset, int limit, Function<BindingSet, R> resultMapper) {
        String projection = "?entity ?txId ?txAt ?op ?originalTx";
        Object body = "";
        if (subjectMatch != null) {
            body = String.format("BIND(<%s> AS ?entity). ", subjectMatch);
        }
        body = (String)body + " { ?entity :added ?tx . ?entity :lastOp :create . BIND(\"CREATE\" as ?op) } \n   UNION { ?entity :updated ?tx . ?entity :lastOp :update . BIND(\"UPDATE\" as ?op) } \n   ?tx :at ?txAt ;\n       :txId ?txId ;\n       :originalTx ?originalTx .\n";
        String orderBy = null;
        if (transactionIds.size() > 1) {
            orderBy = " ORDER BY ASC(?txId) ";
        }
        String queryString = this.buildQueryFromTemplate(projection, (String)body, offset, limit, transactionIds, orderBy);
        return this.getEntities(queryString, resultMapper);
    }

    @NotNull
    private <R> List<R> getEntities(String queryString, Function<BindingSet, R> resultMapper) {
        this.logger.trace(queryString);
        try (RepositoryConnection connection = this.internalStore.getConnection();){
            List list;
            block12: {
                TupleQuery query = connection.prepareTupleQuery(queryString);
                TupleQueryResult queryResult = query.evaluate();
                Stream bindingSetStream = queryResult.stream();
                try {
                    list = bindingSetStream.map(resultMapper).collect(Collectors.toList());
                    if (bindingSetStream == null) break block12;
                }
                catch (Throwable throwable) {
                    if (bindingSetStream != null) {
                        try {
                            bindingSetStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                bindingSetStream.close();
            }
            return list;
        }
    }

    long getExpectedTotalCount(List<IRI> transactionIds, boolean addOnly) {
        String projection = "(COUNT(?entity) as ?total_count)";
        String body = "?entity :added|:updated|:removed ?tx. ";
        if (addOnly) {
            body = " ?entity ?op ?tx .\n ?entity :lastOp ?lastOp .\n FILTER(?lastOp = :create || ?lastOp = :update).\n";
        }
        String query = this.buildQueryFromTemplate(projection, body, 0, 0, transactionIds, null);
        this.logger.trace(query);
        try (RepositoryConnection connection = this.internalStore.getConnection();){
            long l;
            block13: {
                TupleQueryResult result = connection.prepareTupleQuery(query).evaluate();
                Stream stream = result.stream();
                try {
                    l = stream.map(bindings -> bindings.getValue("total_count")).map(Literal.class::cast).map(Literal::longValue).findFirst().orElse(0L);
                    if (stream == null) break block13;
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stream.close();
            }
            return l;
        }
    }

    private String buildQueryFromTemplate(String projection, String body, int offset, int limit, List<IRI> transactionIds, @Nullable String orderBy) {
        Object query = String.format("BASE <%s/>\nPREFIX : <%1$s/>\nSELECT %s \nWHERE {\n  GRAPH <%s> {\n    %s  }\n}", "http://www.ontotext.com/connectors/entity-change", projection, this.storeName, body);
        if (orderBy != null) {
            query = (String)query + orderBy;
        }
        if (offset > 0) {
            query = (String)query + "\nOFFSET " + offset;
        }
        if (limit > 0) {
            query = (String)query + "\nLIMIT " + limit;
        }
        query = (String)query + EntityChangePersistence.buildQueryValues(transactionIds);
        return query;
    }

    private static String buildQueryValues(List<IRI> transactionIds) {
        if (transactionIds.isEmpty()) {
            return "";
        }
        int baseIriLength = "http://www.ontotext.com/connectors/entity-change".length() + 1;
        return transactionIds.stream().map(iri -> iri.toString().substring(baseIriLength)).collect(Collectors.joining("> <", "\nVALUES ?tx { <", "> }"));
    }

    public static EntityChangePersistence from(Logger logger, String storeName) {
        return new EntityChangePersistence(logger, storeName);
    }

    boolean contains(Resource resource) {
        if (this.store.isTestingTransaction()) {
            return this.getLastOperation(resource) != TxResourceOp.NOT_FOUND;
        }
        return false;
    }

    void delete(Value subject) {
        TxResourceOp lastOp;
        Resource subjectValue;
        if (this.store.isTestingTransaction() && (subjectValue = this.cloneResource(subject)) != null && (lastOp = this.getLastOperation(subjectValue)) != TxResourceOp.NOT_FOUND) {
            this.logger.debug("[{}] Mark entity as deleted: {}", (Object)this.storeName, (Object)subjectValue);
            this.txState.deleteEntity(subjectValue, lastOp);
        }
    }

    void deleteAll() {
        if (this.store.isTestingTransaction()) {
            this.logger.info("[{}] Clearing stored data", (Object)this.storeName);
            this.internalStore.deleteAll(this.storeName);
        }
    }

    public void index(Value subject, boolean wasJustCreated) {
        Resource subjectValue;
        if (this.store.isTestingTransaction() && (subjectValue = this.cloneResource(subject)) != null) {
            TxResourceOp lastOp;
            this.logger.debug("[{}] Indexing: {}", (Object)this.storeName, (Object)subject);
            TxResourceOp txResourceOp = lastOp = wasJustCreated ? TxResourceOp.NOT_FOUND : this.getLastOperation(subjectValue);
            if (lastOp == TxResourceOp.NOT_FOUND || TxResourceOp.DELETE_OP == lastOp) {
                this.txState.createEntity(subjectValue, lastOp);
            } else {
                assert (TxResourceOp.CREATE_OP == lastOp || TxResourceOp.UPDATE_OP == lastOp);
                this.txState.updateEntity(subjectValue, lastOp);
            }
        }
    }

    @NotNull
    private TxResourceOp getLastOperation(Resource subjectValue) {
        try (RepositoryConnection connection = this.internalStore.getConnection();){
            TxResourceOp txResourceOp;
            block12: {
                RepositoryResult statements = connection.getStatements(subjectValue, LAST_OP, null, false, new Resource[]{this.context});
                try {
                    txResourceOp = statements.stream().map(Statement::getObject).map(TxResourceOp::from).findFirst().orElse(TxResourceOp.NOT_FOUND);
                    if (statements == null) break block12;
                }
                catch (Throwable throwable) {
                    if (statements != null) {
                        try {
                            statements.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statements.close();
            }
            return txResourceOp;
        }
    }

    @Nullable
    private Resource cloneResource(Value subject) {
        IRI subjectValue;
        if (subject instanceof IRI) {
            subjectValue = this.valueFactory.createIRI(EntitiesUtil.valueToString((Value)subject));
        } else if (subject instanceof Triple) {
            Triple triple = (Triple)subject;
            subjectValue = this.valueFactory.createTriple(triple.getSubject(), triple.getPredicate(), triple.getObject());
        } else if (subject instanceof BNode) {
            subjectValue = null;
        } else {
            throw new IllegalArgumentException("Unsupported subject value " + String.valueOf(subject));
        }
        return subjectValue;
    }

    private static IRI createTxIri(ValueFactory factory, Object transaction) {
        return factory.createIRI("http://www.ontotext.com/connectors/entity-change/tx/" + String.valueOf(transaction));
    }

    public void transactionStarted() {
        if (!this.txState.hasActiveTx() || this.txState.isCommitted()) {
            this.txState.beginTransaction();
        }
    }

    void commit() {
        this.txState.commit();
    }

    void rollback() {
        this.logger.info("[{}] Rolling back transaction.", (Object)this.storeName);
        this.txState.reset();
    }

    public void rollbackCommitted() {
        this.txState.rollbackCommitted();
    }

    void close() {
        try {
            this.internalStore.close();
        }
        catch (Exception e) {
            this.logger.warn("Error closing repository connection (ignored)", (Throwable)e);
        }
    }

    public HealthResult runHealthCheck() {
        return new HealthResult(this.storeName, HealthResult.Status.GREEN, "All Good");
    }

    static void setInternalStoreSupplier(RepositorySupplier internalStoreSupplier) {
        EntityChangePersistence.internalStoreSupplier = internalStoreSupplier;
    }

    static void resetSupplier() {
        internalStoreSupplier = new CachedRepositorySupplier();
    }

    static void shutdown() {
        EntityChangeInternalStore store = internalStoreSupplier.getStore(null);
        if (store != null) {
            store.shutDown();
        }
    }

    static {
        internalStoreSupplier = DEFAULT_REPOSITORY_SUPPLIER = new CachedRepositorySupplier();
    }

    private class TransactionState {
        private TxState transaction;

        private TransactionState() {
        }

        boolean hasActiveTx() {
            return this.transaction != null;
        }

        boolean isCommitted() {
            return this.hasActiveTx() && this.transaction.isCommitted();
        }

        void beginTransaction() {
            if (this.transaction != null) {
                this.transaction.clear();
            }
            this.transaction = new TxState();
        }

        public void createEntity(Resource entityIri, TxResourceOp lastOp) {
            this.transaction.markEntityAsCreated(entityIri, lastOp);
        }

        public void updateEntity(Resource entityIri, TxResourceOp lastOp) {
            this.transaction.markEntityAsUpdated(entityIri, lastOp);
        }

        void deleteEntity(Resource iri, TxResourceOp lastOp) {
            this.transaction.markEntityAsRemoved(iri, lastOp);
        }

        void reset() {
            if (this.transaction != null) {
                this.transaction.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void rollbackCommitted() {
            if (this.isCommitted()) {
                EntityChangePersistence.this.logger.info("[{}] Rolling back changes of already committed transaction", (Object)EntityChangePersistence.this.storeName);
                try (EntityChangeInternalStore.DataWriter dataWriter = EntityChangePersistence.this.internalStore.getDataWriter(EntityChangePersistence.this.storeName, this.transaction.hasChanges());){
                    this.transaction.writeTo(dataWriter::remove, dataWriter::add, EntityChangePersistence.this.valueFactory, dataWriter::getCurrentTx);
                    dataWriter.decrementTx();
                }
                finally {
                    this.reset();
                }
            }
        }

        void commit() {
            if (this.hasActiveTx()) {
                EntityChangePersistence.this.logger.debug("[{}] Committing transaction with {} changes", (Object)EntityChangePersistence.this.storeName, (Object)this.transaction.size());
                this.transaction.markAsCommitted();
                try (EntityChangeInternalStore.DataWriter dataWriter = EntityChangePersistence.this.internalStore.getDataWriter(EntityChangePersistence.this.storeName, this.transaction.hasChanges());){
                    this.transaction.writeTo(dataWriter::add, dataWriter::remove, EntityChangePersistence.this.valueFactory, dataWriter::incrementTx, EntityChangePersistence.this.store.getTransaction());
                }
            }
        }
    }

    static interface RepositorySupplier {
        public EntityChangeInternalStore getStore(@Nullable Path var1);

        public Repository createRepository(Path var1);
    }

    private static enum TxResourceOp implements Supplier<Value>
    {
        CREATE_OP((Value)CREATE),
        UPDATE_OP((Value)UPDATE),
        DELETE_OP((Value)REMOVE),
        NOT_FOUND(null);

        private final Value op;

        private TxResourceOp(Value op) {
            this.op = op;
        }

        @Override
        public Value get() {
            return this.op;
        }

        static TxResourceOp from(Value resource) {
            if (CREATE.equals((Object)resource)) {
                return CREATE_OP;
            }
            if (UPDATE.equals((Object)resource)) {
                return UPDATE_OP;
            }
            return DELETE_OP;
        }
    }

    @VisibleForTesting
    static class CachedRepositorySupplier
    implements RepositorySupplier {
        private EntityChangeInternalStore entityChangeInternalStore;

        CachedRepositorySupplier() {
        }

        @Override
        public synchronized EntityChangeInternalStore getStore(@Nullable Path storeDir) {
            if (storeDir == null) {
                return this.entityChangeInternalStore;
            }
            if (this.entityChangeInternalStore == null) {
                this.entityChangeInternalStore = new EntityChangeInternalStore(this.createRepository(storeDir));
            }
            return this.entityChangeInternalStore;
        }

        @Override
        public Repository createRepository(Path storeDir) {
            OwlimSchemaRepository schemaRepository = new OwlimSchemaRepository();
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("skip-default-plugins", "true");
            parameters.put("register-external-plugins", "");
            parameters.put("ruleset", "empty");
            schemaRepository.setParameters(parameters);
            schemaRepository.setDataDir(storeDir.resolve("_persistence_").toFile());
            MonitorRepository monitorRepository = new MonitorRepository((Sail)schemaRepository);
            monitorRepository.init();
            return monitorRepository;
        }
    }

    private static class TxResource {
        final Resource resource;
        final TxResourceOp lastOp;
        final TxResourceOp newOp;

        private TxResource(Resource resource, TxResourceOp lastOp, TxResourceOp newOp) {
            this.resource = resource;
            this.lastOp = lastOp;
            this.newOp = newOp;
        }
    }

    private static class TxState {
        private boolean entityChanges = false;
        private boolean committed = false;
        private long txId;
        private IRI tx;
        private IRI previousTx;
        private Literal timestamp;
        private final List<TxResource> resources = new LinkedList<TxResource>();
        private long originalTx;

        private TxState() {
        }

        private void setTxData(long nextTx, Literal timestamp, ValueFactory valueFactory) {
            this.previousTx = FIRST;
            if (nextTx > 1L) {
                this.previousTx = EntityChangePersistence.createTxIri(valueFactory, nextTx - 1L);
            }
            this.txId = nextTx;
            this.tx = EntityChangePersistence.createTxIri(valueFactory, this.txId);
            this.timestamp = timestamp;
        }

        private void markForCommit() {
            this.entityChanges = true;
        }

        boolean hasChanges() {
            return this.entityChanges;
        }

        void markEntityAsRemoved(Resource resource, TxResourceOp lastOp) {
            this.markForCommit();
            this.resources.add(new TxResource(resource, lastOp, TxResourceOp.DELETE_OP));
        }

        void markEntityAsCreated(Resource resource, TxResourceOp lastOp) {
            this.markForCommit();
            this.resources.add(new TxResource(resource, lastOp, TxResourceOp.CREATE_OP));
        }

        void markEntityAsUpdated(Resource resource, TxResourceOp lastOp) {
            this.markForCommit();
            this.resources.add(new TxResource(resource, lastOp, TxResourceOp.UPDATE_OP));
        }

        void markAsCommitted() {
            this.committed = true;
        }

        void writeTo(Consumer<Statement> add, Consumer<Statement> remove, ValueFactory valueFactory, LongSupplier nextTx) {
            this.writeTo(add, remove, valueFactory, nextTx, this.originalTx);
        }

        void writeTo(Consumer<Statement> add, Consumer<Statement> remove, ValueFactory valueFactory, LongSupplier nextTx, long originalTx) {
            this.originalTx = originalTx;
            if (!this.entityChanges) {
                return;
            }
            this.setTxData(nextTx.getAsLong(), this.getNow(valueFactory), valueFactory);
            add.accept(valueFactory.createStatement((Resource)this.tx, TX_AT, (Value)this.timestamp));
            add.accept(valueFactory.createStatement((Resource)this.tx, NEXT, (Value)LAST));
            add.accept(valueFactory.createStatement((Resource)this.tx, TX_ID, (Value)valueFactory.createLiteral(this.txId)));
            add.accept(valueFactory.createStatement((Resource)this.tx, ORIGINAL_TX, (Value)valueFactory.createLiteral(originalTx)));
            add.accept(valueFactory.createStatement((Resource)this.previousTx, NEXT, (Value)this.tx));
            if (this.previousTx != FIRST) {
                remove.accept(valueFactory.createStatement((Resource)this.previousTx, NEXT, (Value)LAST));
            }
            for (TxResource txResource : this.resources) {
                this.writeResource(txResource, add, remove, valueFactory);
            }
        }

        private void writeResource(TxResource txResource, Consumer<Statement> add, Consumer<Statement> remove, ValueFactory valueFactory) {
            Resource resource = txResource.resource;
            TxResourceOp lastOp = txResource.lastOp;
            if (txResource.newOp == TxResourceOp.CREATE_OP) {
                add.accept(valueFactory.createStatement(resource, TX_CREATE, (Value)this.tx));
                add.accept(valueFactory.createStatement(resource, LAST_OP, (Value)CREATE));
                if (lastOp != TxResourceOp.NOT_FOUND) {
                    remove.accept(valueFactory.createStatement(resource, LAST_OP, lastOp.get()));
                }
            } else if (txResource.newOp == TxResourceOp.UPDATE_OP) {
                add.accept(valueFactory.createStatement(resource, TX_UPDATE, (Value)this.tx));
                if (lastOp == TxResourceOp.CREATE_OP) {
                    add.accept(valueFactory.createStatement(resource, LAST_OP, (Value)UPDATE));
                    remove.accept(valueFactory.createStatement(resource, LAST_OP, lastOp.get()));
                }
            } else {
                add.accept(valueFactory.createStatement(resource, TX_REMOVE, (Value)this.tx));
                add.accept(valueFactory.createStatement(resource, LAST_OP, (Value)REMOVE));
                if (lastOp != TxResourceOp.NOT_FOUND) {
                    remove.accept(valueFactory.createStatement(resource, LAST_OP, lastOp.get()));
                }
            }
        }

        private Literal getNow(ValueFactory valueFactory) {
            return valueFactory.createLiteral(new Date());
        }

        void clear() {
            this.committed = false;
            this.entityChanges = false;
            this.txId = -1L;
            this.tx = null;
            this.previousTx = null;
            this.timestamp = null;
            this.resources.clear();
        }

        int size() {
            return this.resources.size();
        }

        boolean isCommitted() {
            return this.committed;
        }
    }
}

