/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.sql.view;

import com.ontotext.forest.core.proxy.ProxyToRemoteSesame;
import com.ontotext.forest.sql.view.ColumnSuggestionForm;
import com.ontotext.forest.sql.view.SqlView;
import com.ontotext.forest.sql.view.SqlViewsService;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/rest/sql-views"})
@Controller
@Tag(name="SQL Views Management", description="Manage SQL views")
public class SqlViewsController {
    public static final String MAPPING = "/rest/sql-views";
    @Autowired
    private SqlViewsService sqlViewsService;
    @Autowired
    private ProxyToRemoteSesame proxyToRemoteSesame;

    @Hidden
    @PostMapping(value={"/columns"})
    public ResponseEntity<?> getSqlColumnNameSuggestions(@RequestBody String sparqlQuery, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return (ResponseEntity)this.proxyToRemoteSesame.proxyWithBodyToRemoteIfNeeded((Object)sparqlQuery, request, response, this.sqlViewsService.getDataManagement().getLocationFromHeaderOrThrow(), () -> new ResponseEntity(this.sqlViewsService.getSuggestedColumnNames(sparqlQuery), (HttpStatusCode)HttpStatus.OK));
    }

    @Hidden
    @PostMapping(value={"/types"})
    public ResponseEntity<?> getSqlColumnTypeSuggestions(@RequestParam(required=false, defaultValue="100") Integer limit, @RequestBody ColumnSuggestionForm columnSuggestion, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return (ResponseEntity)this.proxyToRemoteSesame.proxyWithBodyToRemoteIfNeeded((Object)columnSuggestion, request, response, this.sqlViewsService.getDataManagement().getLocationFromHeaderOrThrow(), () -> new ResponseEntity(this.sqlViewsService.getSuggestedColumnTypes(columnSuggestion.getQuery(), columnSuggestion.getColumns(), limit), (HttpStatusCode)HttpStatus.OK));
    }

    @Operation(summary="Get all SQL view names for current repository.", responses={@ApiResponse(responseCode="200", description="Found the SQL view", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=String.class)))})}, parameters={@Parameter(name="X-GraphDB-Repository", in=ParameterIn.HEADER, description="The repository for which you want to use the JDBC driver", required=true, schema=@Schema(type="string"))})
    @GetMapping(value={"/tables"})
    public ResponseEntity<?> getSqlViewNames(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return (ResponseEntity)this.proxyToRemoteSesame.proxyToRemoteIfNeeded(request, response, this.sqlViewsService.getDataManagement().getLocationFromHeaderOrThrow(), () -> new ResponseEntity(this.sqlViewsService.getAllSqlViewsNames(), (HttpStatusCode)HttpStatus.OK));
    }

    @Operation(summary="Get a SQL view configuration.", responses={@ApiResponse(responseCode="200", description="Found the SQL view", content={@Content(mediaType="application/json", schema=@Schema(implementation=SqlView.class))}), @ApiResponse(responseCode="404", description="SQL view not found", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})}, parameters={@Parameter(name="X-GraphDB-Repository", in=ParameterIn.HEADER, description="The repository for which you want to use the JDBC driver", required=true, schema=@Schema(type="string")), @Parameter(name="name", description="The name of the SQL view", required=true, in=ParameterIn.PATH, schema=@Schema(type="string"))})
    @GetMapping(value={"/tables/{name:.*}"})
    public ResponseEntity<?> getSqlView(@PathVariable String name, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return (ResponseEntity)this.proxyToRemoteSesame.proxyToRemoteIfNeeded(request, response, this.sqlViewsService.getDataManagement().getLocationFromHeaderOrThrow(), () -> {
            SqlView sqlView = this.sqlViewsService.getSqlView(name);
            if (sqlView != null) {
                return new ResponseEntity((Object)sqlView, (HttpStatusCode)HttpStatus.OK);
            }
            return new ResponseEntity((Object)String.format("SQL view '%s' does not exist", name), (HttpStatusCode)HttpStatus.NOT_FOUND);
        });
    }

    @Operation(summary="Delete an existing saved query", responses={@ApiResponse(responseCode="204", description="No Content", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})}, parameters={@Parameter(name="X-GraphDB-Repository", in=ParameterIn.HEADER, description="The repository for which you want to use the JDBC driver", required=true, schema=@Schema(type="string")), @Parameter(name="name", description="The name of the SQL view", required=true, in=ParameterIn.PATH, schema=@Schema(type="string"))})
    @DeleteMapping(value={"/tables/{name:.*}"})
    public ResponseEntity<?> deleteSqlView(@PathVariable String name, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return (ResponseEntity)this.proxyToRemoteSesame.proxyToRemoteIfNeeded(request, response, this.sqlViewsService.getDataManagement().getLocationFromHeaderOrThrow(), () -> {
            if (this.sqlViewsService.deleteSqlView(name)) {
                return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
            }
            return new ResponseEntity((Object)String.format("SQL view '%s' does not exist", name), (HttpStatusCode)HttpStatus.NOT_FOUND);
        });
    }

    @Operation(summary="Create a new SQL view", responses={@ApiResponse(responseCode="201", description="Created", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="409", description="Conflict", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})}, parameters={@Parameter(name="X-GraphDB-Repository", in=ParameterIn.HEADER, description="The repository for which you want to use the JDBC driver", required=true, schema=@Schema(type="string"))})
    @PostMapping(value={"/tables"})
    public ResponseEntity<?> createSqlView(@Valid @RequestBody SqlView sqlView, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return (ResponseEntity)this.proxyToRemoteSesame.proxyWithBodyToRemoteIfNeeded((Object)sqlView, request, response, this.sqlViewsService.getDataManagement().getLocationFromHeaderOrThrow(), () -> {
            if (this.sqlViewsService.createSqlView(sqlView)) {
                return new ResponseEntity((HttpStatusCode)HttpStatus.CREATED);
            }
            return new ResponseEntity((Object)("A SQL view with name: '" + sqlView.getName() + "' already exists."), (HttpStatusCode)HttpStatus.CONFLICT);
        });
    }

    @Operation(summary="Edit an existing SQL view", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})}, parameters={@Parameter(name="X-GraphDB-Repository", in=ParameterIn.HEADER, description="The repository for which you want to use the JDBC driver", required=true, schema=@Schema(type="string")), @Parameter(name="name", description="The name of the SQL view", required=true, in=ParameterIn.PATH, schema=@Schema(type="string"))})
    @PutMapping(value={"/tables/{name:.*}"})
    public ResponseEntity<String> updateSqlView(@PathVariable String name, @Valid @RequestBody SqlView sqlView, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (sqlView.getName() == null) {
            sqlView.setName(name);
        } else if (!name.equals(sqlView.getName())) {
            return new ResponseEntity((Object)"Conflicting IDs in URL and body", (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        return (ResponseEntity)this.proxyToRemoteSesame.proxyWithBodyToRemoteIfNeeded((Object)sqlView, request, response, this.sqlViewsService.getDataManagement().getLocationFromHeaderOrThrow(), () -> {
            if (this.sqlViewsService.updateSqlView(sqlView)) {
                return new ResponseEntity((Object)("Successfully edited '" + sqlView.getName() + "'"), (HttpStatusCode)HttpStatus.OK);
            }
            return new ResponseEntity((Object)String.format("SQL view '%s' does not exist", sqlView.getName()), (HttpStatusCode)HttpStatus.NOT_FOUND);
        });
    }

    @Hidden
    @GetMapping(value={"/preview/{name:.*}"}, produces={"application/sparql-results+json;charset=UTF-8"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public void getSqlTablePreview(@PathVariable String name, @RequestParam(value="limit", required=false, defaultValue="100") String limit, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.proxyToRemoteSesame.proxyToRemoteIfNeeded(request, response, this.sqlViewsService.getDataManagement().getLocationFromHeaderOrThrow(), () -> {
            SqlView sqlView = this.sqlViewsService.getSqlView(name);
            if (sqlView == null) {
                response.sendError(404, String.format("SQL view %s does not exist", name));
                return null;
            }
            this.sqlViewsService.writePreviewResultInResponseBody(sqlView, limit, false, response);
            return null;
        });
    }

    @Hidden
    @PostMapping(value={"/preview"}, produces={"application/sparql-results+json;charset=UTF-8"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public void getSqlTablePreview(@Valid @RequestBody SqlView sqlView, @RequestParam(value="limit", required=false, defaultValue="100") String limit, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.proxyToRemoteSesame.proxyToRemoteIfNeeded(request, response, this.sqlViewsService.getDataManagement().getLocationFromHeaderOrThrow(), () -> {
            this.sqlViewsService.writePreviewResultInResponseBody(sqlView, limit, true, response);
            return null;
        });
    }
}

