/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security.rest;

import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.forest.security.AuthenticatedUser;
import com.ontotext.forest.security.SecurityConfig;
import com.ontotext.forest.security.rest.UserLogin;
import com.ontotext.forest.security.stateless.GDBTokenAuthenticationService;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;

@Tag(name="Authentication", description="Handle user authentication")
@RequestMapping(value={"/rest/login"})
@Controller
public class StatelessLoginController {
    public static final String MAPPING = "/rest/login";
    @Autowired
    private GDBTokenAuthenticationService tokenAuthenticationService;
    @Qualifier(value="authenticationManager")
    @Autowired
    private AuthenticationManager authManager;
    @Autowired
    private SecurityConfig securityConfig;

    private String getUsernameFromRequest(HttpServletRequest request) {
        String requestURI;
        try {
            requestURI = URLDecoder.decode(request.getRequestURI(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new GraphDBWorkbenchException(e.getMessage(), (Throwable)e);
        }
        return requestURI.substring(requestURI.indexOf("/login/") + 7);
    }

    @PostMapping(value={"/**"})
    @Hidden
    public ResponseEntity<UserDetails> login(@RequestHeader(name="X-GraphDB-Password") String password, HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, GraphDBWorkbenchException {
        String username = this.getUsernameFromRequest(request);
        UserLogin userLogin = new UserLogin();
        userLogin.setUsername(username);
        userLogin.setPassword(password);
        return this.loginUser(userLogin, response);
    }

    @Operation(summary="Authenticate user with a password", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=AuthenticatedUser.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @PostMapping
    public ResponseEntity<UserDetails> loginUser(@RequestBody UserLogin userLogin, HttpServletResponse response) throws AuthenticationException, GraphDBWorkbenchException {
        if (!this.securityConfig.isGDBAuthEnabled()) {
            throw new GraphDBWorkbenchException("Cannot login when the GDB authentication method is OFF");
        }
        if (this.securityConfig.hasOverrideAuthority()) {
            throw new GraphDBWorkbenchException("Cannot authenticate when Override Authority is on.");
        }
        try {
            Authentication authentication = this.authManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)userLogin.getUsername(), (Object)userLogin.getPassword()));
            AuthenticatedUser authUser = (AuthenticatedUser)authentication.getPrincipal();
            authUser.setAuthorities(authUser.getExpandedAuthorities());
            this.tokenAuthenticationService.addAuthentication(response, authUser);
            SecurityContextHolder.getContext().setAuthentication(authentication);
            return new ResponseEntity((Object)authUser, (HttpStatusCode)HttpStatus.OK);
        }
        catch (AuthenticationException e) {
            SecurityContextHolder.clearContext();
            throw e;
        }
    }

    @ExceptionHandler(value={AuthenticationException.class})
    public ResponseEntity<String> handleBadCredentials(AuthenticationException e) {
        return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.UNAUTHORIZED);
    }
}

