/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security.provider.openid;

import com.ontotext.forest.core.AccountsService;
import com.ontotext.forest.security.AuthenticatedAuthenticationToken;
import java.util.Collection;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.jwt.Jwt;

public class OpenIdAuthenticationConverter
implements Converter<Jwt, AbstractAuthenticationToken> {
    private final String usernameClaim;
    private final AccountsService accountsService;

    OpenIdAuthenticationConverter(String usernameClaim, AccountsService accountsService) {
        this.usernameClaim = usernameClaim;
        this.accountsService = accountsService;
    }

    public AbstractAuthenticationToken convert(Jwt jwt) {
        String username = this.extractUsername(jwt);
        try {
            AuthenticatedAuthenticationToken token = this.accountsService.loadUserByUsername(username, this.extractAuthorities(jwt)).toAuthentication();
            return token;
        }
        catch (UsernameNotFoundException e) {
            throw new OAuth2AuthenticationException(new OAuth2Error("invalid_token", "Username '" + username + "' does not exist in the configured user database", "https://tools.ietf.org/html/rfc6750#section-3.1"), (Throwable)e);
        }
    }

    protected Collection<GrantedAuthority> extractAuthorities(Jwt jwt) {
        return null;
    }

    protected String extractUsername(Jwt jwt) {
        Object usernameClaimObject = jwt.getClaims().get(this.usernameClaim);
        if (usernameClaimObject == null) {
            throw new OAuth2AuthenticationException(new OAuth2Error("invalid_token", "An error occurred while attempting to decode the Jwt: Missing " + this.usernameClaim + " claim", "https://tools.ietf.org/html/rfc6750#section-3.1"));
        }
        return usernameClaimObject.toString();
    }
}

