/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security.provider.openid;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.ontotext.forest.core.AccountsService;
import com.ontotext.forest.security.provider.openid.OpenIdAuthenticationConverter;
import com.ontotext.graphdb.security.Role;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.jwt.Jwt;

public class OAuthAuthenticationConverter
extends OpenIdAuthenticationConverter {
    private final String rolesClaim;
    private final String rolePrefix;
    private final String roleSuffix;
    private final boolean bareCustomRoles;
    private final Set<GrantedAuthority> defaultRoles;

    OAuthAuthenticationConverter(AccountsService accountsService, String usernameClaim, String rolesClaim, String rolePrefix, String roleSuffix, String bareCustomRoles, String defaultRoles) {
        super(usernameClaim, accountsService);
        this.rolesClaim = rolesClaim;
        this.rolePrefix = StringUtils.isNotBlank((CharSequence)rolePrefix) ? rolePrefix : "";
        this.roleSuffix = StringUtils.isNotBlank((CharSequence)roleSuffix) ? roleSuffix : "";
        this.bareCustomRoles = Boolean.parseBoolean(bareCustomRoles);
        this.defaultRoles = StringUtils.isNotBlank((CharSequence)defaultRoles) ? Stream.of(defaultRoles.split("\\s*,\\s*")).map(SimpleGrantedAuthority::new).collect(Collectors.toSet()) : Collections.emptySet();
    }

    @Override
    protected Collection<GrantedAuthority> extractAuthorities(Jwt jwt) {
        Set<GrantedAuthority> authorities = this.getRoles(jwt).stream().filter(authority -> authority.startsWith(this.rolePrefix) && authority.endsWith(this.roleSuffix)).map(authority -> authority.substring(this.rolePrefix.length(), authority.length() - this.roleSuffix.length())).map(authority -> Role.normalizeRole((String)authority, (boolean)this.bareCustomRoles)).map(SimpleGrantedAuthority::new).collect(Collectors.toSet());
        authorities.addAll(this.defaultRoles);
        return authorities;
    }

    private Collection<String> getRoles(Jwt jwt) {
        try {
            JsonPath jsonPath = JsonPath.compile((String)this.rolesClaim, (Predicate[])new Predicate[0]);
            Object roles = jsonPath.read((Object)jwt.getClaims());
            if (roles instanceof String) {
                if (StringUtils.isNotBlank((CharSequence)((String)roles))) {
                    return Arrays.asList(((String)roles).split(" "));
                }
                return Collections.emptyList();
            }
            if (roles instanceof Collection) {
                return (Collection)roles;
            }
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        throw new OAuth2AuthenticationException(new OAuth2Error("invalid_token", "An error occurred while attempting to decode the Jwt: Missing " + this.rolesClaim + " claim", "https://tools.ietf.org/html/rfc6750#section-3.1"));
    }
}

