/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security.provider.openid;

import com.ontotext.forest.security.MainAuthenticationFilter;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.server.resource.web.BearerTokenAuthenticationEntryPoint;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.util.StringUtils;

public class LoggingBearerTokenAuthenticationEntryPoint
implements AuthenticationEntryPoint {
    private Logger logger = LoggerFactory.getLogger(MainAuthenticationFilter.class);
    private AuthenticationEntryPoint delegate = new BearerTokenAuthenticationEntryPoint();

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        this.delegate.commence(request, response, authException);
        if (authException instanceof OAuth2AuthenticationException) {
            OAuth2Error error = ((OAuth2AuthenticationException)authException).getError();
            String errorCode = error.getErrorCode();
            String description = error.getDescription();
            if (StringUtils.hasText((String)description)) {
                this.logger.warn("OpenID authentication error ({}): {}", (Object)errorCode, (Object)description);
            } else {
                this.logger.warn("OpenID authentication error ({})", (Object)errorCode);
            }
        }
    }
}

