/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security.acl;

import com.ontotext.forest.core.proxy.ProxyToRemoteSesame;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.semantic.SemanticLocation;
import com.ontotext.forest.security.acl.AccessControlService;
import com.ontotext.graphdb.security.AccessControlEntry;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/rest/repositories/"})
@RestController
@Tag(name="Access Control List Management", description="Manage fine-grained access control lists (ACLs) for repositories")
public class ACLController {
    public static final String REPOSITORY_ID_NAME = "repositoryID";
    public static final String REST_REPOSITORIES_URL = "/rest/repositories/";
    public static final String DUPLICATE_RULES_ERROR_MSG = "Every ACL rule should be unique.";
    @Autowired
    private SemanticDataManagement semanticDataManagement;
    @Autowired
    private ProxyToRemoteSesame proxyToRemoteSesame;
    @Autowired
    private AccessControlService accessControlService;

    @Operation(summary="List ACL rules for a repository", responses={@ApiResponse(responseCode="200", description="Found ACL rules for the repository", content={@Content(array=@ArraySchema(schema=@Schema(implementation=AccessControlEntry.class)))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content})})
    @GetMapping(value={"{repositoryID}/acl"}, produces={"application/json"})
    public ResponseEntity<?> listAclRules(@PathVariable(value="repositoryID") String repoId, @RequestParam(required=false) String scope, @RequestParam(required=false) String operation, @RequestParam(required=false) String subject, @RequestParam(required=false) String predicate, @RequestParam(required=false) String object, @RequestParam(required=false) String context, @RequestParam(required=false) String plugin, @RequestParam(required=false) String role, @RequestParam(required=false) String policy, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SemanticLocation semanticLocation = this.semanticDataManagement.getLocationFromHeaderOrThrow();
        return (ResponseEntity)this.proxyToRemoteSesame.proxyToRemoteIfNeeded(request, response, semanticLocation, () -> new ResponseEntity(this.accessControlService.listAclRules(repoId, semanticLocation, scope, operation, subject, predicate, object, context, plugin, role, policy), (HttpStatusCode)HttpStatus.OK));
    }

    @Operation(summary="Add ACL rules to a repository", responses={@ApiResponse(responseCode="201", description="Created", content={@Content}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="500", description="Internal Server Error", content={@Content})})
    @PostMapping(value={"{repositoryID}/acl"}, consumes={"application/json"})
    public ResponseEntity<?> addAclRules(@PathVariable(value="repositoryID") String repoId, @RequestParam(required=false) Integer position, @RequestBody List<AccessControlEntry> aclRulesToUpdate, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SemanticLocation semanticLocation = this.semanticDataManagement.getLocationFromHeaderOrThrow();
        return (ResponseEntity)this.proxyToRemoteSesame.proxyWithBodyToRemoteIfNeeded(aclRulesToUpdate, request, response, semanticLocation, () -> {
            try {
                this.accessControlService.addAclRules(repoId, semanticLocation, aclRulesToUpdate, position);
                return new ResponseEntity((HttpStatusCode)HttpStatus.CREATED);
            }
            catch (IllegalArgumentException e) {
                return new ResponseEntity((Object)DUPLICATE_RULES_ERROR_MSG, (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
        });
    }

    @Operation(summary="Delete ACL rules from a repository", responses={@ApiResponse(responseCode="204", description="No content", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="500", description="Internal Server Error", content={@Content})})
    @DeleteMapping(value={"{repositoryID}/acl"}, consumes={"application/json"})
    public ResponseEntity<?> deleteAclRules(@PathVariable(value="repositoryID") String repoId, @RequestBody List<AccessControlEntry> aclRulesToDelete, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SemanticLocation semanticLocation = this.semanticDataManagement.getLocationFromHeaderOrThrow();
        return (ResponseEntity)this.proxyToRemoteSesame.proxyWithBodyToRemoteIfNeeded(aclRulesToDelete, request, response, semanticLocation, () -> {
            this.accessControlService.deleteAclRules(repoId, semanticLocation, aclRulesToDelete);
            return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
        });
    }

    @Operation(summary="Set ACL rules of a repository", responses={@ApiResponse(responseCode="200", description="OK", content={@Content}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="500", description="Internal Server Error", content={@Content})})
    @PutMapping(value={"{repositoryID}/acl"}, consumes={"application/json"})
    public ResponseEntity<?> updateAclRules(@PathVariable(value="repositoryID") String repoId, @io.swagger.v3.oas.annotations.parameters.RequestBody @RequestBody List<AccessControlEntry> aclRulesToUpdate, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SemanticLocation semanticLocation = this.semanticDataManagement.getLocationFromHeaderOrThrow();
        return (ResponseEntity)this.proxyToRemoteSesame.proxyWithBodyToRemoteIfNeeded(aclRulesToUpdate, request, response, semanticLocation, () -> {
            try {
                this.accessControlService.updateAclRules(repoId, semanticLocation, aclRulesToUpdate);
                return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
            }
            catch (IllegalArgumentException e) {
                return new ResponseEntity((Object)DUPLICATE_RULES_ERROR_MSG, (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
        });
    }
}

