/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security;

import com.ontotext.forest.security.AuthenticatedUser;
import com.ontotext.forest.security.SecurityConfig;
import com.ontotext.forest.security.audit.AuditUtils;
import com.ontotext.forest.security.stateless.AuthenticationExpiredException;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;

public class MainAuthenticationEntryPoint
implements AuthenticationEntryPoint,
AuthenticationFailureHandler,
AccessDeniedHandler {
    private static Logger LOGGER = LoggerFactory.getLogger(MainAuthenticationEntryPoint.class);
    @Autowired
    private SecurityConfig securityConfig;

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        if (authException instanceof AuthenticationExpiredException) {
            LOGGER.debug("Credentials expired", (Throwable)authException);
            response.sendError(401, authException.getMessage());
        } else {
            LOGGER.debug("Invalid or missing credentials", (Throwable)authException);
            this.addAuthenticateHeaders(request, response);
        }
        AuditUtils.markRequestForAudit(request);
    }

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        this.commence(request, response, exception);
    }

    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException e) throws IOException, ServletException {
        Object principal;
        boolean overrideForbidden = false;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && (principal = authentication.getPrincipal()) instanceof AuthenticatedUser && this.securityConfig.isUsernameFreeAccess(((AuthenticatedUser)principal).getUsername())) {
            overrideForbidden = true;
        }
        if (overrideForbidden) {
            this.addAuthenticateHeaders(request, response);
        } else {
            response.sendError(403);
        }
    }

    private void addAuthenticateHeaders(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.securityConfig.isBasicAuthEnabled() && !"XMLHttpRequest".equals(request.getHeader("x-requested-with"))) {
            response.addHeader("WWW-Authenticate", "Basic realm=\"GraphDB REST API endpoint\"");
        }
        if (this.securityConfig.isGDBAuthEnabled()) {
            response.addHeader("WWW-Authenticate", "GDB");
        }
        if (this.securityConfig.isKerberosAuthEnabled()) {
            response.addHeader("WWW-Authenticate", "Negotiate");
        }
        if (this.securityConfig.isOpenIdAuthEnabled()) {
            response.addHeader("WWW-Authenticate", "Bearer");
        }
        response.sendError(401);
    }
}

