/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.lucene4;

import com.ontotext.trree.plugin.externalsync.impl.lucene4.Lucene4ExternalStore;
import com.ontotext.trree.plugin.externalsync.impl.lucene4.SmartMultiFieldQueryParser;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.charfilter.HTMLStripCharFilter;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

final class QueryUtils {
    public static Analyzer createSearchAnalyzer(Analyzer defaultAnalyzer) {
        HashMap analyzersMap = new HashMap();
        if (analyzersMap.size() > 0) {
            return new PerFieldAnalyzerWrapper(defaultAnalyzer, analyzersMap);
        }
        return defaultAnalyzer;
    }

    public static QueryParser createQueryParser(Lucene4ExternalStore externalStore, Map<String, Float> boosts) {
        SmartMultiFieldQueryParser queryParser = new SmartMultiFieldQueryParser(externalStore, boosts);
        queryParser.setAllowLeadingWildcard(true);
        return queryParser;
    }

    public static Query parseChainUpdateQuery(String chainField, long chainValue) {
        return new TermQuery(new Term(chainField, Long.toString(chainValue)));
    }

    public static String stripMarkup(String s) {
        String string;
        HTMLStripCharFilter filter = new HTMLStripCharFilter((Reader)new StringReader(s));
        try {
            string = IOUtils.toString((Reader)filter);
        }
        catch (Throwable throwable) {
            try {
                try {
                    filter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return s;
            }
        }
        filter.close();
        return string;
    }

    private QueryUtils() {
    }

    public static class ThreadLocalQueryParser
    extends ThreadLocal<QueryParser> {
        private final Lucene4ExternalStore externalStore;
        private final Map<String, Float> boosts;

        public ThreadLocalQueryParser(Lucene4ExternalStore externalStore, Map<String, Float> boosts) {
            this.externalStore = externalStore;
            this.boosts = boosts;
        }

        @Override
        protected QueryParser initialValue() {
            return QueryUtils.createQueryParser(this.externalStore, this.boosts);
        }
    }
}

