/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.lucene4;

import com.ontotext.trree.plugin.externalsync.ExternalSyncRequestContext;
import com.ontotext.trree.plugin.externalsync.SearchOptions;
import com.ontotext.trree.plugin.externalsync.api.DocumentsResult;
import com.ontotext.trree.plugin.externalsync.api.ExternalStore;
import com.ontotext.trree.plugin.externalsync.api.Facet;
import com.ontotext.trree.plugin.externalsync.api.FlexibleBucket;
import com.ontotext.trree.plugin.externalsync.api.FlexibleBucketItem;
import com.ontotext.trree.plugin.externalsync.impl.AbstractExternalRetrieve;
import com.ontotext.trree.plugin.externalsync.impl.lucene4.Lucene4ExternalStore;
import com.ontotext.trree.plugin.externalsync.impl.lucene4.Lucene4Result;
import com.ontotext.trree.plugin.externalsync.impl.lucene4.Lucene4SearchOptions;
import com.ontotext.trree.plugin.externalsync.impl.lucene4.hl.HLHelperFastVector;
import com.ontotext.trree.plugin.externalsync.iterators.master.MasterResultIterator;
import com.ontotext.trree.plugin.externalsync.util.EntitiesUtil;
import com.ontotext.trree.sdk.PluginException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.expressions.Bindings;
import org.apache.lucene.expressions.SimpleBindings;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.facet.taxonomy.FastTaxonomyFacetCounts;
import org.apache.lucene.facet.taxonomy.SearcherTaxonomyManager;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionQuery;
import org.apache.lucene.queries.function.FunctionScoreQuery;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.slf4j.Logger;

public final class Lucene4ExternalRetrieve
extends AbstractExternalRetrieve {
    private static final boolean DOCS_IN_ORDER = false;
    private static final SortField SORT_FIELD_SCORE_REVERSE = new SortField(null, SortField.Type.SCORE, true);
    private final Lucene4ExternalStore handler;
    private final FacetsConfig facetsConfig;
    private Query query;
    private Query snippetQuery;
    private SearcherTaxonomyManager.SearcherAndTaxonomy searcher = null;
    private Lucene4Result documentsResult = null;
    private List<Facet> facets = null;

    public Lucene4ExternalRetrieve(Logger logger, Lucene4ExternalStore store, MasterResultIterator mri, ExternalSyncRequestContext requestContext, Lucene4ExternalStore handler) {
        super(logger, (ExternalStore)store, mri, requestContext);
        this.handler = handler;
        this.facetsConfig = handler.getFacetsConfig();
    }

    public synchronized void doSearch() {
        if (this.query != null) {
            return;
        }
        try {
            this.searcher = this.handler.acquireSearcher();
            try {
                this.trySearch(true);
            }
            catch (BooleanQuery.TooManyClauses e) {
                this.trySearch(false);
            }
        }
        catch (IOException e) {
            throw this.logErrorAndCreateException("Search failed", e);
        }
    }

    private void trySearch(boolean scoreBQRewriteHint) throws IOException {
        Lucene4SearchOptions options = (Lucene4SearchOptions)this.mri.getSearchOptions();
        int offset = options.offset;
        int limit = options.limit;
        if (limit == 0) {
            limit = Integer.MAX_VALUE;
        }
        this.createLuceneQuery(scoreBQRewriteHint, options);
        TopDocsCollector<? extends ScoreDoc> topDocsCollector = this.createTopDocCollector(options, offset, limit);
        ArrayList<FacetResult> facetResults = new ArrayList<FacetResult>();
        this.facets = new ArrayList<Facet>();
        if (options.facets.size() > 0) {
            FacetsCollector facetsCollector = new FacetsCollector();
            Collector collector = MultiCollector.wrap((Collector[])new Collector[]{topDocsCollector, facetsCollector});
            this.searcher.searcher.search(this.query, collector);
            FastTaxonomyFacetCounts facetsPrepare = new FastTaxonomyFacetCounts((TaxonomyReader)this.searcher.taxonomyReader, this.facetsConfig, facetsCollector);
            for (String facet : options.facets) {
                FacetResult topChild = facetsPrepare.getTopChildren(options.facetLimit, facet, new String[0]);
                if (topChild == null) continue;
                facetResults.add(topChild);
            }
            for (FacetResult fResult : facetResults) {
                for (LabelAndValue lv : fResult.labelValues) {
                    long facetFieldId = this.createRequestEntity(fResult.dim);
                    long facetValueId = this.getFacetValueIdFromFieldValue(fResult.dim, lv.label);
                    this.facets.add(new Facet(facetFieldId, facetValueId, lv.value.longValue()));
                    FlexibleBucket fb = this.createBucket(FlexibleBucket.FlexibleBucketType.FACET, this.createRequestBNode(), facetFieldId, 0L, 0L);
                    fb.setItem(FlexibleBucketItem.KEY_OR_VALUE, facetValueId);
                    fb.setItem(FlexibleBucketItem.COUNT, this.createRequestEntity(lv.value));
                    this.faHolder.add(fb);
                }
            }
        } else {
            this.searcher.searcher.search(this.query, topDocsCollector);
        }
        HLHelperFastVector hlHelper = new HLHelperFastVector(this.handler.indexedFieldsArray, this.getSnippetQuery(), this.searcher.searcher, options.snippetPre, options.snippetPost, options.snippetSize);
        TopDocs topDocs = topDocsCollector.topDocs(offset, limit);
        if (this.requestContext.isTrackScore() && topDocsCollector instanceof TopFieldCollector) {
            TopFieldCollector.populateScores((ScoreDoc[])topDocs.scoreDocs, (IndexSearcher)this.searcher.searcher, (Query)this.query);
        }
        this.documentsResult = new Lucene4Result(this.handler.getName(), this.logger, this.searcher.searcher, topDocs, hlHelper);
    }

    private void createLuceneQuery(boolean scoreBQRewriteHint, Lucene4SearchOptions options) throws IOException {
        Object parsedQuery;
        String queryStr = this.mri.getQueryString();
        long subjectFilter = this.mri.getEntitySubjectFilter();
        try {
            parsedQuery = queryStr == null || queryStr.isEmpty() ? new MatchAllDocsQuery() : this.handler.parseQuery(queryStr, options, scoreBQRewriteHint);
        }
        catch (ParseException e) {
            throw this.logErrorAndCreateException(String.format("Cannot parse Lucene query [%s]", queryStr), (Exception)((Object)e));
        }
        this.snippetQuery = parsedQuery;
        if (subjectFilter != 0L) {
            BooleanQuery.Builder bbq = new BooleanQuery.Builder();
            bbq.add((Query)parsedQuery, BooleanClause.Occur.MUST);
            bbq.add((Query)new TermQuery(this.handler.getSubjectTerm(EntitiesUtil.valueToString((Value)this.mri.getEntities().get(subjectFilter)))), BooleanClause.Occur.MUST);
            this.query = bbq.build();
        } else {
            this.query = this.wrapQueryForCustomScore((Query)parsedQuery, options);
        }
    }

    private Query wrapQueryForCustomScore(Query searchQuery, Lucene4SearchOptions options) throws IOException {
        FunctionQuery docBoostScoringQuery = this.handler.getDocBoostScoringQuery();
        if (options.scoreExpr == null) {
            if (docBoostScoringQuery != null) {
                return FunctionScoreQuery.boostByValue((Query)searchQuery, (DoubleValuesSource)DoubleValuesSource.fromQuery((Query)docBoostScoringQuery));
            }
            return searchQuery;
        }
        SimpleBindings simpleBindings = new SimpleBindings();
        simpleBindings.add("boost", docBoostScoringQuery != null ? DoubleValuesSource.fromQuery((Query)docBoostScoringQuery).rewrite(this.searcher.searcher) : DoubleValuesSource.constant((double)1.0));
        simpleBindings.add("score", DoubleValuesSource.SCORES);
        return new FunctionScoreQuery(searchQuery, options.expression.getDoubleValuesSource((Bindings)simpleBindings));
    }

    private int getActualNumTopDocs(int offset, int limit) {
        int nDocs = this.searcher.searcher.getIndexReader().maxDoc();
        if (limit < nDocs) {
            nDocs = limit + offset;
        }
        return nDocs == 0 ? 1 : nDocs;
    }

    private TopDocsCollector<? extends ScoreDoc> createTopDocCollector(SearchOptions options, int offset, int limit) throws IOException {
        return this.isCustomSorted(options) ? this.createTopFieldCollector(options, offset, limit) : this.createTopScoreDocCollector(offset, limit);
    }

    private TopDocsCollector<? extends ScoreDoc> createTopScoreDocCollector(int offset, int limit) {
        int numTopDocs = this.getActualNumTopDocs(offset, limit);
        return TopScoreDocCollector.create((int)numTopDocs, (int)(this.requestContext.isTrackTotalHits() ? Integer.MAX_VALUE : numTopDocs));
    }

    private TopDocsCollector<? extends ScoreDoc> createTopFieldCollector(SearchOptions options, int offset, int limit) throws IOException {
        Sort sort = this.createCustomSort(options);
        int numTopDocs = this.getActualNumTopDocs(offset, limit);
        return TopFieldCollector.create((Sort)sort, (int)numTopDocs, (int)(this.requestContext.isTrackTotalHits() ? Integer.MAX_VALUE : numTopDocs));
    }

    private Sort createCustomSort(SearchOptions options) {
        SortField[] sortFields = new SortField[options.orderBy.size()];
        if (sortFields.length > 0) {
            Map<String, DocValuesType> docValueTypes = Collections.emptyMap();
            for (LeafReaderContext rc : this.searcher.searcher.getIndexReader().leaves()) {
                LeafReader ar = rc.reader();
                FieldInfos fis = ar.getFieldInfos();
                docValueTypes = new HashMap(fis.size());
                for (FieldInfo fi : fis) {
                    docValueTypes.put(fi.name, fi.getDocValuesType());
                }
            }
            for (int i = 0; i < sortFields.length; ++i) {
                SearchOptions.OrderPredicate op = (SearchOptions.OrderPredicate)options.orderBy.get(i);
                if (op.isScoreSpecial()) {
                    sortFields[i] = op.reverse ? SORT_FIELD_SCORE_REVERSE : SortField.FIELD_SCORE;
                    continue;
                }
                DocValuesType dvt = (DocValuesType)docValueTypes.get(op.predicate);
                if (dvt == DocValuesType.SORTED) {
                    sortFields[i] = new SortField(op.predicate, SortField.Type.STRING, op.reverse);
                    continue;
                }
                if (dvt == DocValuesType.NUMERIC) {
                    String type = ((Lucene4ExternalStore)this.externalStore).fieldTypes.get(op.predicate);
                    sortFields[i] = new SortField(op.predicate, switch (type != null ? type : "") {
                        case "long", "date", "dateTime" -> SortField.Type.LONG;
                        case "int" -> SortField.Type.INT;
                        case "double" -> SortField.Type.DOUBLE;
                        case "float" -> SortField.Type.FLOAT;
                        default -> SortField.Type.STRING;
                    }, op.reverse);
                    continue;
                }
                if (dvt != null) {
                    throw new PluginException(String.format("Unable to sort by '%s' in Lucene. Fields for sorting must be defined with multivalued = false.", op.predicate));
                }
                throw new PluginException(String.format("Unable to sort by '%s' in Lucene. No documents contain that field.", op.predicate));
            }
        }
        return new Sort(sortFields);
    }

    private boolean isCustomSorted(SearchOptions options) {
        return options.orderBy.size() > 0;
    }

    public synchronized void close() {
        this.releaseSearcher();
    }

    private void releaseSearcher() {
        if (this.searcher != null) {
            this.handler.releaseSearcherQuietly(this.searcher);
            this.searcher = null;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    Query getSnippetQuery() {
        return this.snippetQuery;
    }

    public List<Facet> getFacets() {
        return this.facets;
    }

    public DocumentsResult getDocumentsResult() {
        return this.documentsResult;
    }

    private long getFacetValueIdFromFieldValue(String fieldName, String fieldValue) {
        IRI v;
        if (this.externalStore.isFieldURI(fieldName)) {
            v = this.valueFactory.createIRI(fieldValue);
        } else {
            IRI type = null;
            v = this.valueFactory.createLiteral(fieldValue, type);
        }
        return this.createRequestEntity((Value)v);
    }
}

