/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.lucene4;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.store.Directory;

class Keep2CommitsPolicy
extends IndexDeletionPolicy {
    Keep2CommitsPolicy() {
    }

    public void onInit(List<? extends IndexCommit> commits) throws IOException {
        this.deleteToIndex(commits, commits.size() - 1);
    }

    public void onCommit(List<? extends IndexCommit> commits) throws IOException {
        this.deleteToIndex(commits, commits.size() - 2);
    }

    private void deleteToIndex(List<? extends IndexCommit> commits, int to) {
        for (int i = 0; i < to; ++i) {
            commits.get(i).delete();
        }
    }

    public static IndexCommit getPreviousCommit(Directory luceneDir) throws IOException {
        List commits = DirectoryReader.listCommits((Directory)luceneDir);
        int numCommits = commits.size();
        for (IndexCommit commit : commits) {
            if (--numCommits != 1) continue;
            return commit;
        }
        return null;
    }
}

