/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.lucene4;

import com.ontotext.trree.sdk.ClientErrorException;
import java.lang.reflect.Constructor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CreateAnalyzerUtil {
    private static final Logger LOG = LoggerFactory.getLogger(CreateAnalyzerUtil.class);

    @Nonnull
    public static Analyzer createAnalyzerFromClassName(@Nullable String analyzerClassName) {
        if (analyzerClassName != null && !"".equals(analyzerClassName)) {
            Class<?> analyzerClass;
            try {
                analyzerClass = Class.forName(analyzerClassName);
            }
            catch (ClassNotFoundException e) {
                throw new ClientErrorException("Cannot load analyzer class: " + analyzerClassName, (Throwable)e);
            }
            if (Analyzer.class.isAssignableFrom(analyzerClass)) {
                return CreateAnalyzerUtil.instantiateAnalyzer(analyzerClass);
            }
            throw new ClientErrorException("Invalid analyzer class specified - should be either Analyzer or AnalyzerFactory implementation");
        }
        return new StandardAnalyzer();
    }

    private static Analyzer instantiateAnalyzer(Class<?> analyzerClass) {
        try {
            return (Analyzer)analyzerClass.newInstance();
        }
        catch (Exception e) {
            LOG.debug("Simple creation strategy for class {} failed with {}", (Object)analyzerClass.getName(), (Object)e.getMessage());
            try {
                Constructor<?> versionConstructor = analyzerClass.getConstructor(Version.class);
                return (Analyzer)versionConstructor.newInstance(Version.LATEST);
            }
            catch (Exception e2) {
                LOG.debug(String.format("Creation of analyzer for class %s with just a version parameter failed with %s", analyzerClass.getName(), e2.getMessage()));
                throw new ClientErrorException("Unable to instantiate analyzer class, only analyzers with a default constructor or a constructor accepting single Version parameter are possible: " + analyzerClass.getName());
            }
        }
    }

    private CreateAnalyzerUtil() {
    }
}

