/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.registry;

import com.ontotext.metamodel.SomlSchemaIdManager;
import com.ontotext.metamodel.storage.SomlSchemaStorage;
import com.ontotext.metamodel.storage.SomlStoreException;
import com.ontotext.metamodel.storage.UnreachableStoreException;
import com.ontotext.platform.registry.ServiceRegistry;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServiceRegistry
implements ServiceRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultServiceRegistry.class);
    private final SomlSchemaStorage schemaStorage;
    private final SomlSchemaIdManager schemaIdManager;

    public DefaultServiceRegistry(SomlSchemaStorage schemaStorage, SomlSchemaIdManager schemaIdManager) {
        this.schemaStorage = schemaStorage;
        this.schemaIdManager = schemaIdManager;
    }

    @Override
    public List<String> getRegisteredForBound() throws UnreachableStoreException {
        Optional id = this.schemaIdManager.getId();
        if (id.isPresent()) {
            return this.getRegisteredFor((String)id.get());
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getRegisteredFor(String somlId) throws UnreachableStoreException {
        try {
            return this.schemaStorage.getRegisteredSchemaServices(somlId);
        }
        catch (UnreachableStoreException use) {
            throw use;
        }
        catch (SomlStoreException sse) {
            LOGGER.warn("There is no SOML with id: {}", (Object)somlId);
            LOGGER.trace("", (Throwable)sse);
            return Collections.emptyList();
        }
    }
}

