/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.query.monitoring;

import com.ontotext.soaas.query.monitoring.TimeSample;

public interface QueryMeter {
    public static QueryMeter noOpMeter() {
        return NoOpQueryMeter.NO_OP_METER;
    }

    public TimeSample startSample();

    public void trackQueryProcessing(TimeSample var1, String var2);

    public void trackQueryParsing(TimeSample var1, String var2);

    public void trackDataGenrating(TimeSample var1, String var2);

    public void trackQueryValidating(TimeSample var1, String var2);

    public void trackQueryCompiling(TimeSample var1, String var2);

    public void trackQueryExecution(TimeSample var1, String var2);

    public void trackQueryTransforming(TimeSample var1, String var2);

    public static class NoOpQueryMeter
    implements QueryMeter {
        static final QueryMeter NO_OP_METER = new NoOpQueryMeter();
        private static final TimeSample EMPTY_TIME_SAMPLE = timer -> {};

        @Override
        public TimeSample startSample() {
            return EMPTY_TIME_SAMPLE;
        }

        @Override
        public void trackQueryProcessing(TimeSample sample, String operationName) {
        }

        @Override
        public void trackQueryParsing(TimeSample sample, String operationName) {
        }

        @Override
        public void trackDataGenrating(TimeSample sample, String operationName) {
        }

        @Override
        public void trackQueryValidating(TimeSample sample, String operationName) {
        }

        @Override
        public void trackQueryCompiling(TimeSample sample, String operationName) {
        }

        @Override
        public void trackQueryExecution(TimeSample sample, String operationName) {
        }

        @Override
        public void trackQueryTransforming(TimeSample sample, String operationName) {
        }
    }
}

